/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.test.webdriver;

import java.net.InetSocketAddress;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.test.webdriver.BaseTestCase;

public class SingletonServer
implements BeforeAllCallback,
ExtensionContext.Store.CloseableResource {
    private static final Logger log = LoggerFactory.getLogger(SingletonServer.class);
    private static volatile Server server;
    private static final Lock LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAll(ExtensionContext eContext) throws Exception {
        LOCK.lock();
        try {
            if (server == null) {
                server = new Server(new InetSocketAddress(BaseTestCase.getHost(), Integer.parseInt(BaseTestCase.getServerPort())));
                WebAppContext context = new WebAppContext();
                String webxmlPath = System.getProperty("jetty.webxml.path");
                if (webxmlPath != null) {
                    context.setOverrideDescriptor(Resource.newResource((String)(BaseTestCase.getBaseResource() + webxmlPath)).getFile().getAbsolutePath());
                }
                context.setContextPath(BaseTestCase.getContextPath());
                context.setBaseResource(Resource.newResource((String)BaseTestCase.getBaseResource()));
                context.getSessionHandler().setSessionIdPathParameterName(null);
                server.setHandler((Handler)new HandlerList(new Handler[]{context, new DefaultHandler()}));
                server.start();
                for (Connector c : server.getConnectors()) {
                    if (!(c instanceof NetworkConnector) || ((NetworkConnector)c).getLocalPort() <= 0) continue;
                    BaseTestCase.static_port = ((NetworkConnector)c).getLocalPort();
                    break;
                }
                eContext.getRoot().getStore(ExtensionContext.Namespace.GLOBAL).put((Object)this.getClass().getName(), (Object)this);
                log.info("Server runs at: " + BaseTestCase.getAddress());
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    public Server getServer() {
        return server;
    }

    public void close() throws Throwable {
        if (server != null) {
            server.stop();
            log.info("Stop server.");
        }
    }

    static {
        LOCK = new ReentrantLock();
    }
}

