/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.test.webdriver;

import java.util.Map;
import java.util.Properties;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.zkoss.test.webdriver.BaseTestCase;

public class ExternalWebXml
implements TestInstancePostProcessor,
BeforeAllCallback,
AfterAllCallback {
    private static final String BACKUP_STORE_KEY = "backup";
    public static final String WEB_XML_KEY = "jetty.webxml.path";
    private final String configPath;

    public ExternalWebXml(String configPath) {
        this.configPath = configPath;
    }

    public ExternalWebXml(Class<? extends BaseTestCase> testClass) {
        String className = testClass.getName().replace(BaseTestCase.PACKAGE, "").replace('.', '/').replace('_', '-');
        int lastTest = className.lastIndexOf("Test");
        this.configPath = className.substring(0, lastTest) + "-web.xml";
    }

    public void afterAll(ExtensionContext context) throws Exception {
        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass()}));
        Properties backup = (Properties)store.get((Object)BACKUP_STORE_KEY, Properties.class);
        System.setProperties(backup);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        Properties backup = new Properties();
        backup.putAll((Map<?, ?>)System.getProperties());
        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass()}));
        if (store.get((Object)BACKUP_STORE_KEY, Properties.class) == null) {
            store.put((Object)BACKUP_STORE_KEY, (Object)backup);
        }
        this.prepareSystemProperty(this.configPath);
    }

    private void prepareSystemProperty(String configPath) {
        if (configPath == null) {
            System.clearProperty(WEB_XML_KEY);
        } else {
            System.setProperty(WEB_XML_KEY, configPath);
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        this.beforeAll(context);
    }
}

