/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.test.webdriver;

import io.github.bonigarcia.wdm.WebDriverManager;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromiumHeadlessDriver
extends ChromeDriver {
    private static final Logger LOG = LoggerFactory.getLogger(ChromiumHeadlessDriver.class);

    public ChromiumHeadlessDriver() {
        this(true);
    }

    public ChromiumHeadlessDriver(boolean headless) {
        this(new ChromeOptions(), headless);
    }

    public ChromiumHeadlessDriver(ChromeOptions options) {
        this(options, true);
    }

    public ChromiumHeadlessDriver(ChromeOptions options, boolean headless) {
        super(ChromiumHeadlessDriver.headlessSettings(options, headless));
    }

    public ChromiumHeadlessDriver(ChromeDriverService service) {
        this(service, new ChromeOptions());
    }

    public ChromiumHeadlessDriver(ChromeDriverService service, ChromeOptions options) {
        this(service, options, true);
    }

    public ChromiumHeadlessDriver(ChromeDriverService service, ChromeOptions options, boolean headless) {
        super(service, ChromiumHeadlessDriver.headlessSettings(options, headless));
    }

    private static ChromeOptions headlessSettings(ChromeOptions options, boolean headless) {
        if (headless) {
            options.addArguments(new String[]{"--headless=new"});
        }
        return options;
    }

    static {
        WebDriverManager.chromiumdriver().setup();
        System.setProperty("webdriver.chrome.logfile", String.format("%s/chromedriver.log", System.getProperty("java.io.tmpdir")));
        System.setProperty("webdriver.chrome.verboseLogging", "true");
    }
}

