/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.test.webdriver.ztl;

import org.openqa.selenium.By;
import org.zkoss.test.webdriver.BaseTestCase;
import org.zkoss.test.webdriver.ztl.ClientWidget;
import org.zkoss.test.webdriver.ztl.Element;
import org.zkoss.test.webdriver.ztl.JQuery;

public class Widget
extends ClientWidget {
    private static String WIDGET = "zk.Widget.$('%1')";
    private String _uuid;

    public Widget(String uuid) {
        if (Widget.isEmpty(uuid)) {
            throw new NullPointerException("uuid cannot be null!");
        }
        this._uuid = uuid;
        this._out = new StringBuffer(WIDGET.replace("%1", uuid));
    }

    public Widget(Element element) {
        this._out = new StringBuffer(WIDGET.replace("'%1'", element.toString()));
    }

    public Widget(JQuery jquery) {
        this._out = new StringBuffer(WIDGET.replace("'%1'", jquery.toString()));
    }

    public Widget(StringBuffer out) {
        this._out = new StringBuffer(out);
    }

    public Widget(StringBuffer out, String script) {
        this._out = new StringBuffer(out).append(script);
    }

    public void set(String name, boolean value) {
        BaseTestCase.getEval("!!" + this._out.toString() + this.toUpperCase(".set", name) + "(" + value + ")");
    }

    public void set(String name, int value) {
        BaseTestCase.getEval("!!" + this._out.toString() + this.toUpperCase(".set", name) + "(" + value + ")");
    }

    public void set(String name, String value) {
        BaseTestCase.getEval("!!" + this._out.toString() + this.toUpperCase(".set", name) + "('" + value + "')");
    }

    public String uuid() {
        if (this._uuid == null) {
            this._uuid = this.eval("uuid");
            return this._uuid;
        }
        return this._uuid;
    }

    public String id() {
        return this.eval("id");
    }

    public String get(String name) {
        return BaseTestCase.getEval(this._out.toString() + this.toUpperCase(".get", name) + "()");
    }

    public boolean is(String name) {
        return Boolean.valueOf(BaseTestCase.getEval(this._out.toString() + this.toUpperCase(".is", name) + "()"));
    }

    public Widget getChild(String name) {
        return new Widget(this._out, "." + name);
    }

    public int nChildren() {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".nChildren"));
    }

    public Widget lastChild() {
        return new Widget(this._out, ".lastChild");
    }

    public Widget firstChild() {
        return new Widget(this._out, ".firstChild");
    }

    public Widget nextSibling() {
        return new Widget(this._out, ".nextSibling");
    }

    public Widget previousSibling() {
        return new Widget(this._out, ".previousSibling");
    }

    public Widget $f(String id) {
        return new Widget(this._out, ".$f('" + id + "', true)");
    }

    public Widget $o() {
        return new Widget(this._out, ".$o()");
    }

    public Element $n() {
        return new Element(this._out + ".$n()");
    }

    public Element $n(String subname) {
        return new Element(this._out + ".$n('" + subname + "')");
    }

    @Override
    public Element toElement() {
        return this.$n();
    }

    public void detach() {
        BaseTestCase.eval(this._out.toString() + ".detach()");
    }

    public boolean exists() {
        return Boolean.valueOf(BaseTestCase.getEval("!!" + this._out.toString() + " && !!" + this._out.toString() + ".$n()"));
    }

    @Override
    public By toBy() {
        return Widget.id((String)this.uuid());
    }
}

