/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.test.webdriver.ztl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openqa.selenium.By;
import org.zkoss.test.webdriver.BaseTestCase;
import org.zkoss.test.webdriver.ztl.ClientWidget;
import org.zkoss.test.webdriver.ztl.Element;
import org.zkoss.test.webdriver.ztl.Widget;
import org.zkoss.test.webdriver.ztl.ZK;

public class JQuery
extends ClientWidget
implements Iterable<JQuery> {
    private static String JQ = "jq('%1')";

    public JQuery(String uuid) {
        if (JQuery.isEmpty(uuid)) {
            throw new NullPointerException("uuid cannot be null!");
        }
        this._out = new StringBuffer(JQ.replace("%1", uuid));
    }

    public JQuery(ClientWidget el) {
        this._out = new StringBuffer(JQ.replace("'%1'", el.toString()));
    }

    public JQuery(StringBuffer out, String script) {
        this._out = new StringBuffer(out).append(script);
    }

    public JQuery(StringBuffer out) {
        this._out = new StringBuffer(out);
    }

    public String css(String name) {
        return BaseTestCase.getEval(this._out.toString() + ".css('" + name + "')");
    }

    public String attr(String name) {
        return BaseTestCase.getEval(this._out.toString() + ".attr('" + name + "')");
    }

    public boolean hasClass(String className) {
        return Boolean.valueOf(BaseTestCase.getEval(this._out.toString() + ".hasClass('" + className + "')"));
    }

    public boolean is(String selector) {
        return Boolean.valueOf(BaseTestCase.getEval(this._out.toString() + ".is('" + selector + "')"));
    }

    public boolean isVisible() {
        return this.is(":visible");
    }

    public JQuery find(String selector) {
        return new JQuery(this._out, ".find('" + selector + "')");
    }

    public JQuery filter(String selector) {
        return new JQuery(this._out, ".filter('" + selector + "')");
    }

    public JQuery first() {
        return new JQuery(this._out, ".first()");
    }

    public JQuery last() {
        return new JQuery(this._out, ".last()");
    }

    public JQuery prev() {
        return new JQuery(this._out, ".prev()");
    }

    public JQuery next() {
        return new JQuery(this._out, ".next()");
    }

    public JQuery children() {
        return new JQuery(this._out, ".children()");
    }

    public JQuery children(String selector) {
        return new JQuery(this._out, ".children('" + selector + "')");
    }

    public JQuery contents() {
        return new JQuery(this._out, ".contents()");
    }

    public JQuery parent() {
        return new JQuery(this._out, ".parent()");
    }

    public JQuery parent(String selector) {
        return new JQuery(this._out, ".parent('" + selector + "')");
    }

    public JQuery parents(String selector) {
        return new JQuery(this._out, ".parents('" + selector + "')");
    }

    public String text() {
        return BaseTestCase.getEval(this._out.toString() + ".text()");
    }

    public String html() {
        return BaseTestCase.getEval(this._out.toString() + ".html()");
    }

    public String val() {
        return BaseTestCase.getEval(this._out.toString() + ".val()");
    }

    public int height() {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".height()"));
    }

    public int width() {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".width()"));
    }

    public int innerHeight() {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".innerHeight()"));
    }

    public int innerWidth() {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".innerWidth()"));
    }

    public int outerWidth() {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".outerWidth()"));
    }

    public int outerWidth(boolean includeMargin) {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".outerWidth(" + includeMargin + ")"));
    }

    public int outerHeight() {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".outerHeight()"));
    }

    public int outerHeight(boolean includeMargin) {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".outerHeight(" + includeMargin + ")"));
    }

    public int length() {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".length"));
    }

    public ZK zk() {
        return new ZK(this._out, ".zk");
    }

    @Override
    public By toBy() {
        String id = this.attr("id");
        if (!JQuery.isEmpty(id)) {
            return JQuery.id((String)id);
        }
        return JQuery.className((String)this.attr("className"));
    }

    public static int scrollbarWidth() {
        return Integer.parseInt(BaseTestCase.getEval("jq.scrollbarWidth()"));
    }

    public boolean exists() {
        return Boolean.valueOf(BaseTestCase.getEval("!!" + this._out.toString() + "[0]"));
    }

    public int offsetLeft() {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".offset().left"));
    }

    public int offsetTop() {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".offset().top"));
    }

    public int positionLeft() {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".position().left"));
    }

    public int positionTop() {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".position().top"));
    }

    public int scrollTop() {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".scrollTop()"));
    }

    public void scrollTop(int value) {
        BaseTestCase.eval(this._out.toString() + ".scrollTop(\"" + value + "\")");
    }

    public int scrollLeft() {
        return BaseTestCase.parseInt(BaseTestCase.getEval(this._out.toString() + ".scrollLeft()"));
    }

    public void scrollLeft(int value) {
        BaseTestCase.eval(this._out.toString() + ".scrollLeft(\"" + value + "\")");
    }

    public int scrollHeight() {
        return BaseTestCase.parseInt(this.get(0).get("scrollHeight"));
    }

    public int scrollWidth() {
        return BaseTestCase.parseInt(this.get(0).get("scrollWidth"));
    }

    public Element get(int index) {
        return new Element(this._out.toString() + "[" + index + "]");
    }

    @Override
    public Element toElement() {
        return this.get(0);
    }

    public JQuery eq(int index) {
        return new JQuery(this._out, ".eq(" + index + ")");
    }

    public void remove() {
        BaseTestCase.eval(this._out.toString() + ".remove()");
    }

    @Override
    public Iterator<JQuery> iterator() {
        return new JQueryIerator(this);
    }

    public Widget toWidget() {
        return new Widget(this);
    }

    private class JQueryIerator
    implements Iterator<JQuery> {
        private JQuery _context;
        private int _count;
        private int _index = 0;

        public JQueryIerator(JQuery context) {
            this._context = context;
            this._count = this._context.length();
        }

        @Override
        public boolean hasNext() {
            return this._index != this._count;
        }

        @Override
        public JQuery next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            JQuery result = this._context.eq(this._index);
            ++this._index;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

