/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.test.webdriver;

import java.net.InetSocketAddress;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestInstancePreDestroyCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.test.webdriver.BaseTestCase;

public class PrototypeServer
implements TestInstancePostProcessor,
TestInstancePreDestroyCallback {
    private static final Logger log = LoggerFactory.getLogger(PrototypeServer.class);
    private Server server;

    public void postProcessTestInstance(Object testInstance, ExtensionContext eContext) throws Exception {
        this.server = new Server(new InetSocketAddress(BaseTestCase.getHost(), Integer.parseInt(BaseTestCase.getServerPort())));
        WebAppContext context = new WebAppContext();
        String webxmlPath = System.getProperty("jetty.webxml.path");
        if (webxmlPath != null) {
            context.setOverrideDescriptor(Resource.newResource((String)(BaseTestCase.getBaseResource() + webxmlPath)).getFile().getAbsolutePath());
        }
        context.setContextPath(BaseTestCase.getContextPath());
        context.setBaseResource(Resource.newResource((String)BaseTestCase.getBaseResource()));
        context.getSessionHandler().setSessionIdPathParameterName(null);
        this.server.setHandler((Handler)new HandlerList(new Handler[]{context, new DefaultHandler()}));
        BaseTestCase base = (BaseTestCase)testInstance;
        this.server.start();
        base.initServer(this.server);
        log.info("Server runs at: " + base.getAddress());
    }

    public Server getServer() {
        return this.server;
    }

    public void preDestroyTestInstance(ExtensionContext context) throws Exception {
        BaseTestCase base = (BaseTestCase)context.getTestInstance().get();
        base.destroyServer(this.server);
        if (this.server != null) {
            this.server.stop();
            log.info("Stop server.");
        }
    }
}

