/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.test.webdriver;

import io.github.bonigarcia.wdm.WebDriverManager;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;

public class FirefoxHeadlessDriver
extends FirefoxDriver {
    public FirefoxHeadlessDriver() {
        this(true);
    }

    public FirefoxHeadlessDriver(boolean headless) {
        this(new FirefoxOptions(), headless);
    }

    public FirefoxHeadlessDriver(FirefoxOptions options) {
        this(options, true);
    }

    public FirefoxHeadlessDriver(FirefoxOptions options, boolean headless) {
        super(FirefoxHeadlessDriver.headlessSettings(options, headless));
    }

    public FirefoxHeadlessDriver(FirefoxDriverService service) {
        this(service, new FirefoxOptions());
    }

    public FirefoxHeadlessDriver(FirefoxDriverService service, FirefoxOptions options) {
        this(service, options, true);
    }

    public FirefoxHeadlessDriver(FirefoxDriverService service, FirefoxOptions options, boolean headless) {
        super(service, FirefoxHeadlessDriver.headlessSettings(options, headless));
    }

    private static FirefoxOptions headlessSettings(FirefoxOptions options, boolean headless) {
        if (headless) {
            options.addArguments(new String[]{"--headless"});
        }
        return options;
    }

    static {
        WebDriverManager.firefoxdriver().setup();
        System.setProperty("webdriver.gecko.logfile", String.format("%s/geckodriver.log", System.getProperty("java.io.tmpdir")));
        System.setProperty("webdriver.gecko.log.level", "debug");
    }
}

