/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.test.webdriver;

import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.zkoss.lang.Library;
import org.zkoss.test.webdriver.BaseTestCase;

public class ExternalZkXml
implements TestInstancePostProcessor,
BeforeAllCallback,
AfterAllCallback {
    private final String configPath;

    public ExternalZkXml(String configPath) {
        this.configPath = configPath;
    }

    public ExternalZkXml(Class<? extends BaseTestCase> testClass) {
        String className = testClass.getName().replace(BaseTestCase.PACKAGE, "").replace('.', '/').replace('_', '-');
        int lastTest = className.lastIndexOf("Test");
        this.configPath = className.substring(0, lastTest) + "-zk.xml";
    }

    protected void before() {
        Library.setProperty((String)"org.zkoss.zk.config.path", (String)this.configPath);
    }

    protected void after() {
        Library.setProperty((String)"org.zkoss.zk.config.path", null);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.after();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.before();
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        this.before();
    }
}

