/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.test.webdriver;

import com.palantir.docker.compose.DockerComposeExtension;
import com.palantir.docker.compose.configuration.ShutdownStrategy;
import com.palantir.docker.compose.connection.waiting.HealthChecks;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.zkoss.test.webdriver.FirefoxWebDriverTestCase;

@ResourceLock(value="dockerResource")
public abstract class DockerFirefoxDriverTestCase
extends FirefoxWebDriverTestCase {
    protected FileLock globalLock;
    private static final String tempDir = new SimpleDateFormat("yyyyMMdd").format(new Date());
    @RegisterExtension
    public final DockerComposeExtension firefoxDocker = ((DockerComposeExtension.Builder)((DockerComposeExtension.Builder)((DockerComposeExtension.Builder)DockerComposeExtension.builder().file(this.exportResource("docker/docker-compose.yml"))).useDockerComposeV2(Boolean.parseBoolean(System.getProperty("useDockerComposeV2", "true"))).waitingForService("hub", HealthChecks.toRespondOverHttp((int)4444, port -> port.inFormat("http://$HOST:$EXTERNAL_PORT/ui/index.html")))).waitingForService("firefox", HealthChecks.toHaveAllPortsOpen())).shutdownStrategy(ShutdownStrategy.KILL_DOWN).removeConflictingContainersOnStartup(true).build();

    @Override
    protected final boolean isUseDocker() {
        return true;
    }

    @Override
    protected String getRemoteWebDriverUrl() {
        int externalPort = this.firefoxDocker.containers().container("hub").port(4444).getExternalPort();
        return "http://localhost:" + externalPort + "/wd/hub";
    }

    protected String exportResource(String file) {
        InputStream resourceAsStream = ClassLoader.getSystemResourceAsStream("docker/docker-compose.yml");
        try {
            Path path = Paths.get(System.getProperty("java.io.tmpdir"), tempDir, "zkWebdriver").resolve(file);
            if (!Files.isDirectory(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            if (path.toFile().exists()) {
                path.toFile().delete();
            }
            Files.copy(resourceAsStream, path, StandardCopyOption.REPLACE_EXISTING);
            RandomAccessFile files = new RandomAccessFile(path.toFile(), "rw");
            FileChannel channel = files.getChannel();
            while (true) {
                try {
                    this.globalLock = channel.tryLock();
                    if (this.globalLock.isValid()) {
                        break;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            return path.toAbsolutePath().toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @AfterAll
    public void unlockGlobalLock() {
        if (this.globalLock != null) {
            try {
                this.globalLock.release();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

