/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.test.webdriver;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChromiumFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(ChromiumFetcher.class);
    private static final String DEFAULT_DOWNLOAD_HOST = "https://storage.googleapis.com";
    private static final Map<Arch, String> URLS = new EnumMap<Arch, String>(Arch.class);
    private final String downloadFolder = System.getProperty("user.home") + "/.m2/repository/chromium/";
    private final String downloadHost;
    private final Arch platform;

    public ChromiumFetcher() {
        this.downloadHost = DEFAULT_DOWNLOAD_HOST;
        if (SystemUtils.IS_OS_WINDOWS) {
            this.platform = System.getProperty("os.arch").contains("64") ? Arch.WIN64 : Arch.WIN32;
        } else if (SystemUtils.IS_OS_LINUX) {
            this.platform = Arch.LINUX;
        } else if (SystemUtils.IS_OS_MAC) {
            this.platform = Arch.MAC;
        } else {
            throw new IllegalArgumentException("Unsupported platform: " + SystemUtils.OS_NAME);
        }
        LOG.info("Detected arch: {}", (Object)this.platform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDownload(int revision) {
        HttpURLConnection http = null;
        try {
            URL url = this.getUrl(revision);
            http = (HttpURLConnection)url.openConnection();
            http.connect();
            if (http.getResponseCode() == 200) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
        finally {
            if (http != null) {
                http.disconnect();
            }
        }
        return false;
    }

    private URL getUrl(int revision) throws MalformedURLException {
        return new URL(String.format(URLS.get((Object)this.platform), this.downloadHost, revision, this.archiveName(this.platform, revision)));
    }

    private String archiveName(Arch platform, int revision) {
        if (platform == Arch.LINUX) {
            return "chrome-linux";
        }
        if (platform == Arch.MAC) {
            return "chrome-mac";
        }
        if (platform == Arch.WIN32 || platform == Arch.WIN64) {
            return revision > 591479 ? "chrome-win" : "chrome-win32";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(int revision) throws IOException {
        Path tempZip = null;
        try {
            URL url = this.getUrl(revision);
            LOG.info("URL: {}", (Object)url);
            tempZip = Files.createTempFile("chromium", null, new FileAttribute[0]);
            this.downloadFile(url, tempZip);
            this.extractZip(tempZip, this.getFolderPath(revision));
            this.chmod(this.getExecutablePath(revision));
        }
        catch (Throwable throwable) {
            this.deleteFile(tempZip);
            throw throwable;
        }
        this.deleteFile(tempZip);
    }

    private void downloadFile(URL url, Path dest) throws IOException {
        LOG.info("Download {} to {}", (Object)url, (Object)dest);
        try (InputStream in = url.openStream();){
            Files.copy(in, dest, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void extractZip(Path zip, Path targetDir) throws IOException {
        LOG.info("Extracting {} to {}", (Object)zip, (Object)targetDir);
        Files.createDirectories(targetDir, new FileAttribute[0]);
        try (ZipFile zipFile = new ZipFile(zip.toFile());){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                Path file = targetDir.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(file, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                if (entry.isUnixSymlink()) {
                    Path target = file.resolveSibling(zipFile.getUnixSymlink(entry));
                    Files.createSymbolicLink(file, file.getParent().relativize(target), new FileAttribute[0]);
                    continue;
                }
                InputStream in = zipFile.getInputStream(entry);
                try {
                    Files.copy(in, file, new CopyOption[0]);
                    if ((entry.getUnixMode() & 0x49) == 0) continue;
                    file.toFile().setExecutable(true);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        LOG.info("Extracted {} to {}", (Object)zip, (Object)targetDir);
    }

    public Path getFolderPath(int revision) {
        return Paths.get(this.downloadFolder, this.platform.name() + '-' + revision);
    }

    public Path getExecutablePath(int revision) {
        Path executablePath;
        Path folderPath = this.getFolderPath(revision);
        switch (this.platform) {
            case MAC: {
                executablePath = Paths.get(this.archiveName(this.platform, revision), "Chromium.app", "Contents", "MacOS", "Chromium");
                break;
            }
            case LINUX: {
                executablePath = Paths.get(this.archiveName(this.platform, revision), "chrome");
                break;
            }
            case WIN32: 
            case WIN64: {
                executablePath = Paths.get(this.archiveName(this.platform, revision), "chrome.exe");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported platform");
            }
        }
        return folderPath.resolve(executablePath);
    }

    public void chmod(Path path) throws IOException {
        Set<String> supportedAttr = path.getFileSystem().supportedFileAttributeViews();
        if (supportedAttr.contains("posix")) {
            LOG.info("Set {} permission 755", (Object)path);
            Files.setPosixFilePermissions(path, PosixFilePermissions.fromString("rwxr-xr-x"));
        } else {
            LOG.info("The filesystem is not POSIX-compatible. Ignore.");
        }
    }

    private void deleteFile(Path file) throws IOException {
        Files.deleteIfExists(file);
    }

    static {
        URLS.put(Arch.LINUX, "%s/chromium-browser-snapshots/Linux_x64/%d/%s.zip");
        URLS.put(Arch.MAC, "%s/chromium-browser-snapshots/Mac/%d/%s.zip");
        URLS.put(Arch.WIN32, "%s/chromium-browser-snapshots/Win/%d/%s.zip");
        URLS.put(Arch.WIN64, "%s/chromium-browser-snapshots/Win_x64/%d/%s.zip");
    }

    public static enum Arch {
        LINUX,
        MAC,
        WIN32,
        WIN64;

    }
}

