/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.test.webdriver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Strings;
import org.zkoss.test.webdriver.ChromiumHeadlessDriver;
import org.zkoss.test.webdriver.DockerRemoteWebDriver;
import org.zkoss.test.webdriver.ztl.ClientWidget;
import org.zkoss.test.webdriver.ztl.Element;
import org.zkoss.test.webdriver.ztl.JQuery;
import org.zkoss.test.webdriver.ztl.Widget;
import org.zkoss.test.webdriver.ztl.ZK;

public abstract class BaseTestCase {
    private static final Logger log = LoggerFactory.getLogger(BaseTestCase.class);
    public static final String PACKAGE = System.getProperty("zkWebdriverTestURLPackage", "");
    private static final ThreadLocal<Integer> port = new ThreadLocal();
    protected static int static_port;
    protected static final ThreadLocal<WebDriver> _local;
    private static final String JS_DROP_FILES = "var c=arguments,b=c[0],k=c[1];c=c[2];for(var d=b.ownerDocument||document,l=0;;){var e=b.getBoundingClientRect(),g=e.left+(k||e.width/2),h=e.top+(c||e.height/2),f=d.elementFromPoint(g,h);if(f&&b.contains(f))break;if(1<++l)throw b=Error('Element not interactable'),b.code=15,b;b.scrollIntoView({behavior:'instant',block:'center',inline:'center'})}var a=d.createElement('INPUT');a.setAttribute('type','file');a.setAttribute('multiple','');a.setAttribute('style','position:fixed;z-index:2147483647;left:0;top:0;');a.onchange=function(b){a.parentElement.removeChild(a);b.stopPropagation();var c={constructor:DataTransfer,effectAllowed:'all',dropEffect:'none',types:['Files'],files:a.files,setData:function(){},getData:function(){},clearData:function(){},setDragImage:function(){}};window.DataTransferItemList&&(c.items=Object.setPrototypeOf(Array.prototype.map.call(a.files,function(a){return{constructor:DataTransferItem,kind:'file',type:a.type,getAsFile:function(){return a},getAsString:function(b){var c=new FileReader;c.onload=function(a){b(a.target.result)};c.readAsText(a)}}}),{constructor:DataTransferItemList,add:function(){},clear:function(){},remove:function(){}}));['dragenter','dragover','drop'].forEach(function(a){var b=d.createEvent('DragEvent');b.initMouseEvent(a,!0,!0,d.defaultView,0,0,0,g,h,!1,!1,!1,!1,0,null);Object.setPrototypeOf(b,null);b.dataTransfer=c;Object.setPrototypeOf(b,DragEvent.prototype);f.dispatchEvent(b)})};d.documentElement.appendChild(a);a.getBoundingClientRect();return a;";
    private static final String HOST;
    private static final int OS_TYPE;
    private static final String REMOTE_WEB_DRIVER_URL;
    private static final String OS;
    private boolean connectWaiting = true;
    protected WebDriver driver;

    private static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    protected static int getPort() {
        return Optional.ofNullable(port.get()).orElse(static_port);
    }

    protected static String getContextPath() {
        String zkWebdriverContextPath = System.getProperty("zkWebdriverContextPath");
        if (zkWebdriverContextPath == null) {
            throw new IllegalArgumentException("\"zkWebdriverContextPath\" is not found in System.getProperty()");
        }
        return zkWebdriverContextPath;
    }

    protected static String getHost() {
        return HOST;
    }

    protected static String getAddress() {
        return "http://" + BaseTestCase.getHost() + ":" + BaseTestCase.getPort() + BaseTestCase.getContextPath();
    }

    protected boolean isHeadless() {
        return true;
    }

    protected WebDriver getWebDriver() {
        if (this.driver == null) {
            ChromeOptions driverOptions = this.getWebDriverOptions();
            this.driver = this.isUsingRemoteWebDriver(driverOptions) ? new DockerRemoteWebDriver(this.getRemoteWebDriverUrl(), (Capabilities)driverOptions) : new ChromiumHeadlessDriver(driverOptions, this.isHeadless());
        }
        return this.driver;
    }

    protected String getRemoteWebDriverUrl() {
        return REMOTE_WEB_DRIVER_URL;
    }

    protected boolean isUseDocker() {
        return false;
    }

    protected boolean isUsingRemoteWebDriver(ChromeOptions driverOptions) {
        return this.isUseDocker();
    }

    protected boolean isUsingRemoteWebDriver(FirefoxOptions driverOptions) {
        return this.isUseDocker();
    }

    protected ChromeOptions getWebDriverOptions() {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"window-size=1920,1080", "--remote-allow-origins=*"});
        return options;
    }

    public WebDriver connect() {
        return this.connect(null);
    }

    protected String getTestURL(String file) {
        String simple = this.getClass().getSimpleName();
        String name = this.getClass().getName().replace(PACKAGE, "").replace(".", "/").replace(simple, "");
        return name + file;
    }

    protected String getFileLocation() {
        String className = this.getClass().getName().replace(PACKAGE, "").replace(".", "/");
        int lastTest = className.lastIndexOf("Test");
        return className.substring(0, lastTest) + this.getFileExtension();
    }

    protected String getFileExtension() {
        return ".zul";
    }

    public WebDriver connect(String location) {
        WebDriver webDriver = this.initWebDriver();
        String address = BaseTestCase.getAddress();
        if (location == null) {
            location = this.getFileLocation();
            String loc = address + location;
            int errCode = BaseTestCase.getStatusCode(loc);
            if (errCode == 404) {
                loc = address + location.replace("_", "-");
                errCode = BaseTestCase.getStatusCode(loc);
                if (errCode == 404) {
                    loc = address + location.replace("-", "_");
                    errCode = BaseTestCase.getStatusCode(loc);
                }
                if (errCode == 404) {
                    Assertions.fail((String)("Error Code: " + errCode + ", from URL[" + loc + "]"));
                }
            }
            webDriver.get(loc);
        } else {
            String loc = address + location;
            int errCode = BaseTestCase.getStatusCode(loc);
            if (errCode != 200) {
                Assertions.fail((String)("Error Code: " + errCode + ", from URL[" + loc + "]"));
            }
            webDriver.get(loc);
        }
        if (this.connectWaiting && ExpectedConditions.alertIsPresent().apply((Object)webDriver) == null) {
            try {
                if (((JavascriptExecutor)this.driver).executeScript("return Array.from(document.scripts).some(script => script.src.includes('zk.wpd'));", new Object[0]) == Boolean.TRUE) {
                    this.waitForAjaxResponse(2, this.getTimeout(), System.currentTimeMillis(), "!window.zk || window.zk.loading");
                }
            }
            catch (UnhandledAlertException unhandledAlertException) {
                // empty catch block
            }
        }
        return webDriver;
    }

    protected void disableConnectionWait() {
        this.connectWaiting = false;
    }

    protected void enableConnectionWait() {
        this.connectWaiting = true;
    }

    protected WebDriver initWebDriver() {
        WebDriver webDriver = this.getWebDriver();
        _local.set(webDriver);
        return webDriver;
    }

    protected int getTimeout() {
        return 4000;
    }

    @AfterEach
    public void stop() {
        if (this.driver != null) {
            this.driver.quit();
            this.driver = null;
        }
        _local.set(null);
    }

    protected static String getServerPort() {
        return System.getProperty("jetty.port", "0");
    }

    protected static String getBaseResource() {
        return System.getProperty("zkWebdriverBaseResource", "./src/main/webapp/");
    }

    protected void initServer(Server currentServer) throws Exception {
        for (Connector c : currentServer.getConnectors()) {
            if (!(c instanceof NetworkConnector) || ((NetworkConnector)c).getLocalPort() <= 0) continue;
            static_port = ((NetworkConnector)c).getLocalPort();
            port.set(static_port);
            break;
        }
    }

    protected void destroyServer(Server currentServer) {
        port.set(null);
    }

    protected void waitResponse() {
        this.waitResponse(this.getTimeout());
    }

    protected void waitResponse(boolean includingAnimation) {
        this.waitResponse(this.getTimeout(), includingAnimation);
    }

    protected int getSpeed() {
        return 500;
    }

    protected void waitResponse(int timeout, boolean includingAnimation) {
        this.sleep(this.getSpeed() / 2);
        String defaultScript = "!!zAu.processing() || (window.mobx && window.mobx._getGlobalState() && window.mobx._getGlobalState().isRunningReactions)";
        this.waitForAjaxResponse(this.getRetryCount(includingAnimation), timeout, System.currentTimeMillis(), includingAnimation ? defaultScript + " || !!jq.timers.length" : defaultScript);
    }

    protected int getRetryCount(boolean includingAnimation) {
        return includingAnimation ? 5 : 3;
    }

    private void waitForAjaxResponse(int loopCount, int timeout, long startTime, String waitForScript) {
        int ms = this.getSpeed();
        for (int i = 0; i < loopCount; ++i) {
            while (Boolean.parseBoolean(BaseTestCase.getEval(waitForScript))) {
                if (System.currentTimeMillis() - startTime > (long)timeout) {
                    Assertions.fail((String)"Test case timeout!");
                    break;
                }
                i = 0;
                this.sleep(ms);
            }
            this.sleep(ms);
        }
    }

    public static String getEval(String script) {
        WebDriver driver = _local.get();
        return String.valueOf(((JavascriptExecutor)driver).executeScript("return (" + script + ")", new Object[0]));
    }

    public static void eval(String script) {
        WebDriver driver = _local.get();
        ((JavascriptExecutor)driver).executeScript("(" + script + ")", new Object[0]);
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void waitResponse(int timeout) {
        this.waitResponse(timeout, false);
    }

    protected Widget widget(String uuid) {
        return new Widget(uuid);
    }

    protected Widget widget(Element element) {
        return new Widget(element);
    }

    protected Widget widget(JQuery jQuery) {
        return new Widget(jQuery);
    }

    protected JQuery jq(String selector) {
        return new JQuery(selector);
    }

    protected JQuery jq(ClientWidget el) {
        if (el instanceof JQuery) {
            return (JQuery)el;
        }
        return new JQuery(el);
    }

    protected ZK zk(ClientWidget el) {
        if (el instanceof ZK) {
            return (ZK)el;
        }
        return new ZK(el);
    }

    protected ZK zk(String selector) {
        return new ZK(selector);
    }

    public static int parseInt(String number) {
        if (number != null) {
            int decimal = (number = number.replaceAll("[^-0-9\\.]", "")).indexOf(46);
            if (decimal > 0) {
                number = number.substring(0, decimal);
            }
            if (!"".equals(number.trim())) {
                return Integer.parseInt(number);
            }
            return 0;
        }
        return 0;
    }

    protected void trigger(ClientWidget widget, String event) {
        ((JavascriptExecutor)this.driver).executeScript(this.jq(widget).toLocator() + ".trigger('" + event + "')", new Object[0]);
    }

    public static WebElement toElement(ClientWidget locator) {
        WebDriver webDriver = _local.get();
        if (locator instanceof Widget) {
            return (WebElement)((JavascriptExecutor)webDriver).executeScript("return (" + (Object)((Object)locator) + ").$n();", new Object[0]);
        }
        if (locator instanceof JQuery) {
            return (WebElement)((JavascriptExecutor)webDriver).executeScript("return (" + (Object)((Object)locator) + ")[0];", new Object[0]);
        }
        return (WebElement)((JavascriptExecutor)webDriver).executeScript("return (" + (Object)((Object)locator) + ");", new Object[0]);
    }

    public static String trim(String text) {
        return text.replaceAll("^\\s+|\\s+$|\\s*(\n)\\s*|(\\s)\\s*", "$1$2").replace("\n", "").replace("\r", "");
    }

    protected String getZKLog() {
        return this.jq("#zk_log").val().trim();
    }

    protected boolean isZKLogAvailable() {
        WebElement log = null;
        try {
            log = this.getWebDriver().findElement(By.id((String)"zk_log"));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return log != null;
    }

    protected void closeZKLog() {
        this.jq("#zk_logbox").remove();
    }

    protected void focus(ClientWidget locator) {
        BaseTestCase.eval(this.jq(locator).toLocator() + ".focus()");
    }

    protected void blur(ClientWidget locator) {
        BaseTestCase.eval(this.jq(locator).toLocator() + ".blur()");
    }

    protected void click(ClientWidget locator) {
        BaseTestCase.toElement(locator).click();
    }

    protected void clickAt(ClientWidget locator, int offsetX, int offsetY) {
        WebElement webElement = BaseTestCase.toElement(locator);
        this.getActions().moveToElement(webElement, offsetX, offsetY).click().perform();
    }

    protected void rightClick(ClientWidget locator) {
        Actions act = this.getActions();
        act.contextClick(BaseTestCase.toElement(locator));
        act.perform();
    }

    protected void dblClick(ClientWidget locator) {
        Actions act = this.getActions();
        act.doubleClick(BaseTestCase.toElement(locator));
        act.perform();
    }

    protected void check(ClientWidget locator) {
        this.click(locator);
    }

    protected void type(ClientWidget locator, String text) {
        this.focus(locator);
        WebElement webElement = BaseTestCase.toElement(locator);
        webElement.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{BaseTestCase.isMac() ? Keys.META : Keys.CONTROL, "a"})});
        if (Strings.isEmpty((String)text)) {
            webElement.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
        } else {
            webElement.sendKeys(new CharSequence[]{text});
        }
        this.blur(locator);
    }

    protected void sendKeys(ClientWidget locator, CharSequence ... keysToSend) {
        this.getWebDriver().findElement((By)locator).sendKeys(keysToSend);
    }

    protected Widget selectComboitem(Widget combobox, int index) {
        this.click(combobox.$n("btn"));
        this.waitResponse(true);
        Element element = this.jq(combobox.$n("pp")).find(".z-comboitem").get(index);
        this.click(element);
        this.waitResponse(true);
        return this.widget(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStatusCode(String url) {
        HttpURLConnection http = null;
        try {
            URL u = new URL(url);
            http = (HttpURLConnection)u.openConnection();
            int n = http.getResponseCode();
            return n;
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            if (http != null) {
                http.disconnect();
            }
        }
    }

    protected String stripJsessionid(String url) {
        return url.replaceAll(";jsessionid=[^?]*", "");
    }

    public boolean hasError() {
        return Boolean.valueOf(BaseTestCase.getEval("!!jq('.z-messagebox-error')[0] || !!jq('.z-errorbox')[0] || !!jq('.z-error')[0]"));
    }

    protected void assertNoZKError() {
        Assertions.assertFalse((boolean)this.hasError());
    }

    protected void assertNoAnyError() {
        this.assertNoJSError();
        this.assertNoZKError();
    }

    protected void assertNoJSError() {
        this.driver.manage().logs().get("browser").getAll().stream().filter(entry -> entry.getLevel().intValue() >= Level.SEVERE.intValue()).findFirst().ifPresent(log -> Assertions.fail((String)log.toString()));
    }

    protected String getMessageBoxContent() {
        return this.jq(".z-messagebox").text().replaceAll("\u00a0", " ").trim();
    }

    protected Actions getActions() {
        return new Actions(this.getWebDriver());
    }

    protected void dropUploadFile(JQuery element, Path file) throws FileNotFoundException {
        this.dropUploadFiles(element, Collections.singletonList(file), 0, 0);
    }

    protected void dropUploadFiles(JQuery element, List<Path> files, int offsetX, int offsetY) throws FileNotFoundException {
        ArrayList<String> paths = new ArrayList<String>();
        for (Path file : files) {
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                throw new FileNotFoundException(file.toString());
            }
            paths.add(file.toAbsolutePath().toString());
        }
        BaseTestCase.eval(element + ".show()");
        String value = String.join((CharSequence)"\n", paths);
        WebElement input = (WebElement)((JavascriptExecutor)this.driver).executeScript(JS_DROP_FILES, new Object[]{BaseTestCase.toElement(element), offsetX, offsetY});
        input.sendKeys(new CharSequence[]{value});
    }

    protected void cut() {
        Actions actions = this.getActions();
        if (BaseTestCase.isMac()) {
            actions.keyDown((CharSequence)Keys.SHIFT).sendKeys(new CharSequence[]{Keys.DELETE}).keyUp((CharSequence)Keys.SHIFT).perform();
        } else {
            actions.keyDown((CharSequence)Keys.CONTROL).sendKeys(new CharSequence[]{"x"}).keyUp((CharSequence)Keys.CONTROL).perform();
        }
    }

    protected void copy() {
        Actions actions = this.getActions();
        if (BaseTestCase.isMac()) {
            actions.keyDown((CharSequence)Keys.META).sendKeys(new CharSequence[]{"c"}).keyUp((CharSequence)Keys.META).perform();
        } else {
            actions.keyDown((CharSequence)Keys.CONTROL).sendKeys(new CharSequence[]{"c"}).keyUp((CharSequence)Keys.CONTROL).perform();
        }
    }

    protected void paste() {
        Actions actions = this.getActions();
        if (BaseTestCase.isMac()) {
            actions.keyDown((CharSequence)Keys.META).sendKeys(new CharSequence[]{"v"}).keyUp((CharSequence)Keys.META).perform();
        } else {
            actions.keyDown((CharSequence)Keys.CONTROL).sendKeys(new CharSequence[]{"v"}).keyUp((CharSequence)Keys.CONTROL).perform();
        }
    }

    protected void selectAll() {
        BaseTestCase.eval("document.activeElement.select && document.activeElement.select()");
        this.sleep(100L);
    }

    protected void setCursorPosition(ClientWidget locator, int position) {
        BaseTestCase.eval((Object)((Object)this.zk(locator)) + String.format(".setSelectionRange(%1$d, %1$d)", position));
        this.sleep(100L);
    }

    protected void mouseOver(ClientWidget locator) {
        this.getActions().moveToElement(BaseTestCase.toElement(locator)).pause(100L).perform();
    }

    protected void dragdropTo(ClientWidget locator, int fromX, int fromY, int offsetX, int offsetY) {
        this.getActions().moveToElement(BaseTestCase.toElement(locator)).moveByOffset(fromX, fromY).clickAndHold().moveByOffset(offsetX, offsetY).release().perform();
    }

    protected static boolean isUnix() {
        return OS_TYPE == 1;
    }

    protected static boolean isWindows() {
        return OS_TYPE == 2;
    }

    protected static boolean isSolaris() {
        return OS_TYPE == 4;
    }

    protected static boolean isMac() {
        return OS_TYPE == 3;
    }

    static {
        _local = new ThreadLocal();
        REMOTE_WEB_DRIVER_URL = System.getProperty("RemoteWebDriverUrl", "");
        OS = System.getProperty("os.name").toLowerCase();
        OS_TYPE = OS.contains("nix") || OS.contains("nux") || OS.contains("aix") ? 1 : (OS.contains("win") ? 2 : (OS.contains("mac") ? 3 : (OS.contains("sunos") ? 4 : -1)));
        String host = System.getProperty("Host", "127.0.0.1");
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress("google.com", 80));
            host = socket.getLocalAddress().getHostAddress();
        }
        catch (IOException e) {
            try {
                InetAddress candidateAddress = BaseTestCase.getLocalHostLANAddress();
                host = candidateAddress.getHostAddress();
            }
            catch (UnknownHostException ex) {
                ex.printStackTrace();
            }
        }
        HOST = host;
    }
}

