/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record.common;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.common.LPWideString;
import org.zkoss.poi.hssf.record.common.XFPropBorder;
import org.zkoss.poi.hssf.record.common.XFPropColor;
import org.zkoss.poi.hssf.record.common.XFPropGradient;
import org.zkoss.poi.hssf.record.common.XFPropGradientStop;
import org.zkoss.poi.hssf.record.common.XLUnicodeString;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public class XFProp {
    public static final int FILL_PATTERN = 0;
    public static final int FOREGROUND_COLOR = 1;
    public static final int BACKGROUND_COLOR = 2;
    public static final int GRADIENT = 3;
    public static final int GRADIENT_STOP = 4;
    public static final int TEXT_COLOR = 5;
    public static final int TOP_BORDER = 6;
    public static final int BOTTOM_BORDER = 7;
    public static final int LEFT_BORDER = 8;
    public static final int RIGHT_BORDER = 9;
    public static final int DIAG_BORDER = 10;
    public static final int VERT_BORDER = 11;
    public static final int HORZ_BORDER = 12;
    public static final int USE_DIAG_UP_BORDER = 13;
    public static final int USE_DIAG_DOWN_BORDER = 14;
    public static final int HORZ_ALIGN = 15;
    public static final int VERT_ALIGN = 16;
    public static final int TEXT_ROTATION = 17;
    public static final int ABS_INDENTION = 18;
    public static final int READING_ORDER = 19;
    public static final int WRAPPED = 20;
    public static final int JUSTIFIED = 21;
    public static final int SHRINK_FIT = 22;
    public static final int MERGED = 23;
    public static final int FONT_NAME = 24;
    public static final int BOLD = 25;
    public static final int UNDERLINE = 26;
    public static final int SCRIPT = 27;
    public static final int ITALIC = 28;
    public static final int STRIKETHRU = 29;
    public static final int OUTLINE = 30;
    public static final int SHADOW = 31;
    public static final int CONDENSED = 32;
    public static final int EXTENDED = 33;
    public static final int CHARSET = 34;
    public static final int FONT_FAMILY = 35;
    public static final int FONT_SIZE = 36;
    public static final int FONT_SCHEME = 37;
    public static final int NUM_FORMAT = 38;
    public static final int FORMAT_ID = 41;
    public static final int REL_INDENTION = 42;
    public static final int LOCKED = 43;
    public static final int HIDDEN = 44;
    private final int xfPropType;
    private final int cb;
    private final Object xfPropData;

    public XFProp(RecordInputStream in) {
        this.xfPropType = in.readShort() & 0xFFFF;
        this.cb = in.readShort() & 0xFFFF;
        switch (this.xfPropType) {
            case 1: 
            case 2: 
            case 5: {
                this.xfPropData = new XFPropColor(in);
                break;
            }
            case 3: {
                this.xfPropData = new XFPropGradient(in);
                break;
            }
            case 4: {
                this.xfPropData = new XFPropGradientStop(in);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.xfPropData = new XFPropBorder(in);
                break;
            }
            case 0: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 43: 
            case 44: {
                this.xfPropData = in.readByte();
                break;
            }
            case 18: 
            case 41: 
            case 42: {
                this.xfPropData = in.readShort();
                break;
            }
            case 24: {
                this.xfPropData = new LPWideString(in);
                break;
            }
            case 36: {
                this.xfPropData = in.readInt();
                break;
            }
            case 38: {
                this.xfPropData = new XLUnicodeString(in);
                break;
            }
            default: {
                throw new RuntimeException("Unknown xfPropType: " + this.xfPropType);
            }
        }
    }

    public XFProp(int type, Object data) {
        this.xfPropType = type;
        this.xfPropData = data;
        switch (this.xfPropType) {
            case 1: 
            case 2: 
            case 5: {
                this.cb = 4 + ((XFPropColor)this.xfPropData).getDataSize();
                break;
            }
            case 3: {
                this.cb = 4 + ((XFPropGradient)this.xfPropData).getDataSize();
                break;
            }
            case 4: {
                this.cb = 4 + ((XFPropGradientStop)this.xfPropData).getDataSize();
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.cb = 4 + ((XFPropBorder)this.xfPropData).getDataSize();
                break;
            }
            case 0: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 43: 
            case 44: {
                this.cb = 5;
                break;
            }
            case 18: 
            case 41: 
            case 42: {
                this.cb = 6;
                break;
            }
            case 24: {
                this.cb = 4 + ((LPWideString)this.xfPropData).getDataSize();
                break;
            }
            case 36: {
                this.cb = 8;
                break;
            }
            case 38: {
                this.cb = 4 + ((XLUnicodeString)this.xfPropData).getDataSize();
                break;
            }
            default: {
                throw new RuntimeException("Unknown xfPropType: " + this.xfPropType + ", xfPropData:" + this.xfPropData);
            }
        }
    }

    public int getDataSize() {
        return this.cb;
    }

    public int getXFPropType() {
        return this.xfPropType;
    }

    public Object getXFPropData() {
        return this.xfPropData;
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.xfPropType);
        out.writeShort(this.cb);
        switch (this.xfPropType) {
            case 1: 
            case 2: 
            case 5: {
                ((XFPropColor)this.xfPropData).serialize(out);
                break;
            }
            case 3: {
                ((XFPropGradient)this.xfPropData).serialize(out);
                break;
            }
            case 4: {
                ((XFPropGradientStop)this.xfPropData).serialize(out);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                ((XFPropBorder)this.xfPropData).serialize(out);
                break;
            }
            case 0: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 43: 
            case 44: {
                out.writeByte(((Number)this.xfPropData).intValue());
                break;
            }
            case 18: 
            case 41: 
            case 42: {
                out.writeShort(((Number)this.xfPropData).intValue());
                break;
            }
            case 24: {
                ((LPWideString)this.xfPropData).serialize(out);
                break;
            }
            case 36: {
                out.writeInt(((Number)this.xfPropData).intValue());
                break;
            }
            case 38: {
                ((XLUnicodeString)this.xfPropData).serialize(out);
                break;
            }
            default: {
                throw new RuntimeException("Unknown xfPropType: " + this.xfPropType + ", xfPropData:" + this.xfPropData);
            }
        }
    }

    public void appendString(StringBuffer sb, String prefix) {
        sb.append(prefix).append(".xfPropType = ").append(this.getPropTypeName()).append("(").append(HexDump.shortToHex(this.xfPropType)).append(")\n");
        sb.append(prefix).append(".cb         = ").append(this.cb).append("\n");
        this.appendString0(sb, prefix);
    }

    private void appendString0(StringBuffer sb, String prefix) {
        switch (this.xfPropType) {
            case 1: 
            case 2: 
            case 5: {
                sb.append(prefix).append(".xfPropData = \n");
                ((XFPropColor)this.xfPropData).appendString(sb, prefix + "    ");
                break;
            }
            case 3: {
                ((XFPropGradient)this.xfPropData).appendString(sb, prefix + "    ");
                break;
            }
            case 4: {
                ((XFPropGradientStop)this.xfPropData).appendString(sb, prefix + "    ");
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                ((XFPropBorder)this.xfPropData).appendString(sb, prefix + "    ");
                break;
            }
            case 0: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 43: 
            case 44: {
                sb.append(prefix).append(".xfPropData = 0x").append(Integer.toHexString(((Number)this.xfPropData).byteValue() & 0xFF)).append("\n");
                break;
            }
            case 18: 
            case 41: 
            case 42: {
                sb.append(prefix).append(".xfPropData = 0x").append(Integer.toHexString(((Number)this.xfPropData).shortValue() & 0xFFFF)).append("\n");
                break;
            }
            case 24: {
                ((LPWideString)this.xfPropData).appendString(sb, prefix + "    ");
                break;
            }
            case 36: {
                sb.append(prefix).append(".xfPropData = 0x").append(Integer.toHexString(((Number)this.xfPropData).intValue())).append("\n");
                break;
            }
            case 38: {
                ((XLUnicodeString)this.xfPropData).appendString(sb, prefix + "    ");
                break;
            }
            default: {
                throw new RuntimeException("Unknown xfPropType: " + this.xfPropType + ", xfPropData:" + this.xfPropData);
            }
        }
    }

    private String getPropTypeName() {
        switch (this.xfPropType) {
            case 1: {
                return "FOREGROUND_COLOR";
            }
            case 2: {
                return "BACKGROUND_COLOR";
            }
            case 5: {
                return "TEXT_COLOR";
            }
            case 3: {
                return "GRADIENT";
            }
            case 4: {
                return "GRADIENT_STOP";
            }
            case 6: {
                return "TOP_BORDER";
            }
            case 7: {
                return "BOTTOM_BORDER";
            }
            case 8: {
                return "LEFT_BORDER";
            }
            case 9: {
                return "RIGHT_BORDER";
            }
            case 10: {
                return "DIAG_BORDER";
            }
            case 11: {
                return "VERT_BORDER";
            }
            case 12: {
                return "HORZ_BORDER";
            }
            case 37: {
                return "FONT_SCHEME";
            }
            case 27: {
                return "SCRIPT";
            }
            case 26: {
                return "UNDERLINE";
            }
            case 25: {
                return "BOLD";
            }
            case 19: {
                return "READING_ORDER";
            }
            case 17: {
                return "TEXT_ROTATION";
            }
            case 16: {
                return "VERT_ALIGN";
            }
            case 15: {
                return "HORZ_ALIGN";
            }
            case 0: {
                return "FILL_PATTERN";
            }
            case 13: {
                return "USE_DIAG_UP_BORDER";
            }
            case 14: {
                return "USE_DIAG_DOWN_BORDER";
            }
            case 20: {
                return "WRAPPED";
            }
            case 21: {
                return "JUSTIFIED";
            }
            case 22: {
                return "SHRINK_FIT";
            }
            case 23: {
                return "MERGED";
            }
            case 28: {
                return "ITALIC";
            }
            case 29: {
                return "STRIKETHRU";
            }
            case 30: {
                return "OUTLINE";
            }
            case 31: {
                return "SHADOW";
            }
            case 32: {
                return "CONDENSED";
            }
            case 33: {
                return "EXTENDED";
            }
            case 34: {
                return "CHARSET";
            }
            case 35: {
                return "FONT_FAMILY";
            }
            case 43: {
                return "LOCKED";
            }
            case 44: {
                return "HIDDEN";
            }
            case 41: {
                return "FORMAT_ID";
            }
            case 18: {
                return "ABS_INDENTION";
            }
            case 42: {
                return "REL_INDENTION";
            }
            case 24: {
                return "FONT_NAME";
            }
            case 36: {
                return "FONT_SIZE";
            }
            case 38: {
                return "NUM_FORMAT";
            }
        }
        throw new RuntimeException("Unknown xfPropType: " + this.xfPropType + ", xfPropData:" + this.xfPropData);
    }
}

