
(function () {
	function _maskInfo(wgt, txt) {
		var w = new zul.wgt.Div({
			style: 'color: #EE1111; font-weight: bold; border: 1px solid #C5C5C5', 
			children: [new zul.wgt.Label({value: txt})] 
		});
		w.replaceHTML('#' + wgt.uuid);
	}
	
	

	function _convertGlobalOptions(options, plotData) {
		options = options || {};
		var global = options.global = options.global || {};
		if (!global.VMLRadialGradientURL) {
			global.VMLRadialGradientURL = zk.ajaxURI('web/js/chart/ext/gfx/vml-radial-gradient.png', {au:true});
		}
		if (!global.canvasToolsURL) {
			global.canvasToolsURL = zk.ajaxURI('web/js/chart/ext/modules/canvas-tools.js', {au:true});
		}
		
		
		
		if (plotData.chart && plotData.chart.style)
			options.chart = {
				style: plotData.chart.style
			};
		return options
	}
	
	
	var PlotEvents = {
			click: {eventName: 'onPlotClick', callback: '_doPlotClick'},
			checkboxClick: {eventName: 'onPlotCheckboxClick', callback: '_doPlotCheckboxClick'},
			legendItemClick: {eventName: 'onPlotLegendItemClick', callback: '_doPlotLegendItemClick'},
			mouseOut: {eventName: 'onPlotMouseOut', callback: '_doPlotMouseOut'},
			mouseOver: {eventName: 'onPlotMouseOver', callback: '_doPlotMouseOver'},
			hide: {eventName: 'onPlotHide', callback: '_doPlotHide'},
			show: {eventName: 'onPlotShow', callback: '_doPlotShow'}
	};
	
	var DefaultOptions = jq.extend(true, {}, Highcharts.getOptions());
	function resetOptions() {
		var options = Highcharts.getOptions();
		for (var key in options) {
			if (typeof options[key] !== 'function')
				delete options[key];
		}
		Highcharts.setOptions(DefaultOptions);
	}
	
	
	(function (H) {
		var NORMAL_STATE = '',
			SELECT_STATE = 'select',
			pick = H.pick,
			each = jq.each,
			inArray = jq.inArray;
		
		function decreaseCounter(index, defaultOptions) {
			var length = defaultOptions.length,
				result = index - 1;
			return result < 0 ? length - 1 : result;
		}
			
		H.wrap(H.Point.prototype, 'select', function (select, selected, accumulate, fromServer) {
			var point = this,
				series = point.series,
				chart = series.chart;
		
			selected = pick(selected, !point.selected);
		
			
			
			point.firePointEvent(selected ? 'select' : 'unselect', { accumulate: accumulate, fromServer: fromServer}, function () {
				point.selected = point.options.selected = selected;
				series.options.data[inArray(point, series.data)] = point.options;
			
				point.setState(selected && SELECT_STATE);
			
				
				if (!accumulate) {
					each(chart.getSelectedPoints(), function (i, loopPoint) {
						if (loopPoint.selected && loopPoint !== point) {
							loopPoint.selected = loopPoint.options.selected = false;
							series.options.data[inArray(loopPoint, series.data)] = loopPoint.options;
							loopPoint.setState(NORMAL_STATE);
							
							loopPoint.firePointEvent('unselect', {fromServer: fromServer});
						}
					});
				}
			});
		});
		
		H.wrap(H.Series.prototype, 'remove', function (remove) {
			var chart = this.chart,
				counters = chart.counters;
			remove.apply(this);
			counters.color = decreaseCounter(counters.color, chart.options.colors);
			counters.symbol = decreaseCounter(counters.symbol, chart.options.symbols);
		});
	} (Highcharts));
	
	var All_Charts_Type = ['area', 'arearange', 'areaspline', 'areasplinerange',
	                       'bar', 'boxplot', 'bubble', 'column', 'columnrange',
	                       'errorbar', 'funnel', 'gauge', 'line', 'pie', 'scatter',
	                       'series', 'spline', 'waterfall', 'polar'];
	
chart.Charts = zk.$extends(zul.Widget, {

	$init: function () {
		this.$supers('$init', arguments);
	},
	$define: {
		options: null,
		theme: null,
		series: null,
	},
	bind_: function () {
		this.$supers(chart.Charts,'bind_', arguments);
		if (this.plotData) {
			
			
			if (this._theme) {
				
				resetOptions();
				if (this._theme != 'DefaultTheme')
					Highcharts.setOptions(this._theme);
			}
			var plotData = this._convertAttrs(this.plotData);
			
			Highcharts.setOptions(_convertGlobalOptions(this._options, plotData));
			this.engine = new Highcharts.Chart(plotData);
		}
	},
	
	setEval: function (func) {
		try {
			if (func && func != zk.$void) {
				if (jq.isArray(func)) {
					var self = this;
					jq(func).each(function () {
						this.call(self.engine);
					});
				} else {
					func.call(this.engine);
				}
			}
		} catch (e) {
			zk.error(e);
		}
	},
	
	echo: function (attrId, func) {
		this.fire('dummyEcho', {id: attrId, value: func.apply(this.engine, null)}, {toServer: true});
	},
	
	_doPlotClick: function (evt) {
		var p = evt.point,
			pIndex = p.series.data.indexOf(p); 
		this.fire('onPlotClick', {sIndex: p.series.index, pIndex: pIndex, category: p.category || p.name});
	},
	_doPlotCheckboxClick: function (evt) {
		this.fire('onPlotCheckboxClick', {sIndex: evt.target.index, checked: evt.checked});
	},
	_doPlotHide: function (evt) {
		this.fire('onPlotHide', {sIndex: evt.target.index});
	},
	_doPlotShow: function (evt) {
		this.fire('onPlotShow', {sIndex: evt.target.index});
	},
	_doPlotLegendItemClick: function (evt) {
		this.fire('onPlotLegendItemClick', {sIndex: evt.target.index});
	},
	_doPlotMouseOut: function (evt) {
		this.fire('onPlotMouseOut', {sIndex: evt.target.index});
	},
	_doPlotMouseOver: function (evt) {
		this.fire('onPlotMouseOver', {sIndex: evt.target.index});
	},
	_doPlotDrillDown: function (evt) {
		var p = evt.point,
			pIndex = p.series.data.indexOf(p); 
		this.fire('onPlotDrillDown', {sIndex: p.series.index, pIndex: pIndex, category: p.category || p.name});
	},
	_doPlotDrillUp: function (evt) {
		this.fire('onPlotDrillUp');
	},
	_doPlotSelect: function (evt) {
		var target = evt.target;
		if (!evt.fromServer) {
			this.fire('onPlotSelect', {sIndex: target.series.index,
				pIndex: target.series.data.indexOf(target)}, {toServer: true});
		}
	},
	_doPlotUnselect: function (evt) {
		var target = evt.target;
		if (!evt.fromServer) {
			this.fire('onPlotUnselect', {sIndex: target.series.index,
				pIndex: target.series.data.indexOf(target)}, {toServer: true});
		}
	},
	_convertPlotOptions: function (plotOptions) {
		if (!plotOptions)
			plotOptions = {};
		var type = this.plotData.chart.type;
		if (!type) {
			type = this.plotData.chart.type = 'line'; 
		}
		if (!plotOptions[type]) {
			plotOptions[type] = {events: {}};
		}
		if (!plotOptions[type].events)
			plotOptions[type].events = {};

		for (var evt in PlotEvents) {
			if (this.isListen(PlotEvents[evt].eventName)) {
				
				for (var t = All_Charts_Type.length; t--;) {
					var at = All_Charts_Type[t];

					if (!plotOptions[at]) {
						plotOptions[at] = {events: {}};
					}
					if (!plotOptions[at].events)
						plotOptions[at].events = {};
					
					plotOptions[at].events[evt] = this.proxy(this[PlotEvents[evt].callback]);
				}
			}
		}
		
		if (!plotOptions['series']) {
			plotOptions['series'] = {};
		}
				 
		plotOptions['series'].point = {events: {select: this.proxy(this._doPlotSelect), unselect: this.proxy(this._doPlotUnselect)}};
		
		for (var option in plotOptions) {	
			plotOptions[option] = this._convertFunction(plotOptions[option], 'dataLabels', 'formatter');
		}
		return plotOptions;
	},
	_convertChartAttrs: function (chart) {
		if (!chart)
			chart = {};
		chart.renderTo = this.$n();
		
		for (var k in chart) {
			var val = chart[k];
			switch (k) {
			case 'type':
				if (val == 'polar') 
					delete chart[k];
				break;
			}
		}
		chart.className = chart.className ? chart.className + ' ' + this.getZclass() : this.getZclass();
		
		if (!chart.events)
			chart.events = {};
		if (this.isListen('onClick')) {
			chart.events.click = this.proxy(function (event) {
				this.fireX(new zk.Event(this,
						'onClick', zk.copy(event.mouseData(), {
							xAxis: event.xAxis[0].value,
							yAxis: event.yAxis[0].value
						}), {}, event)
				);
			});
		}
		if (this.isListen('onSelection')) {
			chart.events.selection = this.proxy(function (event) {
				this.fireX(new zk.Event(this,
						'onSelection', {
							xAxisMin: event.xAxis[0].min,
							xAxisMax: event.xAxis[0].max,
							yAxisMin: event.yAxis[0].min,
							yAxisMax: event.yAxis[0].max,
						}, {}, event)
				);
				return !(chart.enableZoomSelection === false);
			});
		}
		if (this.isListen('onPlotDrillDown')) {
			chart.events.drilldown = this.proxy(this._doPlotDrillDown);
			chart.events.drillup = this.proxy(this._doPlotDrillUp);
		}
		return chart;
	},
	_convertCreditsAttrs: function (credits) {
		if (!credits)
			credits = {};
		
		if (credits.enabled == undefined)
			credits.enabled = false; 
		return credits;
	},
	_convertAxisAttrs: function (axis) {
		for(var name in axis) {
			axis[name] = this._convertFunction(axis[name], 'labels', 'formatter');
		}
		return axis;
	},
	_convertFunction: function(parent, attr, func) {
		if (parent[attr] && parent[attr][func])
			parent[attr][func] = new Function(parent[attr][func]);
		return parent;
	},
	_convertAttrs: function (attrs) {
		attrs.chart = this._convertChartAttrs(attrs.chart);
		attrs.credits = this._convertCreditsAttrs(attrs.credits);

		attrs = this._convertFunction(attrs, 'legend', 'labelFormatter');
		for(var name in attrs.series) {
			attrs.series[name] = this._convertFunction(attrs.series[name], 'dataLabels', 'formatter');
		}
		attrs = this._convertFunction(attrs, 'tooltip', 'formatter');
		
		attrs.xAxis = this._convertAxisAttrs(attrs.xAxis);
		attrs.yAxis = this._convertAxisAttrs(attrs.yAxis);
			
		
		attrs.plotOptions = this._convertPlotOptions(attrs.plotOptions);
		return attrs;
	},
	unbind_: function () {
		if (this.engine) {
			this.engine.destroy();
			this.engine = null;
		}
		this.$supers(chart.Charts,'unbind_', arguments);
	},
	_maskTable: function (txt) {
		_maskInfo(this, txt);
	}
});
})();



Highcharts.wrap(Highcharts, 'post', function (proceed, url, data, formAttributes) {
    if (!Highcharts.$exportFrame) {
        Highcharts.$exportFrame = 
            $('<iframe id="hc-export-frame" style="display:none">').appendTo(document.body);   
    }
    formAttributes = Highcharts.merge({ target: 'hc-export-frame' }, formAttributes);
    proceed.call(this, url, data, formAttributes);
});