/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.chart.Axis;
import org.zkoss.chart.OptionDataEvent;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.Series;
import org.zkoss.chart.util.OptionsList;
import org.zkoss.json.JSONAware;

public class ResponseDataHandler
implements JSONAware {
    private Map<Optionable, List<OptionDataEvent>> _queue = new LinkedHashMap<Optionable, List<OptionDataEvent>>();

    public void addQueue(OptionDataEvent event) {
        List<OptionDataEvent> list = this._queue.get(event.getTarget());
        if (list == null) {
            list = new LinkedList<OptionDataEvent>();
            this._queue.put(event.getTarget(), list);
        }
        if (event.getType() == OptionDataEvent.EventType.DESTROYED) {
            for (OptionDataEvent evt : list) {
                if (evt.getType() != OptionDataEvent.EventType.INITIALIZED) continue;
                list.clear();
                return;
            }
        }
        list.add(event);
    }

    public boolean isEmpty() {
        return this._queue.isEmpty();
    }

    public void clear() {
        this._queue.clear();
    }

    public String toJSONString() {
        if (this.isEmpty()) {
            return "null";
        }
        LinkedList response = new LinkedList();
        for (Map.Entry<Optionable, List<OptionDataEvent>> me : this._queue.entrySet()) {
            boolean hasClassOperation = false;
            boolean hasUpdateFunction = false;
            if (me.getKey() instanceof Axis || me.getKey() instanceof Series) {
                for (OptionDataEvent evt : me.getValue()) {
                    if (evt.getType() == OptionDataEvent.EventType.INITIALIZED || evt.getType() == OptionDataEvent.EventType.DESTROYED) {
                        hasClassOperation = true;
                        break;
                    }
                    if (!evt.isJSUpldateCall()) continue;
                    hasUpdateFunction = true;
                }
            } else {
                for (OptionDataEvent evt : me.getValue()) {
                    if (evt.getType() != OptionDataEvent.EventType.INITIALIZED && evt.getType() != OptionDataEvent.EventType.DESTROYED) continue;
                    hasClassOperation = true;
                    break;
                }
            }
            if (hasClassOperation) {
                List<OptionDataEvent> value = me.getValue();
                Iterator<OptionDataEvent> it = value.iterator();
                while (it.hasNext()) {
                    OptionDataEvent evt = it.next();
                    if (evt.getType() == OptionDataEvent.EventType.INITIALIZED || evt.getType() == OptionDataEvent.EventType.DESTROYED) continue;
                    it.remove();
                }
            }
            if (hasUpdateFunction) {
                OptionDataEvent evt;
                HashMap<String, OptionDataEvent> commands = new HashMap<String, OptionDataEvent>();
                List<OptionDataEvent> value = me.getValue();
                Iterator<OptionDataEvent> it = value.iterator();
                while (it.hasNext()) {
                    evt = it.next();
                    if (!evt.isJSUpldateCall()) {
                        it.remove();
                        continue;
                    }
                    if (!(me.getKey() instanceof Axis) || evt.getType() != OptionDataEvent.EventType.CHANGED) continue;
                    commands.put(evt.getKey(), evt);
                }
                if (!commands.isEmpty()) {
                    it = value.iterator();
                    while (it.hasNext()) {
                        evt = it.next();
                        OptionDataEvent latestEvt = (OptionDataEvent)commands.get(evt.getKey());
                        if (latestEvt == null || latestEvt == evt) continue;
                        it.remove();
                    }
                }
            }
            response.addAll(me.getValue());
        }
        return OptionsList.toJSONString(response);
    }
}

