/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.IllegalSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapsHelper {
    public static final Map<? super String, ? super String> parse(Map<? super String, ? super String> map, String src, char pairSeparator, char separator, char quote) throws IllegalSyntaxException {
        return MapsHelper.parse0(map, src, pairSeparator, separator, quote, false, false, false);
    }

    private static final Map parse0(Map map, String src, char pairSeparator, char separator, char quote, boolean asValue, boolean parenthesis, boolean multiple) throws IllegalSyntaxException {
        if (separator == '\u0000') {
            throw new IllegalArgumentException("Separator cannot be 0");
        }
        if (map == null) {
            map = new HashMap();
        }
        if (src == null || src.length() == 0) {
            return map;
        }
        boolean sngldblquote = quote == '\u0001';
        StringBuffer delimsb = new StringBuffer().append(separator);
        if (sngldblquote) {
            delimsb.append("\"'");
            quote = (char)34;
        } else if (quote != '\u0000') {
            delimsb.append(quote);
        }
        String delimValue = delimsb.toString();
        String delimKey = delimsb.append(pairSeparator).toString();
        int j = 0;
        int len = src.length();
        while (true) {
            Token tk = MapsHelper.next(src, delimKey, j, true, parenthesis);
            j = tk.next;
            String name = tk.token;
            if (tk.cc == pairSeparator) {
                if (name.length() == 0) {
                    throw MapsHelper.newIllegalSyntaxException(MCommon.UNEXPECTED_CHARACTER, tk.cc, src);
                }
                ++j;
            } else {
                if (tk.cc == '\u0000') {
                    if (name.length() > 0) {
                        if (asValue) {
                            MapsHelper.put(map, null, name, multiple);
                        } else {
                            MapsHelper.put(map, name, null, multiple);
                        }
                    }
                    return map;
                }
                if (quote != '\u0000' && (tk.cc == quote || sngldblquote && tk.cc == '\'')) {
                    name = null;
                } else {
                    if (separator != ' ' && tk.cc != separator || name.length() == 0) {
                        throw MapsHelper.newIllegalSyntaxException(MCommon.UNEXPECTED_CHARACTER, tk.cc, src);
                    }
                    if (asValue) {
                        MapsHelper.put(map, null, name, multiple);
                    } else {
                        MapsHelper.put(map, name, null, multiple);
                    }
                    if (tk.cc != separator) continue;
                    ++j;
                    continue;
                }
            }
            tk = MapsHelper.next(src, delimValue, j, false, parenthesis);
            j = tk.next;
            String value = tk.token;
            if (quote != '\u0000' && (tk.cc == quote || sngldblquote && tk.cc == '\'')) {
                if (value.length() > 0) {
                    throw MapsHelper.newIllegalSyntaxException(MCommon.UNEXPECTED_CHARACTER, tk.cc, src);
                }
                StringBuffer valsb = new StringBuffer(32);
                while (true) {
                    if (++j == len) {
                        throw MapsHelper.newIllegalSyntaxException(MCommon.EXPECTING_CHARACTER, tk.cc, src);
                    }
                    char cc = src.charAt(j);
                    if (cc == tk.cc) break;
                    valsb.append(cc == '\\' ? MapsHelper.escape(src, ++j) : cc);
                }
                MapsHelper.put(map, name, valsb.toString(), multiple);
                ++j;
            } else {
                MapsHelper.put(map, name, value, multiple);
            }
            if (separator == ' ') continue;
            if ((j = Strings.skipWhitespaces((CharSequence)src, (int)j)) >= len) {
                return map;
            }
            if (src.charAt(j) != separator) {
                throw MapsHelper.newIllegalSyntaxException(MCommon.EXPECTING_CHARACTER, separator, src);
            }
            ++j;
        }
    }

    private static void put(Map map, String name, String value, boolean multiple) {
        if (multiple) {
            LinkedList<String> l = (LinkedList<String>)map.get(name);
            if (l == null) {
                l = new LinkedList<String>();
                map.put(name, l);
            }
            l.add(value);
        } else {
            map.put(name, value);
        }
    }

    private static final char getEndingParenthesis(char cc) {
        return (char)(cc == '{' ? 125 : (cc == '(' ? 41 : (cc == '[' ? 93 : 0)));
    }

    private static int skipParenthesis(String src, int j, char beg, char end) {
        int len = src.length();
        int depth = 0;
        while (++j < len) {
            char cc = src.charAt(j);
            if (cc == '\\') {
                ++j;
                continue;
            }
            if (cc == beg) {
                ++depth;
                continue;
            }
            if (cc != end || --depth >= 0) continue;
            break;
        }
        return j;
    }

    private static final char escape(String src, int j) {
        if (j >= src.length()) {
            throw new IllegalSyntaxException(MCommon.ILLEGAL_CHAR, (Object)"\\");
        }
        char cc = src.charAt(j);
        return (char)(cc == 'n' ? 10 : (cc == 't' ? 9 : (int)cc));
    }

    private static final IllegalSyntaxException newIllegalSyntaxException(int code, char cc, String src) {
        return new IllegalSyntaxException(code, new Object[]{new Character(cc), src});
    }

    private static final Token next(String src, String delimiters, int j, boolean whitespaceAware, boolean parenthesis) {
        StringBuffer tksb = new StringBuffer(64);
        int len = src.length();
        for (j = Strings.skipWhitespaces((CharSequence)src, (int)j); j < len; ++j) {
            char endparen;
            int k;
            char cc = src.charAt(j);
            if (cc == '\\') {
                tksb.append(MapsHelper.escape(src, ++j));
                continue;
            }
            if (delimiters.indexOf(cc) >= 0) {
                j = Strings.skipWhitespaces((CharSequence)src, (int)j);
                break;
            }
            if (Character.isWhitespace(cc)) {
                k = Strings.skipWhitespaces((CharSequence)src, (int)j);
                if (whitespaceAware || k >= len || delimiters.indexOf(src.charAt(k)) >= 0) {
                    j = k;
                    break;
                }
                if (j > k - 1) {
                    tksb.append(src.substring(j, k));
                    j = k - 1;
                    continue;
                }
                tksb.append(cc);
                continue;
            }
            if (parenthesis && (endparen = MapsHelper.getEndingParenthesis(cc)) != '\u0000') {
                k = MapsHelper.skipParenthesis(src, j, cc, endparen);
                if (k >= len) {
                    k = len - 1;
                }
                tksb.append(src.substring(j, k + 1));
                j = k;
                continue;
            }
            if (cc == '\u0000') {
                throw MapsHelper.newIllegalSyntaxException(MCommon.UNEXPECTED_CHARACTER, '\u0000', src);
            }
            tksb.append(cc);
        }
        return new Token(j, j < len ? src.charAt(j) : (char)'\u0000', tksb.toString());
    }

    private static class Token {
        private final int next;
        private final char cc;
        private final String token;

        private Token(int next, char cc, String token) {
            this.next = next;
            this.cc = cc;
            this.token = token;
        }
    }
}

