/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.util;

import java.util.LinkedList;
import java.util.ListIterator;
import org.zkoss.json.JSONAware;
import org.zkoss.json.JSONValue;

public class JSFunction
implements JSONAware {
    private LinkedList<String> js = new LinkedList();
    private static String FUNC = "%1$s()";
    private static String FUNC_ARG = "%1$s(%2$s)";
    private static String ARRAY_ARG = "%1$s[%2$s]";
    private static String WRAP_FUNC = "function () {this.%1$s;}";
    private static String EXEC_FUNC = "function () {%1$s;}";
    private static String RETURN_FUNC = "function () {return this.%1$s;}";
    private static String EMPTY_FUNC = "zk.$void";
    private boolean _reverse = false;

    public JSFunction evalAttribute(String attribute) {
        this.js.add(attribute);
        return this;
    }

    public JSFunction evalJavascript(String javascript) {
        this.js.add(javascript);
        return this;
    }

    public JSFunction callFunction(String funcName) {
        this.js.add(String.format(FUNC, funcName));
        return this;
    }

    public JSFunction callFunction(String funcName, Object ... arguments) {
        StringBuilder args = new StringBuilder();
        for (Object arg : arguments) {
            args.append(JSONValue.toJSONString((Object)arg)).append(',');
        }
        if (arguments.length > 0) {
            args.deleteCharAt(args.length() - 1);
        }
        this.js.add(String.format(FUNC_ARG, funcName, args.toString()));
        return this;
    }

    public void empty() {
        this.js.clear();
    }

    public JSFunction callArray(String attribute, int index) {
        this.js.add(String.format(ARRAY_ARG, attribute, index));
        return this;
    }

    public JSFunction reverse() {
        this._reverse = true;
        return this;
    }

    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        if (this._reverse) {
            ListIterator<String> li = this.js.listIterator(this.js.size());
            while (li.hasPrevious()) {
                sb.append(li.previous()).append('.');
            }
        } else {
            for (String s : this.js) {
                sb.append(s).append('.');
            }
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '.') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.js.isEmpty();
    }

    public String toWrapFunction() {
        return this.isEmpty() ? EMPTY_FUNC : String.format(WRAP_FUNC, this.toString());
    }

    public String toExecFunction() {
        return this.isEmpty() ? EMPTY_FUNC : String.format(EXEC_FUNC, this.toString());
    }

    public String toReturnFunction() {
        return this.isEmpty() ? EMPTY_FUNC : String.format(RETURN_FUNC, this.toString());
    }

    public String toString() {
        return this.isEmpty() ? EMPTY_FUNC : this.toJSONString();
    }
}

