/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.plotOptions.ColumnPlotOptions;
import org.zkoss.chart.util.DynamicalAttribute;

public class WaterfallPlotOptions
extends ColumnPlotOptions {
    public Color getBorderColor() {
        if (!this.containsKey(Attrs.borderColor)) {
            this.setBorderColor("#333333");
        }
        return (Color)this.getAttr(Attrs.borderColor);
    }

    public void setBorderColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.borderColor, color, NOT_NULL_VALUE);
    }

    public void setBorderColor(String color) {
        this.setBorderColor(new Color(color));
    }

    public void setBorderColor(LinearGradient color) {
        this.setBorderColor(new Color(color));
    }

    public void setBorderColor(RadialGradient color) {
        this.setBorderColor(new Color(color));
    }

    public String getDashStyle() {
        return this.getAttr(Attrs.dashStyle, "Dot").asString();
    }

    public void setDashStyle(String dashStyle) {
        if (!("Solid".equalsIgnoreCase(dashStyle) || "ShortDash".equalsIgnoreCase(dashStyle) || "ShortDot".equalsIgnoreCase(dashStyle) || "ShortDashDot".equalsIgnoreCase(dashStyle) || "ShortDashDotDot".equalsIgnoreCase(dashStyle) || "Dot".equalsIgnoreCase(dashStyle) || "Dash".equalsIgnoreCase(dashStyle) || "LongDash".equalsIgnoreCase(dashStyle) || "DashDot".equalsIgnoreCase(dashStyle) || "LongDashDot".equalsIgnoreCase(dashStyle) || "LongDashDotDot".equalsIgnoreCase(dashStyle))) {
            throw new IllegalArgumentException("Unsupported style: [" + dashStyle + "]");
        }
        this.setAttr((PlotAttribute)Attrs.dashStyle, dashStyle, "Dot");
    }

    public Color getLineColor() {
        if (!this.containsKey(Attrs.lineColor)) {
            this.setLineColor("#333333");
        }
        return (Color)this.getAttr(Attrs.lineColor);
    }

    public void setLineColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.lineColor, color, NOT_NULL_VALUE);
    }

    public void setLineColor(String color) {
        this.setLineColor(new Color(color));
    }

    public void setLineColor(LinearGradient color) {
        this.setLineColor(new Color(color));
    }

    public void setLineColor(RadialGradient color) {
        this.setLineColor(new Color(color));
    }

    public Color getUpColor() {
        if (!this.containsKey(Attrs.upColor)) {
            this.setLineColor((String)null);
        }
        return (Color)this.getAttr(Attrs.upColor);
    }

    public void setUpColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.upColor, color, NOT_NULL_VALUE);
    }

    public void setUpColor(String color) {
        this.setUpColor(new Color(color));
    }

    public void setUpColor(LinearGradient color) {
        this.setUpColor(new Color(color));
    }

    public void setUpColor(RadialGradient color) {
        this.setUpColor(new Color(color));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        borderColor,
        dashStyle,
        lineColor,
        upColor;

    }
}

