/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.Animation;
import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Marker;
import org.zkoss.chart.OptionDataListener;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.States;
import org.zkoss.chart.plotOptions.DataLabels;
import org.zkoss.chart.plotOptions.TooltipPlotOptions;
import org.zkoss.chart.util.DynamicalAttribute;

public class SeriesPlotOptions
extends Optionable
implements OptionDataListener {
    public boolean isAllowPointSelect() {
        return this.getAttr(Attrs.allowPointSelect, false).asBoolean();
    }

    public void setAllowPointSelect(boolean allowPointSelect) {
        this.setAttr(Attrs.allowPointSelect, allowPointSelect);
    }

    public boolean isAnimation() {
        return this.getAnimation() != Animation.NONE;
    }

    public Animation getAnimation() {
        if (this.containsKey(Attrs.animation)) {
            return (Animation)this.getAttr(Attrs.animation);
        }
        return (Animation)this.getAttr(Attrs.animation, Animation.class).asValue();
    }

    public void setAnimation(boolean animation) {
        this.setAnimation(animation ? new Animation() : Animation.NONE);
    }

    public void setAnimation(Animation animation) {
        this.setAttr(Attrs.animation, animation == null ? Animation.NONE : animation);
    }

    public Number getBorderWidth() {
        return this.getAttr(Attrs.borderWidth, null).asNumber();
    }

    public void setBorderWidth(Number borderWidth) {
        this.setAttr(Attrs.borderWidth, borderWidth);
    }

    public Color getColor() {
        return (Color)this.getAttr(Attrs.color, null).asValue();
    }

    public void setColor(Color color) {
        this.setAttr(Attrs.color, color);
    }

    public void setColor(String color) {
        this.setColor(new Color(color));
    }

    public void setColor(LinearGradient color) {
        this.setColor(new Color(color));
    }

    public void setColor(RadialGradient color) {
        this.setColor(new Color(color));
    }

    public boolean isConnectEnds() {
        return this.getAttr(Attrs.connectEnds, true).asBoolean();
    }

    public void setConnectEnds(boolean connectEnds) {
        this.setAttr(Attrs.connectEnds, connectEnds);
    }

    public boolean isConnectNulls() {
        return this.getAttr(Attrs.connectNulls, false).asBoolean();
    }

    public void setConnectNulls(boolean connectNulls) {
        this.setAttr(Attrs.connectNulls, connectNulls);
    }

    public Number getCropThreshold() {
        return this.getAttr(Attrs.cropThreshold, 300).asNumber();
    }

    public void setCropThreshold(Number cropThreshold) {
        this.setAttr((PlotAttribute)Attrs.cropThreshold, cropThreshold, Integer.valueOf(300));
    }

    public String getCursor() {
        return this.getAttr(Attrs.cursor, null).asString();
    }

    public void setCursor(String cursor) {
        this.setAttr(Attrs.cursor, cursor);
    }

    public String getDashStyle() {
        return this.getAttr(Attrs.dashStyle, "Solid").asString();
    }

    public void setDashStyle(String dashStyle) {
        if (!("Solid".equalsIgnoreCase(dashStyle) || "ShortDash".equalsIgnoreCase(dashStyle) || "ShortDot".equalsIgnoreCase(dashStyle) || "ShortDashDot".equalsIgnoreCase(dashStyle) || "ShortDashDotDot".equalsIgnoreCase(dashStyle) || "Dot".equalsIgnoreCase(dashStyle) || "Dash".equalsIgnoreCase(dashStyle) || "LongDash".equalsIgnoreCase(dashStyle) || "DashDot".equalsIgnoreCase(dashStyle) || "LongDashDot".equalsIgnoreCase(dashStyle) || "LongDashDotDot".equalsIgnoreCase(dashStyle))) {
            throw new IllegalArgumentException("Unsupported style: [" + dashStyle + "]");
        }
        this.setAttr((PlotAttribute)Attrs.dashStyle, dashStyle, "Solid");
    }

    public DataLabels getDataLabels() {
        DataLabels dataLabels = (DataLabels)this.getAttr(Attrs.dataLabels);
        if (dataLabels == null) {
            dataLabels = new DataLabels();
            this.setDataLabels(dataLabels);
        }
        return dataLabels;
    }

    public void setDataLabels(DataLabels dataLabels) {
        this.setAttr(Attrs.dataLabels, dataLabels);
    }

    public boolean isEnableMouseTracking() {
        return this.getAttr(Attrs.enableMouseTracking, true).asBoolean();
    }

    public void setEnableMouseTracking(boolean enableMouseTracking) {
        this.setAttr(Attrs.enableMouseTracking, enableMouseTracking);
    }

    public String getId() {
        return this.getAttr(Attrs.id, null).asString();
    }

    public void setId(String id) {
        this.setAttr(Attrs.id, id);
    }

    public Number getLineWidth() {
        return this.getAttr(Attrs.lineWidth, 2).asNumber();
    }

    public void setLineWidth(Number lineWidth) {
        this.setAttr((PlotAttribute)Attrs.lineWidth, lineWidth, Integer.valueOf(2));
    }

    public String getLinkedTo() {
        return this.getAttr(Attrs.linkedTo, null).asString();
    }

    public void setLinkedTo(String linkedTo) {
        this.setAttr(Attrs.linkedTo, linkedTo);
    }

    public Marker getMarker() {
        Marker marker = (Marker)this.getAttr(Attrs.marker);
        if (marker == null) {
            marker = new Marker();
            this.setMarker(marker);
        }
        return marker;
    }

    public void setMarker(Marker marker) {
        this.setAttr(Attrs.marker, marker);
    }

    public String getNeckHeight() {
        return this.getAttr(Attrs.neckHeight, null).asString();
    }

    public void setNeckHeight(String neckHeight) {
        this.setAttr(Attrs.neckHeight, neckHeight);
    }

    public String getNeckWidth() {
        return this.getAttr(Attrs.neckWidth, null).asString();
    }

    public void setNeckWidth(String neckWidth) {
        this.setAttr(Attrs.neckWidth, neckWidth);
    }

    public Color getNegativeColor() {
        return (Color)this.getAttr(Attrs.negativeColor, null).asValue();
    }

    public void setNegativeColor(Color color) {
        this.setAttr(Attrs.negativeColor, color);
    }

    public void setNegativeColor(String color) {
        this.setNegativeColor(new Color(color));
    }

    public void setNegativeColor(LinearGradient color) {
        this.setNegativeColor(new Color(color));
    }

    public void setNegativeColor(RadialGradient color) {
        this.setNegativeColor(new Color(color));
    }

    public Number getPointInterval() {
        return this.getAttr(Attrs.pointInterval, 1).asNumber();
    }

    public void setPointInterval(Number pointInterval) {
        this.setAttr((PlotAttribute)Attrs.pointInterval, pointInterval, Integer.valueOf(1));
    }

    public Object getPointPlacement() {
        return this.getAttr(Attrs.pointPlacement, null).asValue();
    }

    public void setPointPlacement(String pointPlacement) {
        if (!"on".equals(pointPlacement) && !"between".equals(pointPlacement)) {
            throw new IllegalArgumentException("Unsupported pointPlacement: [" + pointPlacement + "]");
        }
        this.setAttr(Attrs.pointPlacement, pointPlacement);
    }

    public void setPointPlacement(Number pointPlacement) {
        this.setAttr(Attrs.pointPlacement, pointPlacement);
    }

    public Number getPointStart() {
        return this.getAttr(Attrs.pointStart, 0).asNumber();
    }

    public void setPointStart(Number pointStart) {
        this.setAttr((PlotAttribute)Attrs.pointStart, pointStart, Integer.valueOf(0));
    }

    public boolean isSelected() {
        return this.getAttr(Attrs.selected, false).asBoolean();
    }

    public void setSelected(boolean selected) {
        this.setAttr(Attrs.selected, selected);
    }

    public boolean isShadow() {
        return this.getAttr(Attrs.shadow, false).asBoolean();
    }

    public void setShadow(boolean shadow) {
        this.setAttr(Attrs.shadow, shadow);
    }

    public boolean isShowCheckbox() {
        return this.getAttr(Attrs.showCheckbox, false).asBoolean();
    }

    public void setShowCheckbox(boolean showCheckbox) {
        this.setAttr(Attrs.showCheckbox, showCheckbox);
    }

    public boolean isShowInLegend() {
        return this.getAttr(Attrs.showInLegend, true).asBoolean();
    }

    public void setShowInLegend(boolean showInLegend) {
        this.setAttr(Attrs.showInLegend, showInLegend);
    }

    public String getStacking() {
        return this.getAttr(Attrs.stacking, null).asString();
    }

    public void setStacking(String stacking) {
        if (stacking != null && !"normal".equals(stacking) && !"percent".equals(stacking)) {
            throw new IllegalArgumentException("Unsupported value: [" + stacking + "]");
        }
        this.setAttr(Attrs.stacking, stacking);
    }

    public States getStates() {
        States states = (States)this.getAttr(Attrs.states);
        if (states == null) {
            states = new States();
            this.setStates(states);
        }
        return states;
    }

    public void setStates(States states) {
        this.setAttr(Attrs.states, states);
    }

    public boolean isStickyTracking() {
        return this.getAttr(Attrs.stickyTracking, true).asBoolean();
    }

    public void setStickyTracking(boolean stickyTracking) {
        this.setAttr(Attrs.stickyTracking, stickyTracking);
    }

    public Number getThreshold() {
        return this.getAttr(Attrs.threshold, 0).asNumber();
    }

    public void setThreshold(Number threshold) {
        this.setAttr((PlotAttribute)Attrs.threshold, threshold, Integer.valueOf(0));
    }

    public TooltipPlotOptions getTooltip() {
        TooltipPlotOptions tooltip = (TooltipPlotOptions)this.getAttr(Attrs.tooltip);
        if (tooltip == null) {
            tooltip = new TooltipPlotOptions();
            this.setTooltip(tooltip);
        }
        return tooltip;
    }

    public void setTooltip(TooltipPlotOptions tooltip) {
        this.setAttr(Attrs.tooltip, tooltip);
    }

    public Number getTurboThreshold() {
        return this.getAttr(Attrs.turboThreshold, 1000).asNumber();
    }

    public void setTurboThreshold(Number turboThreshold) {
        this.setAttr((PlotAttribute)Attrs.turboThreshold, turboThreshold, Integer.valueOf(1000));
    }

    public boolean isVisible() {
        return this.getAttr(Attrs.visible, true).asBoolean();
    }

    public void setVisible(boolean visible) {
        this.setAttr(Attrs.visible, visible);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        allowPointSelect,
        borderWidth,
        animation,
        color,
        connectEnds,
        connectNulls,
        cropThreshold,
        cursor,
        dashStyle,
        dataLabels,
        enableMouseTracking,
        id,
        lineWidth,
        linkedTo,
        marker,
        neckHeight,
        neckWidth,
        negativeColor,
        point,
        pointInterval,
        pointPlacement,
        pointStart,
        selected,
        shadow,
        showCheckbox,
        showInLegend,
        stacking,
        states,
        stickyTracking,
        threshold,
        tooltip,
        turboThreshold,
        visible;

    }
}

