/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.plotOptions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.plotOptions.DataLabels;
import org.zkoss.chart.plotOptions.PieDataLabels;
import org.zkoss.chart.plotOptions.SeriesPlotOptions;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PiePlotOptions
extends SeriesPlotOptions {
    @Override
    public DataLabels getDataLabels() {
        DataLabels dataLabels = (DataLabels)this.getAttr(Attrs.dataLabels);
        if (dataLabels == null) {
            dataLabels = new PieDataLabels();
            this.setDataLabels(dataLabels);
        }
        return dataLabels;
    }

    public Color getBorderColor() {
        if (!this.containsKey(Attrs.borderColor)) {
            this.setBorderColor("#FFFFFF");
        }
        return (Color)this.getAttr(Attrs.borderColor);
    }

    public void setBorderColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.borderColor, color, NOT_NULL_VALUE);
    }

    public void setBorderColor(String color) {
        this.setBorderColor(new Color(color));
    }

    public void setBorderColor(LinearGradient color) {
        this.setBorderColor(new Color(color));
    }

    public void setBorderColor(RadialGradient color) {
        this.setBorderColor(new Color(color));
    }

    @Override
    public Number getBorderWidth() {
        return this.getAttr(Attrs.borderWidth, 1).asNumber();
    }

    @Override
    public void setBorderWidth(Number borderWidth) {
        this.setAttr((PlotAttribute)Attrs.borderWidth, borderWidth, Integer.valueOf(1));
    }

    public List<String> getCenter() {
        if (!this.containsKey(Attrs.center)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("50%");
            list.add("50%");
            this.setCenter(list);
        }
        return (List)Generics.cast((Object)this.getAttr(Attrs.center));
    }

    public <T> void setCenter(List<T> center) {
        this.setAttr((PlotAttribute)Attrs.center, center, NOT_NULL_VALUE);
    }

    public void setCenter(Object ... center) {
        this.setCenter(Arrays.asList(center));
    }

    public List<Color> getColors() {
        return (List)Generics.cast((Object)this.getAttr(Attrs.colors, null).asValue());
    }

    public <T> void setColors(List<Color> colors) {
        this.setAttr(Attrs.colors, colors);
    }

    public void setColors(String ... source) {
        Color[] colors = new Color[source.length];
        int i = 0;
        for (String s : source) {
            colors[i++] = new Color(s);
        }
        this.setColors(Arrays.asList(colors));
    }

    public Number getEndAngle() {
        if (this.containsKey(Attrs.endAngle)) {
            return (Number)this.getAttr(Attrs.endAngle);
        }
        return (Integer)this.getStartAngle() + 360;
    }

    public void setEndAngle(Number endAngle) {
        this.setAttr((PlotAttribute)Attrs.endAngle, endAngle, NOT_NULL_VALUE);
    }

    public boolean isIgnoreHiddenPoint() {
        return this.getAttr(Attrs.ignoreHiddenPoint, true).asBoolean();
    }

    public void setIgnoreHiddenPoint(boolean ignoreHiddenPoint) {
        this.setAttr(Attrs.ignoreHiddenPoint, ignoreHiddenPoint);
    }

    public String getInnerSize() {
        return this.getAttr(Attrs.innerSize, "0").asString();
    }

    public void setInnerSize(String innerSize) {
        this.setAttr((PlotAttribute)Attrs.innerSize, innerSize, "0");
    }

    public void setInnerSize(Number innerSize) {
        this.setAttr((PlotAttribute)Attrs.innerSize, innerSize, Integer.valueOf(0));
    }

    public Number getMinSize() {
        return this.getAttr(Attrs.minSize, 80).asNumber();
    }

    public void setMinSize(Number minSize) {
        this.setAttr((PlotAttribute)Attrs.minSize, minSize, Integer.valueOf(80));
    }

    @Override
    public boolean isShowInLegend() {
        return this.getAttr(Attrs.showInLegend, false).asBoolean();
    }

    @Override
    public void setShowInLegend(boolean showInLegend) {
        this.setAttr(Attrs.showInLegend, showInLegend);
    }

    public Object getSize() {
        return this.getAttr(Attrs.size, null).asValue();
    }

    public void setSize(String size) {
        this.setAttr(Attrs.size, size);
    }

    public void setSize(Number size) {
        this.setAttr(Attrs.size, size);
    }

    public Number getSlicedOffset() {
        return this.getAttr(Attrs.slicedOffset, 10).asNumber();
    }

    public void setSlicedOffset(Number slicedOffset) {
        this.setAttr((PlotAttribute)Attrs.slicedOffset, slicedOffset, Integer.valueOf(10));
    }

    public Number getStartAngle() {
        return this.getAttr(Attrs.startAngle, 0).asNumber();
    }

    public void setStartAngle(Number startAngle) {
        this.setAttr((PlotAttribute)Attrs.startAngle, startAngle, Integer.valueOf(0));
    }

    @Override
    public boolean isStickyTracking() {
        return this.getAttr(Attrs.stickyTracking, false).asBoolean();
    }

    @Override
    public void setStickyTracking(boolean stickyTracking) {
        this.setAttr(Attrs.stickyTracking, stickyTracking);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        borderColor,
        borderWidth,
        center,
        colors,
        dataLabels,
        endAngle,
        events,
        ignoreHiddenPoint,
        innerSize,
        minSize,
        showInLegend,
        size,
        slicedOffset,
        startAngle,
        stickyTracking;

    }
}

