/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.plotOptions;

import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.Shadow;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataLabels
extends Optionable {
    public String getAlign() {
        return this.getAttr(Attrs.align, "center").asString();
    }

    public void setAlign(String align) {
        if (!("left".equals(align) || "center".equals(align) || "right".equals(align))) {
            throw new IllegalArgumentException("Unsupported align: [" + align + "]");
        }
        this.setAttr((PlotAttribute)Attrs.align, align, "center");
    }

    public Color getBackgroundColor() {
        return (Color)this.getAttr(Attrs.backgroundColor, null).asValue();
    }

    public void setBackgroundColor(Color color) {
        this.setAttr(Attrs.backgroundColor, color);
    }

    public void setBackgroundColor(String color) {
        this.setBackgroundColor(new Color(color));
    }

    public void setBackgroundColor(LinearGradient color) {
        this.setBackgroundColor(new Color(color));
    }

    public void setBackgroundColor(RadialGradient color) {
        this.setBackgroundColor(new Color(color));
    }

    public Color getBorderColor() {
        return (Color)this.getAttr(Attrs.borderColor, null).asValue();
    }

    public void setBorderColor(Color color) {
        this.setAttr(Attrs.borderColor, color);
    }

    public void setBorderColor(String color) {
        this.setBorderColor(new Color(color));
    }

    public void setBorderColor(LinearGradient color) {
        this.setBorderColor(new Color(color));
    }

    public void setBorderColor(RadialGradient color) {
        this.setBorderColor(new Color(color));
    }

    public Number getBorderRadius() {
        return this.getAttr(Attrs.borderRadius, 0).asNumber();
    }

    public void setBorderRadius(Number borderRadius) {
        this.setAttr((PlotAttribute)Attrs.borderRadius, borderRadius, Integer.valueOf(0));
    }

    public Number getBorderWidth() {
        return this.getAttr(Attrs.borderWidth, 0).asNumber();
    }

    public void setBorderWidth(Number borderWidth) {
        this.setAttr((PlotAttribute)Attrs.borderWidth, borderWidth, Integer.valueOf(0));
    }

    public Color getColor() {
        return (Color)this.getAttr(Attrs.color, null).asValue();
    }

    public void setColor(Color color) {
        this.setAttr(Attrs.color, color);
    }

    public void setColor(String color) {
        this.setColor(new Color(color));
    }

    public void setColor(LinearGradient color) {
        this.setColor(new Color(color));
    }

    public void setColor(RadialGradient color) {
        this.setColor(new Color(color));
    }

    public boolean isCrop() {
        return this.getAttr(Attrs.crop, true).asBoolean();
    }

    public void setCrop(boolean crop) {
        this.setAttr(Attrs.crop, crop);
    }

    public Number getDistance() {
        return this.getAttr(Attrs.distance, 0).asNumber();
    }

    public void setDistance(Number distance) {
        this.setAttr((PlotAttribute)Attrs.distance, distance, Integer.valueOf(0));
    }

    public boolean isEnabled() {
        return this.getAttr(Attrs.enabled, false).asBoolean();
    }

    public void setEnabled(boolean enabled) {
        this.setAttr(Attrs.enabled, enabled);
    }

    public String getFormat() {
        return this.getAttr(Attrs.format, "{y}").asString();
    }

    public void setFormat(String format) {
        this.setAttr((PlotAttribute)Attrs.format, format, "{y}");
    }

    public boolean isInside() {
        return this.getAttr(Attrs.inside, false).asBoolean();
    }

    public void setInside(boolean inside) {
        this.setAttr(Attrs.inside, inside);
    }

    public String getOverflow() {
        return this.getAttr(Attrs.overflow, "justify").asString();
    }

    public void setOverflow(String overflow) {
        this.setAttr((PlotAttribute)Attrs.overflow, overflow, "justify");
    }

    public Number getPadding() {
        return this.getAttr(Attrs.padding, 2).asNumber();
    }

    public void setPadding(int padding) {
        this.setAttr((PlotAttribute)Attrs.padding, padding, Integer.valueOf(2));
    }

    public Object getRotation() {
        return this.getAttr(Attrs.rotation, 0).asValue();
    }

    public void setRotation(Number rotation) {
        this.setAttr((PlotAttribute)Attrs.rotation, rotation, Integer.valueOf(0));
    }

    public void setRotation(String rotation) {
        this.setAttr(Attrs.rotation, rotation);
    }

    public boolean isShadow() {
        return this.getShadow() != Shadow.NONE;
    }

    public Shadow getShadow() {
        return (Shadow)this.getAttr(Attrs.shadow, Shadow.NONE).asValue();
    }

    public void setShadow(boolean shadow) {
        this.setShadow(shadow ? new Shadow() : Shadow.NONE);
    }

    public void setShadow(Shadow shadow) {
        this.setAttr(Attrs.shadow, shadow);
    }

    public boolean isSoftConnector() {
        return this.getAttr(Attrs.softConnector, false).asBoolean();
    }

    public void setSoftConnector(boolean softConnector) {
        this.setAttr(Attrs.softConnector, softConnector);
    }

    public <K, V> Map<K, V> getStyle() {
        return (Map)Generics.cast((Object)this.getAttr(Attrs.style, null).asValue());
    }

    public void setStyle(String style) {
        this.setStyle(MapsHelper.parse(new LinkedHashMap(), style, ':', ';', '\''));
    }

    public <K, V> void setStyle(Map<K, V> style) {
        this.setAttr(Attrs.style, style);
    }

    public boolean isUseHTML() {
        return this.getAttr(Attrs.useHTML, false).asBoolean();
    }

    public void setUseHTML(boolean useHTML) {
        this.setAttr(Attrs.useHTML, useHTML);
    }

    public String getVerticalAlign() {
        return this.getAttr(Attrs.verticalAlign, null).asString();
    }

    public void setVerticalAlign(String verticalAlign) {
        if (!("top".equals(verticalAlign) || "middle".equals(verticalAlign) || "bottom".equals(verticalAlign))) {
            throw new IllegalArgumentException("Unsupported vertical align: [" + verticalAlign + "]");
        }
        this.setAttr(Attrs.verticalAlign, verticalAlign);
    }

    public Number getX() {
        return this.getAttr(Attrs.x, 0).asNumber();
    }

    public void setX(Number x) {
        this.setAttr((PlotAttribute)Attrs.x, x, Integer.valueOf(0));
    }

    public Number getY() {
        return this.getAttr(Attrs.y, -6).asNumber();
    }

    public void setY(Number y) {
        this.setAttr((PlotAttribute)Attrs.y, y, NOT_NULL_VALUE);
    }

    public Number getZIndex() {
        return this.getAttr(Attrs.zIndex, 6).asNumber();
    }

    public void setZIndex(Number zIndex) {
        this.setAttr((PlotAttribute)Attrs.zIndex, zIndex, Integer.valueOf(6));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        align,
        backgroundColor,
        borderColor,
        borderRadius,
        borderWidth,
        color,
        crop,
        distance,
        enabled,
        format,
        formatter,
        inside,
        overflow,
        padding,
        rotation,
        shadow,
        softConnector,
        style,
        useHTML,
        verticalAlign,
        x,
        y,
        zIndex;

    }
}

