/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.plotOptions;

import java.util.Arrays;
import java.util.List;
import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.plotOptions.SeriesPlotOptions;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnPlotOptions
extends SeriesPlotOptions {
    @Override
    public Number getCropThreshold() {
        return this.getAttr(Attrs.cropThreshold, 50).asNumber();
    }

    @Override
    public void setCropThreshold(Number cropThreshold) {
        this.setAttr((PlotAttribute)Attrs.cropThreshold, cropThreshold, Integer.valueOf(50));
    }

    public Color getBorderColor() {
        if (!this.containsKey(Attrs.borderColor)) {
            this.setBorderColor("#FFFFFF");
        }
        return (Color)this.getAttr(Attrs.borderColor);
    }

    public void setBorderColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.borderColor, color, NOT_NULL_VALUE);
    }

    public void setBorderColor(String color) {
        this.setBorderColor(new Color(color));
    }

    public void setBorderColor(LinearGradient color) {
        this.setBorderColor(new Color(color));
    }

    public void setBorderColor(RadialGradient color) {
        this.setBorderColor(new Color(color));
    }

    public Number getBorderRadius() {
        return this.getAttr(Attrs.borderRadius, 0).asNumber();
    }

    public void setBorderRadius(Number borderRadius) {
        this.setAttr((PlotAttribute)Attrs.borderRadius, borderRadius, Integer.valueOf(0));
    }

    @Override
    public Number getBorderWidth() {
        return this.getAttr(Attrs.borderWidth, 1).asNumber();
    }

    @Override
    public void setBorderWidth(Number borderWidth) {
        this.setAttr((PlotAttribute)Attrs.borderWidth, borderWidth, Integer.valueOf(1));
    }

    public boolean isColorByPoint() {
        return this.getAttr(Attrs.colorByPoint, false).asBoolean();
    }

    public void setColorByPoint(boolean colorByPoint) {
        this.setAttr(Attrs.colorByPoint, colorByPoint);
    }

    public List<Color> getColors() {
        return (List)Generics.cast((Object)this.getAttr(Attrs.colors, null).asValue());
    }

    public void setColors(List<Color> colors) {
        this.setAttr(Attrs.colors, colors);
    }

    public void setColors(String ... source) {
        Color[] colors = new Color[source.length];
        int i = 0;
        for (String s : source) {
            colors[i++] = new Color(s);
        }
        this.setColors(Arrays.asList(colors));
    }

    public Number getGroupPadding() {
        return this.getAttr(Attrs.groupPadding, 0.2).asNumber();
    }

    public void setGroupPadding(Number groupPadding) {
        this.setAttr((PlotAttribute)Attrs.groupPadding, groupPadding, Double.valueOf(0.2));
    }

    public boolean isGrouping() {
        return this.getAttr(Attrs.grouping, true).asBoolean();
    }

    public void setGrouping(boolean grouping) {
        this.setAttr(Attrs.grouping, grouping);
    }

    public Number getMinPointLength() {
        return this.getAttr(Attrs.minPointLength, 0).asNumber();
    }

    public void setMinPointLength(Number minPointLength) {
        this.setAttr((PlotAttribute)Attrs.minPointLength, minPointLength, Integer.valueOf(0));
    }

    public Number getPointPadding() {
        return this.getAttr(Attrs.pointPadding, 0.1).asNumber();
    }

    public void setPointPadding(Number pointPadding) {
        this.setAttr((PlotAttribute)Attrs.pointPadding, pointPadding, Double.valueOf(0.1));
    }

    public Number getPointRange() {
        return this.getAttr(Attrs.pointRange, null).asNumber();
    }

    public void setPointRange(Number pointRange) {
        this.setAttr(Attrs.pointRange, pointRange);
    }

    public Number getPointWidth() {
        return this.getAttr(Attrs.pointWidth, null).asNumber();
    }

    public void setPointWidth(int pointWidth) {
        this.setAttr(Attrs.pointWidth, pointWidth);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        borderColor,
        borderRadius,
        borderWidth,
        colorByPoint,
        colors,
        groupPadding,
        grouping,
        minPointLength,
        pointPadding,
        pointRange,
        pointWidth,
        threshold,
        cropThreshold;

    }
}

