/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.plotOptions.ColumnPlotOptions;
import org.zkoss.chart.util.DynamicalAttribute;

public class BoxPlotOptions
extends ColumnPlotOptions {
    public Color getFillColor() {
        if (!this.containsKey(Attrs.fillColor)) {
            this.setFillColor("#FFFFFF");
        }
        return (Color)this.getAttr(Attrs.fillColor);
    }

    public void setFillColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.fillColor, color, NOT_NULL_VALUE);
    }

    public void setFillColor(String color) {
        this.setFillColor(new Color(color));
    }

    public void setFillColor(LinearGradient color) {
        this.setFillColor(new Color(color));
    }

    public void setFillColor(RadialGradient color) {
        this.setFillColor(new Color(color));
    }

    public Number getLineWidth() {
        return this.getAttr(Attrs.lineWidth, 1).asNumber();
    }

    public void setLineWidth(Number lineWidth) {
        this.setAttr((PlotAttribute)Attrs.lineWidth, lineWidth, Integer.valueOf(1));
    }

    public String getMedianColor() {
        return this.getAttr(Attrs.medianColor, null).asString();
    }

    public void setMedianColor(String medianColor) {
        this.setAttr(Attrs.medianColor, medianColor);
    }

    public Number getMedianWidth() {
        return this.getAttr(Attrs.medianWidth, 2).asNumber();
    }

    public void setMedianWidth(Number medianWidth) {
        this.setAttr((PlotAttribute)Attrs.medianWidth, medianWidth, Integer.valueOf(2));
    }

    public Color getStemColor() {
        return (Color)this.getAttr(Attrs.stemColor, null).asValue();
    }

    public void setStemColor(Color color) {
        this.setAttr(Attrs.stemColor, color);
    }

    public void setStemColor(String color) {
        this.setStemColor(new Color(color));
    }

    public void setStemColor(LinearGradient color) {
        this.setStemColor(new Color(color));
    }

    public void setStemColor(RadialGradient color) {
        this.setStemColor(new Color(color));
    }

    public String getStemDashStyle() {
        return this.getAttr(Attrs.stemDashStyle, "Solid").asString();
    }

    public void setStemDashStyle(String stemDashStyle) {
        if (!("Solid".equalsIgnoreCase(stemDashStyle) || "ShortDash".equalsIgnoreCase(stemDashStyle) || "ShortDot".equalsIgnoreCase(stemDashStyle) || "ShortDashDot".equalsIgnoreCase(stemDashStyle) || "ShortDashDotDot".equalsIgnoreCase(stemDashStyle) || "Dot".equalsIgnoreCase(stemDashStyle) || "Dash".equalsIgnoreCase(stemDashStyle) || "LongDash".equalsIgnoreCase(stemDashStyle) || "DashDot".equalsIgnoreCase(stemDashStyle) || "LongDashDot".equalsIgnoreCase(stemDashStyle) || "LongDashDotDot".equalsIgnoreCase(stemDashStyle))) {
            throw new IllegalArgumentException("Unsupported style: [" + stemDashStyle + "]");
        }
        this.setAttr((PlotAttribute)Attrs.stemDashStyle, stemDashStyle, "Solid");
    }

    public Number getStemWidth() {
        return this.getAttr(Attrs.stemWidth, null).asNumber();
    }

    public void setStemWidth(Number stemWidth) {
        this.setAttr(Attrs.stemWidth, stemWidth);
    }

    public Color getWhiskerColor() {
        return (Color)this.getAttr(Attrs.whiskerColor, null).asValue();
    }

    public void setWhiskerColor(Color color) {
        this.setAttr(Attrs.whiskerColor, color);
    }

    public void setWhiskerColor(String color) {
        this.setWhiskerColor(new Color(color));
    }

    public void setWhiskerColor(LinearGradient color) {
        this.setWhiskerColor(new Color(color));
    }

    public void setWhiskerColor(RadialGradient color) {
        this.setWhiskerColor(new Color(color));
    }

    public String getWhiskerLength() {
        return this.getAttr(Attrs.whiskerLength, "50%").asString();
    }

    public void setWhiskerLength(String whiskerLength) {
        this.setAttr((PlotAttribute)Attrs.whiskerLength, whiskerLength, "50%");
    }

    public Number getWhiskerWidth() {
        return this.getAttr(Attrs.whiskerWidth, 2).asNumber();
    }

    public void setWhiskerWidth(Number whiskerWidth) {
        this.setAttr((PlotAttribute)Attrs.whiskerWidth, whiskerWidth, Integer.valueOf(2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        fillColor,
        lineWidth,
        medianColor,
        medianWidth,
        stemColor,
        stemDashStyle,
        stemWidth,
        whiskerColor,
        whiskerLength,
        whiskerWidth;

    }
}

