/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.model;

import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.zkoss.chart.model.DefaultDialModel;
import org.zkoss.chart.model.DialModel;
import org.zkoss.chart.model.DialModelRange;
import org.zkoss.lang.Objects;

public class DialModelScale
implements Serializable {
    private static final long serialVersionUID = 20140319145902L;
    private DialModel _model;
    private double _value;
    private String _text;
    private Font _textFont;
    private double _textRadius = 0.7;
    private Font _valueFont;
    private double _valueRadius = 0.6;
    private double _valueAngle = -90.0;
    private Font _tickFont;
    private double _tickRadius = 0.88;
    private String _tickColor;
    private int[] _tickRGB;
    private double _tickLabelOffset = 0.2;
    double _lowerBound;
    double _upperBound;
    double _startAngle;
    double _extent;
    double _majorTickInterval;
    int _minorTickCount;
    private List<DialModelRange> _ranges = new ArrayList<DialModelRange>(4);
    private String _needleType = "pointer";
    private String _needleColor;
    private int[] _needleRGB;
    private double _needleRadius = 0.9;

    DialModelScale(DialModel model) {
        this._model = model;
    }

    public int getIndex() {
        return this._model.indexOf(this);
    }

    public double getValue() {
        return this._value;
    }

    public void setValue(double val) {
        if (Double.compare(this._value, val) != 0) {
            this._value = val;
            this.fireEvent(0, "scaleValue", val);
        }
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        if (!Objects.equals((Object)text, (Object)this._text)) {
            this._text = text;
            this.fireEvent(0, "scaleText", text);
        }
    }

    public Font getTextFont() {
        return this._textFont;
    }

    public void setTextFont(Font font) {
        if (!Objects.equals((Object)font, (Object)this._textFont)) {
            this._textFont = font;
            this.fireEvent(0, "scaleFont", font);
        }
    }

    public double getTextRadius() {
        return this._textRadius;
    }

    public void setTextRadius(double radius) {
        if (Double.compare(this._textRadius, radius) != 0) {
            this._textRadius = radius;
            this.fireEvent(0, "textRadius", radius);
        }
    }

    public Font getValueFont() {
        return this._valueFont;
    }

    public void setValueFont(Font font) {
        if (!Objects.equals((Object)font, (Object)this._valueFont)) {
            this._valueFont = font;
            this.fireEvent(0, "valueFont", font);
        }
    }

    public double getValueRadius() {
        return this._valueRadius;
    }

    public void setValueRadius(double radius) {
        if (Double.compare(this._valueRadius, radius) != 0) {
            this._valueRadius = radius;
            this.fireEvent(0, "valueRadius", radius);
        }
    }

    public double getValueAngle() {
        return this._valueAngle;
    }

    public void setValueAngle(double angle) {
        if (Double.compare(this._valueAngle, angle) != 0) {
            this._valueAngle = angle;
            this.fireEvent(0, "valueAngle", angle);
        }
    }

    public void setScale(double lowerBound, double upperBound, double startAngle, double extent, double majorTickInterval, int minorTickCount) {
        if (Double.compare(lowerBound, this._lowerBound) != 0 || Double.compare(upperBound, this._upperBound) != 0 || Double.compare(startAngle, this._startAngle) != 0 || Double.compare(extent, this._extent) != 0 || Double.compare(majorTickInterval, this._majorTickInterval) != 0 || Double.compare(minorTickCount, this._minorTickCount) != 0) {
            this._lowerBound = lowerBound;
            this._upperBound = upperBound;
            this._startAngle = startAngle;
            this._extent = extent;
            this._majorTickInterval = majorTickInterval;
            this._minorTickCount = minorTickCount;
            this.fireEvent(0, "scale", this);
        }
    }

    public double getScaleLowerBound() {
        return this._lowerBound;
    }

    public double getScaleUpperBound() {
        return this._upperBound;
    }

    public double getScaleStartAngle() {
        return this._startAngle;
    }

    public double getScaleExtent() {
        return this._extent;
    }

    public double getMajorTickInterval() {
        return this._majorTickInterval;
    }

    public int getMinorTickCount() {
        return this._minorTickCount;
    }

    public Font getTickFont() {
        return this._tickFont;
    }

    public void setTickFont(Font font) {
        if (!Objects.equals((Object)font, (Object)this._tickFont)) {
            this._tickFont = font;
            this.fireEvent(0, "tickFont", font);
        }
    }

    public double getTickRadius() {
        return this._tickRadius;
    }

    public void setTickRadius(double radius) {
        if (Double.compare(this._tickRadius, radius) != 0) {
            this._tickRadius = radius;
            this.fireEvent(0, "tickRadius", radius);
        }
    }

    public double getTickLabelOffset() {
        return this._tickLabelOffset;
    }

    public void setTickLabelOffset(double tickLabelOffset) {
        if (Double.compare(this._tickLabelOffset, tickLabelOffset) != 0) {
            this._tickLabelOffset = tickLabelOffset;
            this.fireEvent(0, "tickLabelOffset", tickLabelOffset);
        }
    }

    public void setTickColor(String color) {
        if (Objects.equals((Object)color, (Object)this._tickColor)) {
            return;
        }
        this._tickColor = color;
        if (this._tickColor == null) {
            this._tickRGB = null;
        } else {
            this._tickRGB = new int[3];
            DefaultDialModel.decode(this._tickColor, this._tickRGB);
        }
        this.fireEvent(0, "tickColor", color);
    }

    public String getTickColor() {
        return this._tickColor;
    }

    public int[] getTickRGB() {
        return this._tickRGB;
    }

    public DialModelRange newRange(double lower, double upper, String color, double innerRadius, double outerRadius) {
        DialModelRange range = new DialModelRange(this);
        range.setRange(lower, upper, color, innerRadius, outerRadius);
        this._ranges.add(range);
        this.fireEvent(1, "range", range);
        return range;
    }

    public int rangeSize() {
        return this._ranges.size();
    }

    public DialModelRange getRange(int index) {
        return this._ranges.get(index);
    }

    public void removeRange(DialModelRange range) {
        int index = this._ranges.indexOf(range);
        this._ranges.remove(range);
        this.fireEvent(2, "range", index);
    }

    public String getNeedleType() {
        return this._needleType;
    }

    public void setNeedleType(String type) {
        if (!Objects.equals((Object)this._needleType, (Object)type)) {
            this._needleType = type;
            this.fireEvent(0, "needleType", type);
        }
    }

    public void setNeedleColor(String color) {
        if (Objects.equals((Object)color, (Object)this._needleColor)) {
            return;
        }
        this._needleColor = color;
        if (this._needleColor == null) {
            this._needleRGB = null;
        } else {
            this._needleRGB = new int[3];
            DefaultDialModel.decode(this._needleColor, this._needleRGB);
        }
        this.fireEvent(0, "needleColor", color);
    }

    public String getNeedleColor() {
        return this._needleColor;
    }

    public int[] getNeedleRGB() {
        return this._needleRGB;
    }

    public void setNeedleRadius(double radius) {
        if (Double.compare(this._needleRadius, radius) != 0) {
            this._needleRadius = radius;
            this.fireEvent(0, "needleRadius", radius);
        }
    }

    public double getNeedleRadius() {
        return this._needleRadius;
    }

    void fireEvent(int evt, String propertyKey, Object data) {
        if (this._model != null && this._model instanceof DefaultDialModel) {
            ((DefaultDialModel)this._model).fireEvent(evt, propertyKey, data);
        }
    }
}

