/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.chart.model.AbstractChartsModel;
import org.zkoss.chart.model.SingleValueCategoryModel;
import org.zkoss.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSingleValueCategoryModel
extends AbstractChartsModel
implements SingleValueCategoryModel {
    private static final long serialVersionUID = 20140319154808L;
    private List<Comparable<?>> _categoryList = new ArrayList();
    private Map<Comparable<?>, Number> _categoryMap = new HashMap();

    @Override
    public Comparable<?> getCategory(int index) {
        return this._categoryList.get(index);
    }

    @Override
    public Collection<Comparable<?>> getCategories() {
        return this._categoryList;
    }

    @Override
    public Number getValue(Comparable<?> category) {
        return this._categoryMap.get(category);
    }

    @Override
    public void setValue(Comparable<?> category, Number value) {
        if (!this._categoryMap.containsKey(category)) {
            int cIndex = this._categoryList.size();
            this._categoryList.add(category);
            this._categoryMap.put(category, value);
            this.fireEvent(1, null, category, 0, cIndex, value);
        } else {
            Number ovalue = this._categoryMap.get(category);
            if (Objects.equals((Object)ovalue, (Object)value)) {
                return;
            }
            int cIndex = this._categoryList.indexOf(category);
            this._categoryMap.put(category, value);
            this.fireEvent(0, null, category, 0, cIndex, value);
        }
    }

    @Override
    public void removeValue(Comparable<?> category) {
        this._categoryMap.remove(category);
        int cIndex = this._categoryList.indexOf(category);
        Boolean value = this._categoryList.remove(category);
        this.fireEvent(2, null, category, 0, cIndex, value);
    }

    @Override
    public void clear() {
        this._categoryMap.clear();
        this._categoryList.clear();
        this.fireEvent(2, null, null, -1, -1, null);
    }

    @Override
    public Object clone() {
        DefaultSingleValueCategoryModel clone = (DefaultSingleValueCategoryModel)super.clone();
        if (this._categoryList != null) {
            clone._categoryList = new ArrayList(this._categoryList);
        }
        if (this._categoryMap != null) {
            clone._categoryMap = new HashMap(this._categoryMap);
        }
        return clone;
    }
}

