/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.chart.model.AbstractChartsModel;
import org.zkoss.chart.model.CategoryModel;
import org.zkoss.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCategoryModel
extends AbstractChartsModel
implements CategoryModel {
    private static final long serialVersionUID = 20140319153701L;
    private Map<Comparable<?>, LinkedList<Comparable<?>>> _seriesMap = new HashMap();
    private List<Comparable<?>> _seriesList = new ArrayList();
    private List<Comparable<?>> _categoryList = new ArrayList();
    private Map<List<Comparable<?>>, Number> _valueMap = new LinkedHashMap();

    @Override
    public Comparable<?> getSeries(int index) {
        return this._seriesList.get(index);
    }

    @Override
    public Comparable<?> getCategory(int index) {
        return this._categoryList.get(index);
    }

    @Override
    public Collection<Comparable<?>> getSeries() {
        return this._seriesList;
    }

    @Override
    public Collection<Comparable<?>> getCategories() {
        return this._categoryList;
    }

    @Override
    public Collection<List<Comparable<?>>> getKeys() {
        return this._valueMap.keySet();
    }

    @Override
    public Number getValue(Comparable<?> series, Comparable<?> category) {
        ArrayList key = new ArrayList(2);
        key.add(series);
        key.add(category);
        Number num = this._valueMap.get(key);
        return num;
    }

    @Override
    public void setValue(Comparable<?> series, Comparable<?> category, Number value) {
        ArrayList key = new ArrayList(2);
        key.add(series);
        key.add(category);
        if (!this._valueMap.containsKey(key)) {
            LinkedList<Comparable<Object>> list;
            if (!this._categoryList.contains(category)) {
                this._categoryList.add(category);
            }
            if ((list = this._seriesMap.get(series)) == null) {
                list = new LinkedList();
                list.add(category);
                this._seriesMap.put(series, list);
                this._seriesList.add(series);
            } else {
                list.add(category);
            }
            this._valueMap.put(key, value);
            int cIndex = list.indexOf(category);
            int sIndex = this._seriesList.indexOf(series);
            this.fireEvent(1, series, category, sIndex, cIndex, value);
        } else {
            Number ovalue = this._valueMap.get(key);
            if (Objects.equals((Object)ovalue, (Object)value)) {
                return;
            }
            this._valueMap.put(key, value);
            int cIndex = this._seriesMap.get(series).indexOf(category);
            int sIndex = this._seriesList.indexOf(series);
            this.fireEvent(0, series, category, sIndex, cIndex, value);
        }
    }

    @Override
    public void removeValue(Comparable<?> series, Comparable<?> category) {
        ArrayList key = new ArrayList(2);
        key.add(series);
        key.add(category);
        if (this._valueMap.remove(key) == null) {
            return;
        }
        List cateList = this._seriesMap.get(series);
        int cIndex = cateList.indexOf(category);
        int sIndex = this._seriesList.indexOf(series);
        Number value = this.getValue(series, category);
        cateList.remove(cIndex);
        if (cateList.isEmpty()) {
            this._seriesList.remove(series);
            this._seriesMap.remove(series);
        }
        boolean clear = true;
        for (LinkedList<Comparable<?>> cate : this._seriesMap.values()) {
            if (!cate.contains(category)) continue;
            clear = false;
            break;
        }
        if (clear) {
            this._categoryList.remove(category);
        }
        this.fireEvent(2, series, category, sIndex, cIndex, value);
    }

    @Override
    public void clear() {
        this._seriesMap.clear();
        this._seriesList.clear();
        this._categoryList.clear();
        this._valueMap.clear();
        this.fireEvent(2, null, null, -1, -1, null);
    }

    @Override
    public Object clone() {
        DefaultCategoryModel clone = (DefaultCategoryModel)super.clone();
        if (this._seriesMap != null) {
            clone._seriesMap = new HashMap(this._seriesMap);
        }
        if (this._seriesList != null) {
            clone._seriesList = new ArrayList(this._seriesList);
        }
        if (this._categoryList != null) {
            clone._categoryList = new ArrayList(this._categoryList);
        }
        if (this._valueMap != null) {
            clone._valueMap = new LinkedHashMap(this._valueMap);
        }
        return clone;
    }
}

