/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.model;

import java.util.Collection;
import java.util.List;
import org.zkoss.chart.model.AbstractChartsModel;
import org.zkoss.chart.model.CategoryModel;
import org.zkoss.chart.model.ChartsDataEvent;
import org.zkoss.chart.model.ChartsDataEventImpl;
import org.zkoss.chart.model.ChartsDataListener;
import org.zkoss.chart.model.ChartsModel;
import org.zkoss.chart.model.PieModel;
import org.zkoss.chart.model.SingleValueCategoryModel;
import org.zkoss.chart.model.XYModel;
import org.zkoss.chart.model.XYZModel;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.event.ChartDataEvent;
import org.zkoss.zul.event.ChartDataListener;

public abstract class ChartsModelProxy
extends AbstractChartsModel {
    private ChartModel _model;

    public ChartsModelProxy(ChartModel model) {
        this._model = model;
        this._model.addChartDataListener((ChartDataListener)new SmartChartDataListener(this));
    }

    protected ChartModel getModel() {
        return this._model;
    }

    public static ChartsModel getInstance(ChartModel model) {
        if (model instanceof org.zkoss.zul.CategoryModel) {
            return new CategoryModelProxy(model);
        }
        if (model instanceof org.zkoss.zul.PieModel) {
            return new PieModelProxy(model);
        }
        if (model instanceof org.zkoss.zul.SingleValueCategoryModel) {
            return new SingleValueCategoryModelProxy(model);
        }
        if (model instanceof org.zkoss.zul.XYZModel) {
            return new XYZModelProxy(model);
        }
        if (model instanceof org.zkoss.zul.XYModel) {
            return new XYModelProxy(model);
        }
        throw new IllegalArgumentException("Unsupported ChartModel: [" + model + "], please use the model in org.zkoss.chart.model package instead.");
    }

    public void fireEvent(ChartsDataEvent evt) {
        for (ChartsDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    private static class SmartChartDataListener
    implements ChartDataListener {
        private ChartsModelProxy _model;

        public SmartChartDataListener(ChartsModelProxy model) {
            this._model = model;
        }

        public void onChange(ChartDataEvent event) {
            this._model.fireEvent(new ChartsDataEventImpl(this._model, event.getType(), event.getSeries(), event.getCategory(), event.getSeriesIndex(), event.getCategoryIndex(), event.getData()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XYZModelProxy
    extends XYModelProxy
    implements XYZModel {
        public XYZModelProxy(ChartModel model) {
            super(model);
        }

        protected org.zkoss.zul.XYZModel getModel() {
            return (org.zkoss.zul.XYZModel)super.getModel();
        }

        @Override
        public Number getZ(Comparable<?> series, int index) {
            return this.getModel().getZ(series, index);
        }

        @Override
        public void addValue(Comparable<?> series, Number x, Number y, Number z) {
            this.getModel().addValue(series, x, y, z);
        }

        @Override
        public void addValue(Comparable<?> series, Number x, Number y, Number z, int index) {
            this.getModel().addValue(series, x, y, z, index);
        }

        @Override
        public void setValue(Comparable<?> series, Number x, Number y, Number z, int index) {
            this.getModel().setValue(series, x, y, z, index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XYModelProxy
    extends ChartsModelProxy
    implements XYModel {
        public XYModelProxy(ChartModel model) {
            super(model);
        }

        protected org.zkoss.zul.XYModel getModel() {
            return (org.zkoss.zul.XYModel)super.getModel();
        }

        @Override
        public Comparable<?> getSeries(int index) {
            return this.getModel().getSeries(index);
        }

        @Override
        public Collection<Comparable<?>> getSeries() {
            return this.getModel().getSeries();
        }

        @Override
        public int getDataCount(Comparable<?> series) {
            return this.getModel().getDataCount(series);
        }

        @Override
        public Number getX(Comparable<?> series, int index) {
            return this.getModel().getX(series, index);
        }

        @Override
        public Number getY(Comparable<?> series, int index) {
            return this.getModel().getY(series, index);
        }

        @Override
        public void setValue(Comparable<?> series, Number x, Number y, int index) {
            this.getModel().setValue(series, x, y, index);
        }

        @Override
        public void addValue(Comparable<?> series, Number x, Number y) {
            this.getModel().addValue(series, x, y);
        }

        @Override
        public void addValue(Comparable<?> series, Number x, Number y, int index) {
            this.getModel().addValue(series, x, y, index);
        }

        @Override
        public void setAutoSort(boolean auto) {
            this.getModel().setAutoSort(auto);
        }

        @Override
        public boolean isAutoSort() {
            return this.getModel().isAutoSort();
        }

        @Override
        public void removeSeries(Comparable<?> series) {
            this.getModel().removeSeries(series);
        }

        @Override
        public void removeValue(Comparable<?> series, int index) {
            this.getModel().removeValue(series, index);
        }

        @Override
        public void clear() {
            this.getModel().clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CategoryModelProxy
    extends ChartsModelProxy
    implements CategoryModel {
        public CategoryModelProxy(ChartModel model) {
            super(model);
        }

        protected org.zkoss.zul.CategoryModel getModel() {
            return (org.zkoss.zul.CategoryModel)super.getModel();
        }

        @Override
        public Comparable<?> getSeries(int index) {
            return this.getModel().getSeries(index);
        }

        @Override
        public Comparable<?> getCategory(int index) {
            return this.getModel().getCategory(index);
        }

        @Override
        public Collection<Comparable<?>> getSeries() {
            return this.getModel().getSeries();
        }

        @Override
        public Collection<Comparable<?>> getCategories() {
            return this.getModel().getCategories();
        }

        @Override
        public Collection<List<Comparable<?>>> getKeys() {
            return this.getModel().getKeys();
        }

        @Override
        public Number getValue(Comparable<?> series, Comparable<?> category) {
            return this.getModel().getValue(series, category);
        }

        @Override
        public void setValue(Comparable<?> series, Comparable<?> category, Number value) {
            this.getModel().setValue(series, category, value);
        }

        @Override
        public void removeValue(Comparable<?> series, Comparable<?> category) {
            this.getModel().removeValue(series, category);
        }

        @Override
        public void clear() {
            this.getModel().clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleValueCategoryModelProxy
    extends ChartsModelProxy
    implements SingleValueCategoryModel {
        public SingleValueCategoryModelProxy(ChartModel model) {
            super(model);
        }

        protected org.zkoss.zul.SingleValueCategoryModel getModel() {
            return (org.zkoss.zul.SingleValueCategoryModel)super.getModel();
        }

        @Override
        public Comparable<?> getCategory(int index) {
            return this.getModel().getCategory(index);
        }

        @Override
        public Collection<Comparable<?>> getCategories() {
            return this.getModel().getCategories();
        }

        @Override
        public Number getValue(Comparable<?> category) {
            return this.getModel().getValue(category);
        }

        @Override
        public void setValue(Comparable<?> category, Number value) {
            this.getModel().setValue(category, value);
        }

        @Override
        public void removeValue(Comparable<?> category) {
            this.getModel().removeValue(category);
        }

        @Override
        public void clear() {
            this.getModel().clear();
        }
    }

    private static class PieModelProxy
    extends SingleValueCategoryModelProxy
    implements PieModel {
        public PieModelProxy(ChartModel model) {
            super(model);
        }
    }
}

