/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.chart.model.ChartsDataEventImpl;
import org.zkoss.chart.model.ChartsDataListener;
import org.zkoss.chart.model.ChartsModel;
import org.zkoss.io.Serializables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChartsModel
implements ChartsModel,
Serializable {
    private static final long serialVersionUID = 20140319115913L;
    protected List<ChartsDataListener> _listeners = new LinkedList<ChartsDataListener>();

    protected void fireEvent(int type, Comparable<?> series, Comparable<?> category, int seriesIndex, int categoryIndex, Object data) {
        ChartsDataEventImpl evt = new ChartsDataEventImpl(this, type, series, category, seriesIndex, categoryIndex, data);
        for (ChartsDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    @Override
    public void addChartsDataListener(ChartsDataListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this._listeners.add(l);
    }

    @Override
    public void removeChartsDataListener(ChartsDataListener l) {
        this._listeners.remove(l);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, this._listeners);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedList<ChartsDataListener>();
        Serializables.smartRead((ObjectInputStream)s, this._listeners);
    }

    public Object clone() {
        AbstractChartsModel clone;
        try {
            clone = (AbstractChartsModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._listeners = new LinkedList<ChartsDataListener>();
        return clone;
    }
}

