/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.lic;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.zkoss.chart.lic.KeyStoreParam;
import org.zkoss.chart.lic.LicenseNotaryException;
import org.zkoss.chart.lic.Policy;
import org.zkoss.chart.lic.util.ObfuscatedString;
import org.zkoss.chart.lic.xml.GenericCertificate;

public class LicenseNotary {
    private static final int BUFSIZE = 5120;
    static final String PARAM = new ObfuscatedString(new long[]{668274362144012114L, -2115765889337599212L}).toString();
    private static final String ALIAS = new ObfuscatedString(new long[]{1112708769776922148L, 6703392504509681290L}).toString();
    private static final String EXC_NO_KEY_PWD = new ObfuscatedString(new long[]{-7210613020960449599L, 222075784786550139L, 9025728610804768010L}).toString();
    private static final String EXC_NO_KEY_ENTRY = new ObfuscatedString(new long[]{-1386002024146642540L, 4133952825992554401L, -8020387964636761861L}).toString();
    private static final String EXC_PRIVATE_KEY_OR_PWD_IS_NOT_ALLOWED = new ObfuscatedString(new long[]{-2960555953270849419L, 3827258740935670554L, -3005417608224527600L, 1939660993088349256L, 4750831951568910874L}).toString();
    private static final String EXC_NO_CERTIFICATE_ENTRY = new ObfuscatedString(new long[]{-3872127676557769698L, -2469202953083814859L, 6713970776812571709L, -482260351456063412L}).toString();
    private static final String SHA1_WITH_DSA = new ObfuscatedString(new long[]{-1509550478491572167L, 1688274905166048601L, -4620167493569680976L}).toString();
    private static final String JKS = new ObfuscatedString(new long[]{-6234396975553918200L, 2370155821952859770L}).toString();
    private KeyStoreParam param;
    private KeyStore keyStore;
    private PrivateKey privateKey;
    private PublicKey publicKey;

    protected LicenseNotary() {
    }

    public LicenseNotary(KeyStoreParam param) {
        this.setKeyStoreParam0(param);
    }

    public KeyStoreParam getKeyStoreParam() {
        return this.param;
    }

    public void setKeyStoreParam(KeyStoreParam param) {
        this.setKeyStoreParam0(param);
    }

    private void setKeyStoreParam0(KeyStoreParam param) {
        if (param == null) {
            throw new NullPointerException(PARAM);
        }
        if (param.getAlias() == null) {
            throw new NullPointerException(ALIAS);
        }
        Policy policy = Policy.getCurrent();
        String storePwd = param.getStorePwd();
        policy.checkPwd(storePwd);
        String keyPwd = param.getKeyPwd();
        if (keyPwd != null) {
            policy.checkPwd(keyPwd);
        }
        this.param = param;
        this.keyStore = null;
        this.privateKey = null;
        this.publicKey = null;
    }

    public GenericCertificate sign(Object content) throws Exception {
        GenericCertificate cert = new GenericCertificate();
        this.sign(cert, content);
        return cert;
    }

    void sign(GenericCertificate certificate, Object content) throws Exception {
        certificate.sign(content, this.getPrivateKey(), this.getSignatureEngine());
    }

    public void verify(GenericCertificate certificate) throws Exception {
        certificate.verify(this.getPublicKey(), this.getSignatureEngine());
    }

    protected PrivateKey getPrivateKey() throws LicenseNotaryException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.privateKey == null) {
            KeyStoreParam param = this.getKeyStoreParam();
            String keyPwd = param.getKeyPwd();
            String alias = param.getAlias();
            if (keyPwd == null) {
                throw new LicenseNotaryException(EXC_NO_KEY_PWD, alias);
            }
            KeyStore keystore = this.getKeyStore();
            try {
                this.privateKey = (PrivateKey)keystore.getKey(alias, keyPwd.toCharArray());
            }
            catch (KeyStoreException keystoreIsAlreadyLoaded) {
                throw new AssertionError((Object)keystoreIsAlreadyLoaded);
            }
            if (this.privateKey == null) {
                throw new LicenseNotaryException(EXC_NO_KEY_ENTRY, alias);
            }
        }
        return this.privateKey;
    }

    protected PublicKey getPublicKey() throws LicenseNotaryException, IOException, CertificateException, NoSuchAlgorithmException {
        if (this.publicKey == null) {
            String alias = this.getKeyStoreParam().getAlias();
            KeyStore keystore = this.getKeyStore();
            try {
                if (this.getKeyStoreParam().getKeyPwd() != null != keystore.isKeyEntry(alias)) {
                    throw new LicenseNotaryException(EXC_PRIVATE_KEY_OR_PWD_IS_NOT_ALLOWED, alias);
                }
                Certificate cert = keystore.getCertificate(alias);
                if (cert == null) {
                    throw new LicenseNotaryException(EXC_NO_CERTIFICATE_ENTRY, alias);
                }
                this.publicKey = cert.getPublicKey();
            }
            catch (KeyStoreException keystoreIsAlreadyLoaded) {
                throw new AssertionError((Object)keystoreIsAlreadyLoaded);
            }
        }
        return this.publicKey;
    }

    protected Signature getSignatureEngine() {
        try {
            return Signature.getInstance(SHA1_WITH_DSA);
        }
        catch (NoSuchAlgorithmException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    protected KeyStore getKeyStore() throws IOException, CertificateException, NoSuchAlgorithmException {
        if (this.keyStore != null) {
            return this.keyStore;
        }
        InputStream in = null;
        try {
            this.keyStore = KeyStore.getInstance(JKS);
            in = new BufferedInputStream(this.param.getStream(), 5120);
            this.keyStore.load(in, this.getKeyStoreParam().getStorePwd().toCharArray());
        }
        catch (KeyStoreException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception weDontCare) {}
        }
        return this.keyStore;
    }
}

