/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.impl;

import java.util.LinkedList;
import org.zkoss.chart.Charts;
import org.zkoss.chart.PlotData;
import org.zkoss.chart.Series;
import org.zkoss.chart.impl.PlotEngineImpl;
import org.zkoss.chart.model.CategoryModel;
import org.zkoss.chart.model.ChartsModel;
import org.zkoss.chart.model.XYModel;

public class WaterfallPlotImpl
extends PlotEngineImpl {
    public WaterfallPlotImpl(Charts chart) {
        super(chart);
    }

    public PlotData drawPlot(ChartsModel model) {
        if (model instanceof CategoryModel) {
            return this.drawCategoryModel((CategoryModel)model);
        }
        if (model instanceof XYModel) {
            return this.drawXYModel((XYModel)model);
        }
        throw new IllegalArgumentException("Unsupported model type [" + model + "]");
    }

    protected PlotData drawCategoryModel(CategoryModel model) {
        PlotData plotData = this.getChart().getPlotData();
        int i = 0;
        for (Comparable<?> ser : model.getSeries()) {
            Series series = plotData.getSeries(i++);
            for (Comparable<?> cat : model.getCategories()) {
                series.addPoint(cat.toString(), model.getValue(ser, cat));
            }
            series.setName(ser.toString());
            if (model.getCategories().isEmpty()) continue;
            plotData.getXAxis().setCategories(new LinkedList(model.getCategories()));
        }
        return plotData;
    }
}

