/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart.impl;

import java.awt.Color;
import java.awt.Font;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.zkoss.chart.AxisLabels;
import org.zkoss.chart.Charts;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Pane;
import org.zkoss.chart.PaneBackground;
import org.zkoss.chart.PlotBand;
import org.zkoss.chart.PlotData;
import org.zkoss.chart.PlotEngine;
import org.zkoss.chart.Series;
import org.zkoss.chart.YAxis;
import org.zkoss.chart.YAxisTitle;
import org.zkoss.chart.model.CategoryModel;
import org.zkoss.chart.model.DialModel;
import org.zkoss.chart.model.DialModelRange;
import org.zkoss.chart.model.DialModelScale;
import org.zkoss.chart.model.SingleValueCategoryModel;
import org.zkoss.chart.model.XYModel;
import org.zkoss.chart.model.XYZModel;
import org.zkoss.chart.plotOptions.DataLabels;
import org.zkoss.chart.plotOptions.GaugePivotPlotOptions;
import org.zkoss.chart.plotOptions.GaugePlotOptions;

public abstract class PlotEngineImpl
implements PlotEngine {
    protected Charts _chart;

    public PlotEngineImpl(Charts chart) {
        this._chart = chart;
    }

    public Charts getChart() {
        return this._chart;
    }

    protected PlotData drawCategoryModel(CategoryModel model) {
        PlotData plotData = this.getChart().getPlotData();
        int i = 0;
        for (Comparable<?> ser : model.getSeries()) {
            Series series = plotData.getSeries(i++);
            for (Comparable<?> cat : model.getCategories()) {
                series.addPoint(model.getValue(ser, cat));
            }
            series.setName(ser.toString());
        }
        if (!model.getCategories().isEmpty()) {
            plotData.getXAxis().setCategories(new LinkedList(model.getCategories()));
        }
        return plotData;
    }

    protected PlotData drawSingleValueCategoryModel(SingleValueCategoryModel model) {
        PlotData plotData = this.getChart().getPlotData();
        Series series = plotData.getSeries();
        for (Comparable<?> cate : model.getCategories()) {
            series.addPoint(cate.toString(), model.getValue(cate));
        }
        return plotData;
    }

    protected PlotData drawDialModel(DialModel model) {
        PlotData plotData = this.getChart().getPlotData();
        double capRadius = model.getCapRadius();
        GaugePlotOptions gauge = plotData.getPlotOptions().getGauge();
        GaugePivotPlotOptions pivot = new GaugePivotPlotOptions();
        pivot.setRadius(capRadius * 100.0);
        gauge.setPivot(pivot);
        int len = model.size();
        for (int j = 0; j < len; ++j) {
            double tickLabelOffset;
            double valueRadius;
            DialModelScale scale = model.getScale(j);
            Series series = plotData.getSeries(j);
            YAxis yAxis = plotData.getYAxis(j);
            series.setData(scale.getValue());
            String text = scale.getText();
            if (text != null && text.length() > 0) {
                YAxisTitle title = new YAxisTitle();
                title.setText(text);
                Font font = scale.getTextFont();
                if (font != null) {
                    String fontWeight = font.isBold() ? "bold" : (font.isItalic() ? "italic" : "normal");
                    title.setStyle(String.format("fontWeight: %1$s; fontFamily: %2$s; fontSize: %3$spx", fontWeight, font.getFamily(), font.getSize()));
                }
                yAxis.setTitle(title);
            }
            if ((valueRadius = scale.getValueRadius()) >= 0.0) {
                DataLabels dataLabels = new DataLabels();
                Font font = scale.getValueFont();
                if (font != null) {
                    String fontWeight = font.isBold() ? "bold" : (font.isItalic() ? "italic" : "normal");
                    dataLabels.setStyle(String.format("fontWeight: %1$s; fontFamily: %2$s; fontSize: %3$spx", fontWeight, font.getFamily(), font.getSize()));
                }
                dataLabels.setColor(String.format("RGB(%1$s,  %2$s, %3$s)", Color.darkGray.getRed(), Color.darkGray.getGreen(), Color.darkGray.getBlue()));
                dataLabels.setY((int)(valueRadius * 100.0));
                dataLabels.setRotation(scale.getValueAngle() + 90.0);
                gauge.setDataLabels(dataLabels);
            }
            double low = scale.getScaleLowerBound();
            double up = scale.getScaleUpperBound();
            double sa = scale.getScaleStartAngle();
            double ext = scale.getScaleExtent();
            ext = sa - ext;
            double ti = scale.getMajorTickInterval();
            int mtc = scale.getMinorTickCount();
            yAxis.setMin(low);
            yAxis.setMax(up);
            Pane pane = plotData.getPane();
            pane.setStartAngle(sa);
            pane.setEndAngle(ext);
            LinkedList<PaneBackground> backgrounds = new LinkedList<PaneBackground>();
            String fgColor = model.getFrameFgColor();
            String bgColor = model.getFrameBgColor();
            String bgColor1 = model.getFrameBgColor1();
            String bgColor2 = model.getFrameBgColor2();
            if (fgColor != null) {
                PaneBackground background1 = new PaneBackground();
                background1.setBackgroundColor(fgColor);
                background1.setOuterRadius("111%");
                background1.setBorderWidth(0);
                backgrounds.add(background1);
            }
            if (bgColor != null) {
                PaneBackground background2 = new PaneBackground();
                background2.setBackgroundColor(bgColor);
                background2.setOuterRadius("109%");
                background2.setBorderWidth(0);
                backgrounds.add(background2);
            }
            PaneBackground background3 = new PaneBackground();
            if (bgColor2 != null) {
                LinearGradient gradient;
                String direction = model.getGradientDirection();
                if ("vertical".equalsIgnoreCase(direction) || "center_vertical".equalsIgnoreCase(direction)) {
                    gradient = new LinearGradient(0.0, 0.0, 0.0, 1.0);
                } else if ("horizontal".equalsIgnoreCase(direction) || "center_horizontal".equalsIgnoreCase(direction)) {
                    gradient = new LinearGradient(0.0, 0.0, 1.0, 0.0);
                } else {
                    throw new IllegalArgumentException("Unsupported direction [" + direction + "]");
                }
                if (direction.toLowerCase().startsWith("center")) {
                    gradient.addStop(0.0, bgColor1);
                    gradient.addStop(0.5, bgColor2);
                    gradient.addStop(1.0, bgColor1);
                } else {
                    gradient.setStops(bgColor1, bgColor2);
                }
                background3.setBackgroundColor(gradient);
                backgrounds.add(background3);
            } else if (bgColor1 != null) {
                background3.setBackgroundColor(bgColor1);
                backgrounds.add(background3);
            }
            if (fgColor != null) {
                PaneBackground background4 = new PaneBackground();
                background4.setBackgroundColor(fgColor);
                background4.setInnerRadius("105%");
                background4.setOuterRadius("107%");
                background4.setBorderWidth(0);
                backgrounds.add(background4);
            }
            if (!backgrounds.isEmpty()) {
                pane.setBackground(backgrounds);
            }
            if (ti > 0.0) {
                yAxis.setTickInterval(ti);
                yAxis.setMinorTickInterval(Math.round(ti / (double)(mtc + 1)));
            }
            Font font = scale.getTickFont();
            AxisLabels labels = yAxis.getLabels();
            if (font != null) {
                String fontWeight = font.isBold() ? "bold" : (font.isItalic() ? "italic" : "normal");
                labels.setStyle(String.format("fontWeight: %1$s; fontFamily: %2$s; fontSize: %3$spx", fontWeight, font.getFamily(), font.getSize()));
            }
            if ((tickLabelOffset = scale.getTickLabelOffset()) > 0.0) {
                labels.setY((int)tickLabelOffset);
                labels.setX((int)tickLabelOffset);
            }
            if (labels.getStep() == null) {
                labels.setStep(1);
            }
            yAxis.setLabels(labels);
            int[] tickRGB = scale.getTickRGB();
            if (tickRGB != null) {
                String tickColor = String.format("RGB(%1$s,  %2$s, %3$s)", tickRGB[0], tickRGB[1], tickRGB[2]);
                yAxis.setMinorTickColor(tickColor);
                yAxis.setTickColor(tickColor);
            }
            ArrayList<PlotBand> plotBands = new ArrayList<PlotBand>();
            int klen = scale.rangeSize();
            for (int k = 0; k < klen; ++k) {
                DialModelRange rng = scale.getRange(k);
                int[] rngRGB = rng.getRangeRGB();
                if (rngRGB == null) {
                    rngRGB = new int[]{0, 0, 255};
                }
                String plotBandColor = String.format("RGB(%1$s,  %2$s, %3$s)", rngRGB[0], rngRGB[1], rngRGB[2]);
                PlotBand plotBand = new PlotBand(rng.getLowerBound(), rng.getUpperBound(), plotBandColor);
                plotBand.setInnerRadius(Double.toString(rng.getInnerRadius() * 100.0) + "%");
                plotBand.setOuterRadius(Double.toString(rng.getOuterRadius() * 100.0) + "%");
                plotBands.add(plotBand);
            }
            yAxis.setPlotBands(plotBands);
        }
        return plotData;
    }

    protected PlotData drawXYModel(XYModel model) {
        Map<Number, Integer> indexMap;
        PlotData plotData = this.getChart().getPlotData();
        HashMap seriesMap = new HashMap();
        AbstractSet xSet = null;
        xSet = model.isAutoSort() ? new TreeSet() : new LinkedHashSet(13);
        for (Comparable<?> ser : model.getSeries()) {
            int size = model.getDataCount(ser);
            indexMap = new TreeMap();
            for (int j = 0; j < size; ++j) {
                Number x = model.getX(ser, j);
                xSet.add(x);
                indexMap.put(x, new Integer(j));
            }
            seriesMap.put(ser, indexMap);
        }
        int i = 0;
        for (Comparable<?> ser : model.getSeries()) {
            indexMap = (Map)seriesMap.get(ser);
            Series series = plotData.getSeries(i++);
            for (Number x : xSet) {
                Integer o = (Integer)indexMap.get(x);
                if (o == null) continue;
                series.addPoint(x, model.getY(ser, o));
            }
            series.setName(ser.toString());
        }
        return plotData;
    }

    protected PlotData drawXYZModel(XYZModel model) {
        Map<Number, Integer> indexMap;
        PlotData plotData = this.getChart().getPlotData();
        HashMap seriesMap = new HashMap();
        AbstractSet xSet = null;
        xSet = model.isAutoSort() ? new TreeSet() : new LinkedHashSet(13);
        for (Comparable<?> ser : model.getSeries()) {
            int size = model.getDataCount(ser);
            indexMap = new TreeMap();
            for (int j = 0; j < size; ++j) {
                Number x = model.getX(ser, j);
                xSet.add(x);
                indexMap.put(x, new Integer(j));
            }
            seriesMap.put(ser, indexMap);
        }
        int i = 0;
        for (Comparable<?> ser : model.getSeries()) {
            indexMap = (Map)seriesMap.get(ser);
            Series series = plotData.getSeries(i++);
            for (Number x : xSet) {
                Integer o = (Integer)indexMap.get(x);
                if (o == null) continue;
                series.addPoint(x, model.getY(ser, o), model.getZ(ser, o));
            }
            series.setName(ser.toString());
        }
        return plotData;
    }
}

