/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import org.zkoss.chart.Axis;
import org.zkoss.chart.AxisLabels;
import org.zkoss.chart.AxisTitle;
import org.zkoss.chart.OptionDataEvent;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.StackLabels;
import org.zkoss.chart.YAxisLabels;
import org.zkoss.chart.YAxisTitle;
import org.zkoss.chart.util.DeferredCall;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.JSFunction;
import org.zkoss.json.JSONObject;

public class YAxis
extends Axis {
    public StackLabels getStackLabels() {
        StackLabels stackLabels = (StackLabels)this.getAttr(Attrs.stackLabels);
        if (stackLabels == null) {
            stackLabels = new StackLabels();
            this.setStackLabels(stackLabels);
        }
        return stackLabels;
    }

    public void setStackLabels(StackLabels stackLabels) {
        this.setAttr(Attrs.stackLabels, stackLabels);
    }

    public boolean isEndOnTick() {
        return this.getAttr(Attrs.endOnTick, true).asBoolean();
    }

    public void setEndOnTick(boolean endOnTick) {
        this.setAttr(Attrs.endOnTick, endOnTick);
    }

    public boolean isShowLastLabel() {
        return this.getAttr(Attrs.showLastLabel, true).asBoolean();
    }

    public boolean isStartOnTick() {
        return this.getAttr(Attrs.startOnTick, false).asBoolean();
    }

    public Number getTickWidth() {
        return this.getAttr(Attrs.tickWidth, 0).asNumber();
    }

    public void setTickWidth(Number tickWidth) {
        this.setAttr((PlotAttribute)Attrs.tickWidth, tickWidth, Integer.valueOf(0));
    }

    public Number getMaxPadding() {
        return this.getAttr(Attrs.maxPadding, 0.05).asNumber();
    }

    public void setMaxPadding(Number maxPadding) {
        this.setAttr((PlotAttribute)Attrs.maxPadding, maxPadding, Double.valueOf(0.05));
    }

    public Number getMinPadding() {
        return this.getAttr(Attrs.minPadding, 0.05).asNumber();
    }

    public void setMinPadding(Number minPadding) {
        this.setAttr((PlotAttribute)Attrs.minPadding, minPadding, Double.valueOf(0.05));
    }

    public Number getGridLineWidth() {
        return this.getAttr(Attrs.gridLineWidth, 1).asNumber();
    }

    public void setGridLineWidth(Number gridLineWidth) {
        this.setAttr((PlotAttribute)Attrs.gridLineWidth, gridLineWidth, Integer.valueOf(1));
    }

    public Number getTickPixelInterval() {
        return this.getAttr(Attrs.tickPixelInterval, 72).asNumber();
    }

    public void setTickPixelInterval(Number tickPixelInterval) {
        this.setAttr((PlotAttribute)Attrs.tickPixelInterval, tickPixelInterval, Integer.valueOf(72));
    }

    public AxisLabels getLabels() {
        AxisLabels labels = (AxisLabels)this.getAttr(Attrs.labels);
        if (labels == null) {
            labels = new YAxisLabels();
            this.setLabels(labels);
        }
        return labels;
    }

    public Number getLineWidth() {
        return this.getAttr(Attrs.lineWidth, 0).asNumber();
    }

    public void setLineWidth(Number lineWidth) {
        this.setAttr((PlotAttribute)Attrs.lineWidth, lineWidth, Integer.valueOf(0));
    }

    public AxisTitle getTitle() {
        AxisTitle title = (AxisTitle)this.getAttr(Attrs.title);
        if (title == null) {
            title = new YAxisTitle();
            this.setAttr(Attrs.title, title);
        }
        return title;
    }

    public void onChange(OptionDataEvent event) {
        final Optionable target = event.getTarget();
        if (target instanceof StackLabels) {
            event.addJSFunctionCall(new DeferredCall(){

                public void execute(JSFunction func) {
                    JSONObject json = new JSONObject();
                    json.put((Object)"stackLabels", (Object)target);
                    func.callFunction("update", json);
                }
            });
            event.setCurrentTarget(this);
            this.fireEvent(event);
        } else {
            super.onChange(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        stackLabels,
        endOnTick,
        title,
        gridLineWidth,
        tickPixelInterval,
        showLastLabel,
        labels,
        lineWidth,
        maxPadding,
        minPadding,
        startOnTick,
        tickWidth;

    }
}

