/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.chart.Color;
import org.zkoss.chart.DateTimeLabelFormats;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tooltip
extends Optionable {
    public boolean isAnimation() {
        return this.getAttr(Attrs.animation, true).asBoolean();
    }

    public void setAnimation(boolean animation) {
        this.setAttr(Attrs.animation, animation);
    }

    public Color getBackgroundColor() {
        if (!this.containsKey(Attrs.backgroundColor)) {
            this.setBackgroundColor("rgba(255, 255, 255, 0.85)");
        }
        return (Color)this.getAttr(Attrs.backgroundColor);
    }

    public void setBackgroundColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.backgroundColor, color, NOT_NULL_VALUE);
    }

    public void setBackgroundColor(String color) {
        this.setBackgroundColor(new Color(color));
    }

    public void setBackgroundColor(LinearGradient color) {
        this.setBackgroundColor(new Color(color));
    }

    public void setBackgroundColor(RadialGradient color) {
        this.setBackgroundColor(new Color(color));
    }

    public Color getBorderColor() {
        if (!this.containsKey(Attrs.borderColor)) {
            this.setBorderColor("auto");
        }
        return (Color)this.getAttr(Attrs.borderColor);
    }

    public void setBorderColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.borderColor, color, NOT_NULL_VALUE);
    }

    public void setBorderColor(String color) {
        this.setBorderColor(new Color(color));
    }

    public void setBorderColor(LinearGradient color) {
        this.setBorderColor(new Color(color));
    }

    public void setBorderColor(RadialGradient color) {
        this.setBorderColor(new Color(color));
    }

    public Number getBorderRadius() {
        return this.getAttr(Attrs.borderRadius, 3).asNumber();
    }

    public void setBorderRadius(Number borderRadius) {
        this.setAttr((PlotAttribute)Attrs.borderRadius, borderRadius, Integer.valueOf(3));
    }

    public Number getBorderWidth() {
        return this.getAttr(Attrs.borderWidth, 1).asNumber();
    }

    public void setBorderWidth(Number borderWidth) {
        this.setAttr((PlotAttribute)Attrs.borderWidth, borderWidth, Integer.valueOf(1));
    }

    public Object getCrosshairs() {
        return this.getAttr(Attrs.crosshairs, null).asValue();
    }

    public void setCrosshairs(Boolean crosshairs) {
        this.setAttr(Attrs.crosshairs, crosshairs);
    }

    public <T> void setCrosshairs(List<T> crosshairs) {
        this.setAttr(Attrs.crosshairs, crosshairs);
    }

    public DateTimeLabelFormats getDateTimeLabelFormats() {
        DateTimeLabelFormats dateTimeLabelFormats = (DateTimeLabelFormats)this.getAttr(Attrs.dateTimeLabelFormats);
        if (dateTimeLabelFormats == null) {
            dateTimeLabelFormats = new DateTimeLabelFormats();
            this.setDateTimeLabelFormats(dateTimeLabelFormats);
        }
        return dateTimeLabelFormats;
    }

    public void setDateTimeLabelFormats(DateTimeLabelFormats dateTimeLabelFormats) {
        this.setAttr(Attrs.dateTimeLabelFormats, dateTimeLabelFormats);
    }

    public boolean isEnabled() {
        return this.getAttr(Attrs.enabled, true).asBoolean();
    }

    public void setEnabled(boolean enabled) {
        this.setAttr(Attrs.enabled, enabled);
    }

    public boolean isFollowPointer() {
        return this.getAttr(Attrs.followPointer, false).asBoolean();
    }

    public void setFollowPointer(boolean followPointer) {
        this.setAttr(Attrs.followPointer, followPointer);
    }

    public boolean isFollowTouchMove() {
        return this.getAttr(Attrs.followTouchMove, false).asBoolean();
    }

    public void setFollowTouchMove(boolean followTouchMove) {
        this.setAttr(Attrs.followTouchMove, followTouchMove);
    }

    public String getFooterFormat() {
        return this.getAttr(Attrs.footerFormat, false).asString();
    }

    public void setFooterFormat(String footerFormat) {
        this.setAttr(Attrs.footerFormat, footerFormat);
    }

    public String getFormat() {
        return this.getAttr(Attrs.format, null).asString();
    }

    public void setFormat(String format) {
        this.setAttr(Attrs.format, format);
    }

    public String getHeaderFormat() {
        return this.getAttr(Attrs.headerFormat, "<span style=\"font-size: 10px\">{point.key}</span><br/>").asString();
    }

    public void setHeaderFormat(String headerFormat) {
        this.setAttr((PlotAttribute)Attrs.headerFormat, headerFormat, "<span style=\"font-size: 10px\">{point.key}</span><br/>");
    }

    public Number getHideDelay() {
        return this.getAttr(Attrs.hideDelay, 500).asNumber();
    }

    public void setHideDelay(Number hideDelay) {
        this.setAttr((PlotAttribute)Attrs.hideDelay, hideDelay, Integer.valueOf(500));
    }

    public String getPointFormat() {
        return this.getAttr(Attrs.pointFormat, "<span style=\"color:{series.color}\">{series.name}</span>: <b>{point.y}</b><br/>").asString();
    }

    public void setPointFormat(String pointFormat) {
        this.setAttr((PlotAttribute)Attrs.pointFormat, pointFormat, "<span style=\"color:{series.color}\">{series.name}</span>: <b>{point.y}</b><br/>");
    }

    public boolean isShadow() {
        return this.getAttr(Attrs.shadow, true).asBoolean();
    }

    public void setShadow(boolean shadow) {
        this.setAttr(Attrs.shadow, shadow);
    }

    public boolean isShared() {
        return this.getAttr(Attrs.shared, false).asBoolean();
    }

    public void setShared(boolean shared) {
        this.setAttr(Attrs.shared, shared);
    }

    public Number getSnap() {
        return this.getAttr(Attrs.snap, null).asNumber();
    }

    public void setSnap(Number snap) {
        this.setAttr(Attrs.snap, snap);
    }

    public <K, V> Map<K, V> getStyle() {
        if (!this.containsKey(Attrs.style)) {
            this.setStyle("color: #333333; fontSize: 12px; padding: 8px;");
        }
        return (Map)Generics.cast((Object)this.getAttr(Attrs.style));
    }

    public void setStyle(String style) {
        this.setStyle(MapsHelper.parse(new LinkedHashMap(), style, ':', ';', '\''));
    }

    public <K, V> void setStyle(Map<K, V> style) {
        this.setAttr((PlotAttribute)Attrs.style, style, NOT_NULL_VALUE);
    }

    public boolean isUseHTML() {
        return this.getAttr(Attrs.useHTML, false).asBoolean();
    }

    public void setUseHTML(boolean useHTML) {
        this.setAttr(Attrs.useHTML, useHTML);
    }

    public Number getValueDecimals() {
        return this.getAttr(Attrs.valueDecimals, null).asNumber();
    }

    public void setValueDecimals(Number valueDecimals) {
        this.setAttr(Attrs.valueDecimals, valueDecimals);
    }

    public String getValuePrefix() {
        return this.getAttr(Attrs.valuePrefix, null).asString();
    }

    public void setValuePrefix(String valuePrefix) {
        this.setAttr(Attrs.valuePrefix, valuePrefix);
    }

    public String getValueSuffix() {
        return this.getAttr(Attrs.valueSuffix, null).asString();
    }

    public void setValueSuffix(String valueSuffix) {
        this.setAttr(Attrs.valueSuffix, valueSuffix);
    }

    public String getXDateFormat() {
        return this.getAttr(Attrs.xDateFormat, null).asString();
    }

    public void setXDateFormat(String xDateFormat) {
        this.setAttr(Attrs.xDateFormat, xDateFormat);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        animation,
        backgroundColor,
        borderColor,
        borderRadius,
        borderWidth,
        crosshairs,
        dateTimeLabelFormats,
        enabled,
        followPointer,
        followTouchMove,
        footerFormat,
        format,
        headerFormat,
        hideDelay,
        pointFormat,
        positioner,
        shadow,
        shared,
        snap,
        style,
        useHTML,
        valueDecimals,
        valuePrefix,
        valueSuffix,
        xDateFormat;

    }
}

