/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Title
extends Optionable {
    public String getAlign() {
        return this.getAttr(Attrs.align, "center").asString();
    }

    public void setAlign(String align) {
        if (!("left".equals(align) || "center".equals(align) || "right".equals(align))) {
            throw new IllegalArgumentException("Unsupported align: [" + align + "]");
        }
        this.setAttr((PlotAttribute)Attrs.align, align, "center");
    }

    public boolean isFloating() {
        return this.getAttr(Attrs.floating, false).asBoolean();
    }

    public void setFloating(boolean floating) {
        this.setAttr(Attrs.floating, floating);
    }

    public Number getMargin() {
        return this.getAttr(Attrs.margin, 15).asNumber();
    }

    public void setMargin(Number margin) {
        this.setAttr((PlotAttribute)Attrs.margin, margin, Integer.valueOf(15));
    }

    public <K, V> Map<K, V> getStyle() {
        if (!this.containsKey(Attrs.style)) {
            this.setStyle("color: #3E576F; fontSize: 16px;");
        }
        return (Map)Generics.cast((Object)this.getAttr(Attrs.style));
    }

    public void setStyle(String style) {
        this.setStyle(MapsHelper.parse(new LinkedHashMap(), style, ':', ';', '\''));
    }

    public <K, V> void setStyle(Map<K, V> style) {
        this.setAttr((PlotAttribute)Attrs.style, style, NOT_NULL_VALUE);
    }

    public String getText() {
        return this.getAttr(Attrs.text, "Chart title").asString();
    }

    public void setText(String text) {
        this.setAttr((PlotAttribute)Attrs.text, text, "Chart title");
    }

    public boolean isUseHTML() {
        return this.getAttr(Attrs.useHTML, false).asBoolean();
    }

    public void setUseHTML(boolean useHTML) {
        this.setAttr(Attrs.useHTML, useHTML);
    }

    public String getVerticalAlign() {
        return this.getAttr(Attrs.verticalAlign, "top").asString();
    }

    public void setVerticalAlign(String verticalAlign) {
        if (!("top".equals(verticalAlign) || "middle".equals(verticalAlign) || "bottom".equals(verticalAlign))) {
            throw new IllegalArgumentException("Unsupported vertical align: [" + verticalAlign + "]");
        }
        this.setAttr((PlotAttribute)Attrs.verticalAlign, verticalAlign, "top");
    }

    public Number getX() {
        return this.getAttr(Attrs.x, 0).asNumber();
    }

    public void setX(Number x) {
        this.setAttr((PlotAttribute)Attrs.x, x, Integer.valueOf(0));
    }

    public Number getY() {
        return this.getAttr(Attrs.y, 15).asNumber();
    }

    public void setY(Number y) {
        this.setAttr((PlotAttribute)Attrs.y, y, Integer.valueOf(15));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        align,
        floating,
        margin,
        style,
        text,
        useHTML,
        verticalAlign,
        x,
        y;

    }
}

