/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subtitle
extends Optionable {
    public String getAlign() {
        return this.getAttr(Attrs.align, "center").asString();
    }

    public void setAlign(String align) {
        if (!("left".equals(align) || "center".equals(align) || "right".equals(align))) {
            throw new IllegalArgumentException("Unsupported align: [" + align + "]");
        }
        this.setAttr((PlotAttribute)Attrs.align, align, "center");
    }

    public boolean isFloating() {
        return this.getAttr(Attrs.floating, false).asBoolean();
    }

    public void setFloating(boolean floating) {
        this.setAttr(Attrs.floating, floating);
    }

    public <K, V> Map<K, V> getStyle() {
        if (!this.containsKey(Attrs.style)) {
            this.setStyle("color: #3E576F;");
        }
        return (Map)Generics.cast((Object)this.getAttr(Attrs.style, null).asValue());
    }

    public void setStyle(String style) {
        this.setStyle(MapsHelper.parse(new LinkedHashMap(), style, ':', ';', '\''));
    }

    public <K, V> void setStyle(Map<K, V> style) {
        this.setAttr((PlotAttribute)Attrs.style, style, NOT_NULL_VALUE);
    }

    public String getText() {
        return this.getAttr(Attrs.text, null).asString();
    }

    public void setText(String text) {
        this.setAttr(Attrs.text, text);
    }

    public boolean isUseHTML() {
        return this.getAttr(Attrs.useHTML, false).asBoolean();
    }

    public void setUseHTML(boolean useHTML) {
        this.setAttr(Attrs.useHTML, useHTML);
    }

    public String getVerticalAlign() {
        return this.getAttr(Attrs.verticalAlign, "top").asString();
    }

    public void setVerticalAlign(String verticalAlign) {
        if (!("top".equals(verticalAlign) || "middle".equals(verticalAlign) || "bottom".equals(verticalAlign))) {
            throw new IllegalArgumentException("Unsupported vertical align: [" + verticalAlign + "]");
        }
        this.setAttr((PlotAttribute)Attrs.verticalAlign, verticalAlign, "top");
    }

    public Number getX() {
        return this.getAttr(Attrs.x, 0).asNumber();
    }

    public void setX(Number x) {
        this.setAttr((PlotAttribute)Attrs.x, x, Integer.valueOf(0));
    }

    public Number getY() {
        return this.getAttr(Attrs.y, null).asNumber();
    }

    public void setY(Number y) {
        this.setAttr(Attrs.y, y);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        align,
        floating,
        style,
        text,
        useHTML,
        verticalAlign,
        x,
        y;

    }
}

