/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Marker;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.util.DynamicalAttribute;

public class State
extends Optionable {
    private String _name;

    public State(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public boolean isEnabled() {
        return this.getAttr(Attrs.enabled, true).asBoolean();
    }

    public void setEnabled(boolean enabled) {
        this.setAttr(Attrs.enabled, enabled);
    }

    public Color getFillColor() {
        return (Color)this.getAttr(Attrs.fillColor, null).asValue();
    }

    public void setFillColor(Color color) {
        this.setAttr(Attrs.fillColor, color);
    }

    public void setFillColor(String color) {
        this.setFillColor(new Color(color));
    }

    public void setFillColor(LinearGradient color) {
        this.setFillColor(new Color(color));
    }

    public void setFillColor(RadialGradient color) {
        this.setFillColor(new Color(color));
    }

    public Color getLineColor() {
        if (!this.containsKey(Attrs.lineColor)) {
            this.setLineColor("#000000");
        }
        return (Color)this.getAttr(Attrs.lineColor);
    }

    public void setLineColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.lineColor, color, NOT_NULL_VALUE);
    }

    public void setLineColor(String color) {
        this.setLineColor(new Color(color));
    }

    public void setLineColor(LinearGradient color) {
        this.setLineColor(new Color(color));
    }

    public void setLineColor(RadialGradient color) {
        this.setLineColor(new Color(color));
    }

    public Number getLineWidth() {
        return this.getAttr(Attrs.lineWidth, 0).asNumber();
    }

    public void setLineWidth(Number lineWidth) {
        this.setAttr((PlotAttribute)Attrs.lineWidth, lineWidth, NOT_NULL_VALUE);
    }

    public Number getRadius() {
        return this.getAttr(Attrs.radius, null).asNumber();
    }

    public void setRadius(Number radius) {
        this.setAttr(Attrs.radius, radius);
    }

    public void setBrightness(Number brightness) {
        this.setAttr((PlotAttribute)Attrs.brightness, brightness, NOT_NULL_VALUE);
    }

    public Number getBrightness(Number brightness) {
        return this.getAttr(Attrs.brightness, null).asNumber();
    }

    public Marker getMarker() {
        Marker marker = (Marker)this.getAttr(Attrs.marker);
        if (marker == null) {
            marker = new Marker();
            this.setMarker(marker);
        }
        return marker;
    }

    public void setMarker(Marker marker) {
        this.setAttr(Attrs.marker, marker);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        enabled,
        fillColor,
        lineColor,
        lineWidth,
        radius,
        marker,
        brightness;

    }
}

