/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.Map;
import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.json.JSONObject;

public class Shadow
extends Optionable {
    public static Shadow NONE = new EmptyShadow();

    public Color getColor() {
        if (!this.containsKey(Attrs.color)) {
            this.setColor("black");
        }
        return (Color)this.getAttr(Attrs.color);
    }

    public void setColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.color, color, NOT_NULL_VALUE);
    }

    public void setColor(String color) {
        this.setColor(new Color(color));
    }

    public void setColor(LinearGradient color) {
        this.setColor(new Color(color));
    }

    public void setColor(RadialGradient color) {
        this.setColor(new Color(color));
    }

    public void setOffsetX(int offsetX) {
        this.setAttr((PlotAttribute)Attrs.offsetX, offsetX, Integer.valueOf(1));
    }

    public Number getOffsetX() {
        return this.getAttr(Attrs.offsetX, 1).asNumber();
    }

    public void setOffsetY(Number offsetY) {
        this.setAttr((PlotAttribute)Attrs.offsetY, offsetY, Integer.valueOf(1));
    }

    public Number getOffsetY() {
        return this.getAttr(Attrs.offsetY, 1).asNumber();
    }

    public void setOpacity(Number opacity) {
        this.setAttr((PlotAttribute)Attrs.opacity, opacity, NOT_NULL_VALUE);
    }

    public Number getOpacity() {
        return this.getAttr(Attrs.opacity, 0.15 / (double)((Integer)this.getWidth()).intValue()).asNumber();
    }

    public void setWidth(Number width) {
        this.setAttr((PlotAttribute)Attrs.width, width, Integer.valueOf(3));
    }

    public Number getWidth() {
        return this.getAttr(Attrs.width, 3).asNumber();
    }

    public String toJSONString() {
        if (this.options.isEmpty()) {
            return "true";
        }
        return JSONObject.toJSONString((Map)this.options);
    }

    private static class EmptyShadow
    extends Shadow {
        private EmptyShadow() {
        }

        public String toJSONString() {
            return "false";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute
    {
        color,
        offsetX,
        offsetY,
        opacity,
        width;

    }
}

