/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.chart.Animation;
import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Marker;
import org.zkoss.chart.OptionDataEvent;
import org.zkoss.chart.OptionDataListener;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.Point;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.plotOptions.DataLabels;
import org.zkoss.chart.plotOptions.SeriesPlotOptions;
import org.zkoss.chart.util.DeferredCall;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.JSFunction;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Generics;
import org.zkoss.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Series
extends Optionable
implements OptionDataListener {
    private SeriesPlotOptions plotOptions;

    public Series() {
    }

    public Series(String id, List<Point> data) {
        this.setId(id);
        this.setData(data.toArray(new Point[0]));
    }

    public Series(String id, Point ... data) {
        this.setId(id);
        this.setData(data);
    }

    public String getId() {
        return this.getAttr(DAttrs.id, null).asString();
    }

    public void setId(String id) {
        this.setAttr(DAttrs.id, id);
    }

    public void setPlotOptions(SeriesPlotOptions plotOptions) {
        SeriesPlotOptions old = this.plotOptions;
        if (!Objects.equals((Object)old, (Object)plotOptions)) {
            if (old != null) {
                old.removeOptionDataListener(this);
            }
            if (plotOptions != null) {
                plotOptions.addOptionDataListener(this);
                this.plotOptions = plotOptions;
            }
        }
    }

    public SeriesPlotOptions getPlotOptions() {
        if (this.plotOptions == null) {
            this.plotOptions = new SeriesPlotOptions();
            this.setPlotOptions(this.plotOptions);
        }
        return this.plotOptions;
    }

    public void addPoint(Point point) {
        this.addPoint(point, true, false, true);
    }

    public void addPoint(Point point, boolean redraw, boolean shift, boolean animation) {
        this.addPoint(point, redraw, shift, animation ? new Animation() : Animation.NONE);
    }

    public void addPoint(final Point point, final boolean redraw, final boolean shift, final Animation animation) {
        List<Point> list = this.getData();
        if (list == null) {
            list = new LinkedList<Point>();
        }
        list.add(point);
        point.addOptionDataListener(this);
        point.setSeries(this);
        this.setAttr(Attrs.data, list);
        this.fireEvent(OptionDataEvent.EventType.ADDED, Attrs.point.toString(), (Object)point, new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("addPoint", point, redraw, shift, animation);
            }
        });
    }

    public void addPoint(Number y) {
        if (y == null) {
            this.addPoint(new Point());
        } else {
            this.addPoint(new Point(y));
        }
    }

    public void addPoint(double y) {
        this.addPoint(new Point(y));
    }

    public void addPoint(Number x, Number y) {
        this.addPoint(new Point(x, y));
    }

    public void addPoint(double x, double y) {
        this.addPoint(new Point(x, (Number)y));
    }

    public void addPoint(Number x, Number low, Number high) {
        this.addPoint(new Point(x, low, high));
    }

    public void addPoint(double x, double low, double high) {
        this.addPoint(new Point(x, (Number)low, (Number)high));
    }

    public void addPoint(String name, Number y) {
        this.addPoint(new Point(name, y));
    }

    public void addPoint(String name, Number y, Number x) {
        this.addPoint(new Point(name, y, x));
    }

    public void addPoint(String name, double y) {
        this.addPoint(new Point(name, (Number)y));
    }

    public <T extends Number> void setData(List<T> data) {
        Point[] points = new Point[data.size()];
        int i = 0;
        for (Number t : data) {
            if (t == null) {
                points[i++] = new Point();
                continue;
            }
            points[i++] = new Point(t);
        }
        this.setData(points);
    }

    public void setData(Point ... data) {
        for (Point p : data) {
            p.addOptionDataListener(this);
            p.setSeries(this);
        }
        final ArrayList<Point> list = new ArrayList<Point>(Arrays.asList(data));
        this.setAttr(Attrs.data, list);
        this.fireEvent(OptionDataEvent.EventType.CHANGED, Attrs.data.toString(), (Object)data, new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("setData", list);
            }
        });
    }

    public void setData(Number ... data) {
        this.setData(Arrays.asList(data));
    }

    public void setData(Double ... data) {
        this.setData(Arrays.asList(data));
    }

    public void setData(Integer ... data) {
        this.setData(Arrays.asList(data));
    }

    public List<Point> getData() {
        return (List)Generics.cast((Object)this.getAttr(Attrs.data, null).asValue());
    }

    public Point getPoint(int index) {
        return this.getData().get(index);
    }

    public void setIndex(int index) {
        if (index < 0) {
            this.removeKey(DAttrs.index, true);
        } else {
            this.setAttr(DAttrs.index, index);
        }
    }

    public int getIndex() {
        return this.getAttr(DAttrs.index, -1).asInt();
    }

    public void setDataLabels(DataLabels dataLabels) {
        this.getPlotOptions().setDataLabels(dataLabels);
    }

    public DataLabels getDataLabels() {
        return this.getPlotOptions().getDataLabels();
    }

    public Color getColor() {
        return (Color)this.getAttr(DAttrs.color, null).asValue();
    }

    public void setColor(Color color) {
        this.setAttr(DAttrs.color, color);
    }

    public void setColor(String color) {
        this.setColor(new Color(color));
    }

    public void setColor(LinearGradient color) {
        this.setColor(new Color(color));
    }

    public void setColor(RadialGradient color) {
        this.setColor(new Color(color));
    }

    public void setLegendIndex(int legendIndex) {
        this.setAttr(DAttrs.legendIndex, legendIndex);
    }

    public int getLegendIndex() {
        return this.getAttr(DAttrs.legendIndex, -1).asInt();
    }

    public Marker getMarker() {
        Marker marker = (Marker)this.getAttr(DAttrs.marker);
        if (marker == null) {
            marker = new Marker();
            this.setAttr(DAttrs.marker, marker);
        }
        return marker;
    }

    public void setMarker(Marker marker) {
        this.setAttr(DAttrs.marker, marker);
    }

    public void setName(String name) {
        this.setAttr(DAttrs.name, name);
    }

    public String getName() {
        return this.getAttr(DAttrs.name, null).asString();
    }

    public void setStack(String stack) {
        this.setAttr(DAttrs.stack, stack);
    }

    public String getStack() {
        return this.getAttr(DAttrs.stack, null).asString();
    }

    public void setType(String type) {
        this.setAttr(DAttrs.type, type);
    }

    public String getType() {
        return this.getAttr(DAttrs.type, null).asString();
    }

    public void setXAxis(int xAxis) {
        this.setAttr(DAttrs.xAxis, xAxis);
    }

    public void setXAxis(String xAxis) {
        this.setAttr(DAttrs.xAxis, xAxis);
    }

    public Object getXAxis() {
        return this.getAttr(DAttrs.xAxis, 0).asValue();
    }

    public void setYAxis(int yAxis) {
        this.setAttr(DAttrs.yAxis, yAxis);
    }

    public void setYAxis(String yAxis) {
        this.setAttr(DAttrs.yAxis, yAxis);
    }

    public Object getYAxis() {
        return this.getAttr(DAttrs.yAxis, 0).asValue();
    }

    public void setZIndex(int zIndex) {
        this.setAttr(DAttrs.zIndex, zIndex);
    }

    public int getZIndex() {
        return this.getAttr(DAttrs.zIndex, -1).asInt();
    }

    public void hide() {
        this.setAttr(Attrs.visible, false);
        this.fireEvent(OptionDataEvent.EventType.CHANGED, "hide", (Object)this, new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("hide");
            }
        });
    }

    public boolean isVisible() {
        return this.getAttr(Attrs.visible, true).asBoolean();
    }

    public void setVisible(final boolean visible) {
        if (this.setAttr((PlotAttribute)Attrs.visible, visible, Boolean.valueOf(true))) {
            this.fireEvent(OptionDataEvent.EventType.CHANGED, "visible", (Object)this, new DeferredCall(){

                public void execute(JSFunction func) {
                    func.callFunction("setVisible", visible);
                }
            });
        }
    }

    public void show() {
        this.setAttr(Attrs.visible, true);
        this.fireEvent(OptionDataEvent.EventType.CHANGED, "show", (Object)this, new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("show");
            }
        });
    }

    public void remove() {
        this.fireEvent(OptionDataEvent.EventType.DESTROYED, "series", (Object)this, new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("remove");
            }
        });
        this.clearOptonDataListener();
    }

    public void select() {
        this.fireEvent(OptionDataEvent.EventType.CHANGED, "select", (Object)this, new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("select");
            }
        });
    }

    @Override
    public void onChange(OptionDataEvent event) {
        final Optionable target = event.getTarget();
        event.setCurrentTarget(this);
        if (target instanceof Point) {
            List<Point> list;
            final int index = this.getData().indexOf(target);
            if (event.hasJSFunctionCall()) {
                event.addJSFunctionCall(new DeferredCall(){

                    public void execute(JSFunction func) {
                        func.callArray("data", index);
                    }
                });
            }
            if (event.getType() == OptionDataEvent.EventType.DESTROYED && (list = this.getData()) != null) {
                list.remove(index);
            }
        } else {
            event.addJSFunctionCall(new DeferredCall(){

                public void execute(JSFunction func) {
                    if (target instanceof DataLabels) {
                        JSONObject json = new JSONObject();
                        json.put((Object)"dataLabels", (Object)target);
                        func.callFunction("update", json);
                    } else {
                        func.callFunction("update", target);
                    }
                }
            });
        }
        this.fireEvent(event);
    }

    @Override
    public String toJSONString() {
        if (this.plotOptions != null) {
            LinkedHashMap clone = new LinkedHashMap(this.options);
            clone.putAll(this.plotOptions.options);
            return JSONObject.toJSONString(clone);
        }
        return super.toJSONString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute
    {
        data,
        visible,
        point;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DAttrs implements PlotAttribute,
    DynamicalAttribute
    {
        color,
        dataLabels,
        index,
        legendIndex,
        marker,
        name,
        stack,
        type,
        xAxis,
        yAxis,
        zIndex,
        id;

    }
}

