/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.Map;
import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Marker;
import org.zkoss.chart.OptionDataEvent;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.Series;
import org.zkoss.chart.plotOptions.DataLabels;
import org.zkoss.chart.plotOptions.GaugeDialPlotOptions;
import org.zkoss.chart.util.DeferredCall;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.JSFunction;
import org.zkoss.chart.util.OptionsList;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JavaScriptValue;

public class Point
extends Optionable {
    private boolean _valuesOnly = true;
    private Series _series;

    public Point() {
    }

    void setSeries(Series s) {
        this._series = s;
    }

    Series getSeries() {
        return this._series;
    }

    public Point(Number y) {
        this.setY(y);
    }

    public Point(Number x, Number y) {
        this.setX(x);
        this.setY(y);
    }

    public Point(String name, Number y) {
        this.setName(name);
        this.setY(y);
    }

    public Point(String name, Number y, Number x) {
        this.setName(name);
        this.setY(y);
        this.setX(x);
    }

    public Point(String name, Number y, String drilldown) {
        this.setName(name);
        this.setY(y);
        this.setDrilldown(drilldown);
    }

    public Point(Number x, Number low, Number high) {
        this.setX(x);
        this.setLow(low);
        this.setHigh(high);
    }

    public DataLabels getDataLabels() {
        DataLabels dataLabels = (DataLabels)this.getAttr(DAttrs.dataLabels);
        if (dataLabels == null) {
            dataLabels = new DataLabels();
            this.setDataLabels(dataLabels);
        }
        return dataLabels;
    }

    public void setDataLabels(DataLabels dataLabels) {
        this._valuesOnly = false;
        this.setAttr(DAttrs.dataLabels, dataLabels);
    }

    public boolean isVisible() {
        return this.getAttr(DAttrs.visible, true).asBoolean();
    }

    public void setVisible(boolean visible) {
        this._valuesOnly = false;
        this.setAttr((PlotAttribute)DAttrs.visible, visible, Boolean.valueOf(true));
    }

    public void setLow(Number low) {
        this.setAttr((PlotAttribute)DAttrs.low, low, NOT_NULL_VALUE);
    }

    public Number getLow() {
        return this.getAttr(DAttrs.low, null).asNumber();
    }

    public void setHigh(Number high) {
        this.setAttr((PlotAttribute)DAttrs.high, high, NOT_NULL_VALUE);
    }

    public Number getHigh() {
        return this.getAttr(DAttrs.high, null).asNumber();
    }

    public GaugeDialPlotOptions getDial() {
        GaugeDialPlotOptions dial = (GaugeDialPlotOptions)this.getAttr(DAttrs.dial);
        if (dial == null) {
            dial = new GaugeDialPlotOptions();
            this.setDial(dial);
        }
        return dial;
    }

    public void setDial(GaugeDialPlotOptions dial) {
        this.setAttr(DAttrs.dial, dial);
    }

    public void setDrilldown(boolean enable) {
        this.setDrilldown(String.valueOf(enable));
    }

    public void setDrilldown(String seriesId) {
        this._valuesOnly = false;
        this.setAttr(DAttrs.drilldown, seriesId);
    }

    public String getDrilldown() {
        return this.getAttr(DAttrs.drilldown, null).asString();
    }

    public Color getColor() {
        return (Color)this.getAttr(DAttrs.color, null).asValue();
    }

    public void setColor(Color color) {
        this._valuesOnly = false;
        this.setAttr(DAttrs.color, color);
    }

    public void setColor(String color) {
        this.setColor(new Color(color));
    }

    public void setColor(LinearGradient color) {
        this.setColor(new Color(color));
    }

    public void setColor(RadialGradient color) {
        this.setColor(new Color(color));
    }

    public String getId() {
        return this.getAttr(DAttrs.id, null).asString();
    }

    public void setId(String id) {
        this._valuesOnly = false;
        this.setAttr(DAttrs.id, id);
    }

    public boolean isIntermediateSum() {
        return this.getAttr(DAttrs.isIntermediateSum, false).asBoolean();
    }

    public void setIntermediateSum(boolean sum) {
        this._valuesOnly = false;
        this.setAttr(DAttrs.isIntermediateSum, sum);
    }

    public boolean isSum() {
        return this.getAttr(DAttrs.isSum, false).asBoolean();
    }

    public void setSum(boolean sum) {
        this._valuesOnly = false;
        this.setAttr(DAttrs.isSum, sum);
    }

    public int getLegendIndex() {
        return this.getAttr(DAttrs.legendIndex, 0).asInt();
    }

    public void setLegendIndex(int legendIndex) {
        this._valuesOnly = false;
        this.setAttr(DAttrs.legendIndex, legendIndex);
    }

    public Marker getMarker() {
        Marker marker = (Marker)this.getAttr(DAttrs.marker);
        if (marker == null) {
            this._valuesOnly = false;
            marker = new Marker();
            this.setAttr(DAttrs.marker, marker);
        }
        return marker;
    }

    public void setMarker(Marker marker) {
        this._valuesOnly = false;
        this.setAttr(DAttrs.marker, marker);
    }

    public String getName() {
        return this.getAttr(DAttrs.name, null).asString();
    }

    public void setName(String name) {
        this._valuesOnly = false;
        this.setAttr(DAttrs.name, name);
    }

    public boolean isSelected() {
        this._valuesOnly = false;
        return this.getAttr(Attrs.selected, false).asBoolean();
    }

    public void setSelected(boolean selected) {
        this.select(selected, false);
    }

    public void setSelectedDirectly(boolean selected) {
        this._valuesOnly = false;
        this.setAttr(Attrs.selected, selected);
        this.setSlicedDirectly(selected);
    }

    public boolean isSliced() {
        this._valuesOnly = false;
        return this.getAttr(Attrs.sliced, false).asBoolean();
    }

    public void setSliced(boolean sliced) {
        this.slice(sliced);
    }

    public void setSlicedDirectly(boolean sliced) {
        this._valuesOnly = false;
        this.setAttr(Attrs.sliced, sliced);
    }

    public Number getX() {
        return (Number)this.getAttr(DAttrs.x, null).asValue();
    }

    public void setX(Number x) {
        this.setAttr((PlotAttribute)DAttrs.x, x, NOT_NULL_VALUE);
    }

    public Number getY() {
        return (Number)this.getAttr(DAttrs.y, null).asValue();
    }

    public void setY(Number y) {
        this.setAttr((PlotAttribute)DAttrs.y, y, NOT_NULL_VALUE);
    }

    public void remove() {
        this.fireEvent(OptionDataEvent.EventType.DESTROYED, "point", (Object)this, new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("remove");
            }
        });
        this.clearOptonDataListener();
        this._series = null;
    }

    public void select() {
        this.select(!this.isSelected(), false);
    }

    public void select(final boolean select, final boolean accumulate) {
        this.setSelectedDirectly(select);
        this.fireEvent(OptionDataEvent.EventType.SELECTED, "accumulate", (Object)accumulate, new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("select", select, accumulate, true);
            }
        });
    }

    public void slice() {
        this.slice(!this.isSliced());
    }

    public void slice(final boolean sliced) {
        this.fireEvent(OptionDataEvent.EventType.CHANGED, "slice", (Object)this, new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("slice", sliced);
            }
        });
        this.setSlicedDirectly(sliced);
    }

    public void update(final Number x, final Number low, final Number high) {
        this.setX(x);
        this.setLow(low);
        this.setHigh(high);
        OptionDataEvent evt = new OptionDataEvent(this, OptionDataEvent.EventType.CHANGED, DAttrs.x.toString(), x, DAttrs.low.toString(), low, DAttrs.high.toString(), high);
        evt.addJSFunctionCall(new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("update", new JavaScriptValue(JSONArray.toJSONString((Object[])new Number[]{x, low, high})));
            }
        });
        this.fireEvent(evt);
    }

    public void update(final Number x, final Number y) {
        this.setX(x);
        this.setY(y);
        OptionDataEvent evt = new OptionDataEvent(this, OptionDataEvent.EventType.CHANGED, DAttrs.x.toString(), x, DAttrs.y.toString(), y);
        evt.addJSFunctionCall(new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("update", new JavaScriptValue(JSONArray.toJSONString((Object[])new Number[]{x, y})));
            }
        });
        this.fireEvent(evt);
    }

    public void update(final Number value) {
        this.setY(value);
        this.fireEvent(OptionDataEvent.EventType.CHANGED, DAttrs.y, (Object)value, new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("update", value);
            }
        });
    }

    public String toJSONString() {
        if (this.options.isEmpty()) {
            return "null";
        }
        if (this.options.size() == 1 && this.getY() != null) {
            return this.getY().toString();
        }
        if (this._valuesOnly) {
            return OptionsList.toJSONString(this.options.values());
        }
        return JSONObject.toJSONString((Map)this.options);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DAttrs implements PlotAttribute,
    DynamicalAttribute
    {
        color,
        dataLabels,
        events,
        id,
        legendIndex,
        marker,
        name,
        selected,
        sliced,
        x,
        y,
        dial,
        drilldown,
        isIntermediateSum,
        isSum,
        visible,
        low,
        high;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute
    {
        selected,
        sliced;

    }
}

