/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.PlotLabel;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.util.DynamicalAttribute;

public class PlotLine
extends Optionable {
    public Color getColor() {
        return (Color)this.getAttr(Attrs.color, null).asValue();
    }

    public void setColor(Color color) {
        this.setAttr(Attrs.color, color);
    }

    public void setColor(String color) {
        this.setColor(new Color(color));
    }

    public void setColor(LinearGradient color) {
        this.setColor(new Color(color));
    }

    public void setColor(RadialGradient color) {
        this.setColor(new Color(color));
    }

    public String getDashStyle() {
        return this.getAttr(Attrs.dashStyle, "Solid").asString();
    }

    public void setDashStyle(String dashStyle) {
        if (!("Solid".equalsIgnoreCase(dashStyle) || "ShortDash".equalsIgnoreCase(dashStyle) || "ShortDot".equalsIgnoreCase(dashStyle) || "ShortDashDot".equalsIgnoreCase(dashStyle) || "ShortDashDotDot".equalsIgnoreCase(dashStyle) || "Dot".equalsIgnoreCase(dashStyle) || "Dash".equalsIgnoreCase(dashStyle) || "LongDash".equalsIgnoreCase(dashStyle) || "DashDot".equalsIgnoreCase(dashStyle) || "LongDashDot".equalsIgnoreCase(dashStyle) || "LongDashDotDot".equalsIgnoreCase(dashStyle))) {
            throw new IllegalArgumentException("Unsupported style: [" + dashStyle + "]");
        }
        this.setAttr((PlotAttribute)Attrs.dashStyle, dashStyle, "Solid");
    }

    public String getId() {
        return this.getAttr(Attrs.id, null).asString();
    }

    public void setId(String id) {
        this.setAttr(Attrs.id, id);
    }

    public PlotLabel getLabel() {
        PlotLabel label = (PlotLabel)this.getAttr(Attrs.label);
        if (label == null) {
            label = new PlotLabel();
            this.setLabel(label);
        }
        return label;
    }

    public void setLabel(PlotLabel label) {
        this.setAttr(Attrs.label, label);
    }

    public Number getValue() {
        return this.getAttr(Attrs.value, null).asNumber();
    }

    public void setValue(Number value) {
        this.setAttr(Attrs.value, value);
    }

    public Number getWidth() {
        return this.getAttr(Attrs.width, null).asNumber();
    }

    public void setWidth(Number width) {
        this.setAttr(Attrs.width, width);
    }

    public Number getZIndex() {
        return this.getAttr(Attrs.zIndex, null).asNumber();
    }

    public void setZIndex(Number zIndex) {
        this.setAttr(Attrs.zIndex, zIndex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        color,
        dashStyle,
        id,
        label,
        value,
        width,
        zIndex;

    }
}

