/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotLabel
extends Optionable {
    public String getAlign() {
        return this.getAttr(Attrs.align, "center").asString();
    }

    public void setAlign(String align) {
        if (!("left".equals(align) || "center".equals(align) || "right".equals(align))) {
            throw new IllegalArgumentException("Unsupported align: [" + align + "]");
        }
        this.setAttr((PlotAttribute)Attrs.align, align, "center");
    }

    public Number getRotation() {
        return this.getAttr(Attrs.rotation, 0).asNumber();
    }

    public void setRotation(Number rotation) {
        this.setAttr((PlotAttribute)Attrs.rotation, rotation, Integer.valueOf(0));
    }

    public <K, V> Map<K, V> getStyle() {
        return (Map)Generics.cast((Object)this.getAttr(Attrs.style, null).asValue());
    }

    public void setStyle(String style) {
        this.setStyle(MapsHelper.parse(new LinkedHashMap(), style, ':', ';', '\''));
    }

    public <K, V> void setStyle(Map<K, V> style) {
        this.setAttr(Attrs.style, style);
    }

    public String getText() {
        return this.getAttr(Attrs.text, null).asString();
    }

    public void setText(String text) {
        this.setAttr(Attrs.text, text);
    }

    public String getTextAlign() {
        if (this.containsKey(Attrs.textAlign)) {
            return (String)this.getAttr(Attrs.textAlign);
        }
        return this.getAlign();
    }

    public void setTextAlign(String textAlign) {
        if (!("left".equals(textAlign) || "center".equals(textAlign) || "right".equals(textAlign))) {
            throw new IllegalArgumentException("Unsupported textAlign: [" + textAlign + "]");
        }
        this.setAttr(Attrs.textAlign, textAlign);
    }

    public boolean isUseHTML() {
        return this.getAttr(Attrs.useHTML, false).asBoolean();
    }

    public void setUseHTML(boolean useHTML) {
        this.setAttr(Attrs.useHTML, useHTML);
    }

    public String getVerticalAlign() {
        return this.getAttr(Attrs.verticalAlign, "top").asString();
    }

    public void setVerticalAlign(String verticalAlign) {
        if (!("top".equals(verticalAlign) || "middle".equals(verticalAlign) || "bottom".equals(verticalAlign))) {
            throw new IllegalArgumentException("Unsupported verticalAlign: [" + verticalAlign + "]");
        }
        this.setAttr((PlotAttribute)Attrs.verticalAlign, verticalAlign, "top");
    }

    public Number getX() {
        return this.getAttr(Attrs.x, null).asNumber();
    }

    public void setX(Number x) {
        this.setAttr(Attrs.x, x);
    }

    public Number getY() {
        return this.getAttr(Attrs.y, null).asNumber();
    }

    public void setY(Number y) {
        this.setAttr(Attrs.y, y);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        align,
        rotation,
        style,
        text,
        textAlign,
        useHTML,
        verticalAlign,
        x,
        y;

    }
}

