/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.chart.Chart;
import org.zkoss.chart.Charts;
import org.zkoss.chart.Color;
import org.zkoss.chart.Credits;
import org.zkoss.chart.Drilldown;
import org.zkoss.chart.Exporting;
import org.zkoss.chart.Labels;
import org.zkoss.chart.Legend;
import org.zkoss.chart.Loading;
import org.zkoss.chart.Navigation;
import org.zkoss.chart.NoData;
import org.zkoss.chart.OptionDataEvent;
import org.zkoss.chart.OptionDataListener;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.Pane;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.Point;
import org.zkoss.chart.Series;
import org.zkoss.chart.Subtitle;
import org.zkoss.chart.Title;
import org.zkoss.chart.Tooltip;
import org.zkoss.chart.XAxis;
import org.zkoss.chart.YAxis;
import org.zkoss.chart.plotOptions.PlotOptions;
import org.zkoss.chart.util.DeferredCall;
import org.zkoss.chart.util.JSFunction;
import org.zkoss.chart.util.ResponseDataHandler;
import org.zkoss.json.JSONAware;
import org.zkoss.json.JSONObject;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotData
implements JSONAware,
OptionDataListener {
    private Map<PlotAttribute, Object> _json = new LinkedHashMap<PlotAttribute, Object>(3);
    private Charts charts;
    private boolean firstXAxis = true;
    private boolean firstYAxis = true;

    public PlotData(Charts owner) {
        this.charts = owner;
    }

    public Exporting getExporting() {
        Exporting exporting = (Exporting)this._json.get(Attrs.exporting);
        if (exporting == null) {
            exporting = new Exporting();
            this.setExporting(exporting);
        }
        return exporting;
    }

    public void setExporting(Exporting exporting) {
        Exporting old = (Exporting)this._json.put(Attrs.exporting, exporting);
        if (old != exporting) {
            this.addOptionDataListener(exporting);
            this.removeOptionDataListener(old);
        }
    }

    public List<Color> getColors() {
        if (!this._json.containsKey(Attrs.colors)) {
            this.setColors("#2f7ed8", "#0d233a", "#8bbc21", "#910000", "#1aadce", "#492970", "#f28f43", "#77a1e5", "#c42525", "#a6c96a");
        }
        return (List)this._json.get(Attrs.colors);
    }

    public void setColors(List<Color> colors) {
        this._json.put(Attrs.colors, colors);
    }

    public void setColors(String ... source) {
        Color[] colors = new Color[source.length];
        int i = 0;
        for (String s : source) {
            colors[i++] = new Color(s);
        }
        this.setColors(Arrays.asList(colors));
    }

    private void clearResponseData() {
        ResponseDataHandler handler = this.getResponseDataHandler(false);
        if (handler != null) {
            handler.clear();
        }
    }

    private ResponseDataHandler getResponseDataHandler(boolean create) {
        String key = this.getClass().getName() + "#" + this.charts.getUuid();
        ResponseDataHandler handler = (ResponseDataHandler)Executions.getCurrent().getAttribute(key);
        if (create && handler == null) {
            handler = new ResponseDataHandler();
            Executions.getCurrent().setAttribute(key, (Object)handler);
        }
        return handler;
    }

    private ResponseDataHandler addResponseData(OptionDataEvent evt) {
        ResponseDataHandler handler = this.getResponseDataHandler(true);
        handler.addQueue(evt);
        return handler;
    }

    @Override
    public void onChange(OptionDataEvent event) {
        String result;
        LinkedList list;
        final Optionable target = event.getTarget();
        if (OptionDataEvent.EventType.SELECTED == event.getType() && event.getOriginTarget() instanceof Point) {
            this.charts.selectPoint((Point)event.getOriginTarget(), (Boolean)event.getValue("accumulate"));
        }
        if (!this.charts.isRendered() || !this.charts.checkLock()) {
            this.clearResponseData();
            return;
        }
        if (target instanceof PlotOptions) {
            this.charts.invalidate();
            this.clearResponseData();
            return;
        }
        if (target instanceof Series) {
            if (OptionDataEvent.EventType.INITIALIZED == event.getType()) {
                event.addJSFunctionCall(new DeferredCall(){

                    public void execute(JSFunction func) {
                        func.callFunction("this.addSeries", target);
                    }
                });
            } else {
                list = (LinkedList)this._json.get(Attrs.series);
                final int sIndex = list.indexOf(target);
                final boolean hasJS = event.hasJSFunctionCall();
                event.addJSFunctionCall(new DeferredCall(){

                    public void execute(JSFunction func) {
                        if (!hasJS) {
                            func.callFunction("update", target);
                        }
                        func.callArray(Attrs.series.toString(), sIndex);
                    }
                }).setJSUpdateCall(!hasJS);
            }
            if (OptionDataEvent.EventType.DESTROYED == event.getType() && event.getOriginTarget() instanceof Series) {
                list = (LinkedList)this._json.get(Attrs.series);
                list.remove(target);
            }
        } else if (target instanceof YAxis) {
            if (OptionDataEvent.EventType.INITIALIZED == event.getType()) {
                result = target.toJSONString();
                event.addJSFunctionCall(new DeferredCall(){

                    public void execute(JSFunction func) {
                        func.evalJavascript("this.addAxis(" + result + ", false)");
                    }
                });
            } else {
                list = (LinkedList)this._json.get(Attrs.yAxis);
                final int yIndex = list.indexOf(target);
                final boolean hasJS = event.hasJSFunctionCall();
                event.addJSFunctionCall(new DeferredCall(){

                    public void execute(JSFunction func) {
                        if (!hasJS) {
                            func.callFunction("update", target);
                        }
                        func.callArray(Attrs.yAxis.toString(), yIndex);
                    }
                }).setJSUpdateCall(!hasJS);
            }
            if (OptionDataEvent.EventType.DESTROYED == event.getType() && event.getOriginTarget() instanceof YAxis) {
                list = (LinkedList)this._json.get(Attrs.yAxis);
                list.remove(target);
            }
        } else if (target instanceof XAxis) {
            if (OptionDataEvent.EventType.INITIALIZED == event.getType()) {
                result = target.toJSONString();
                event.addJSFunctionCall(new DeferredCall(){

                    public void execute(JSFunction func) {
                        func.evalJavascript("this.addAxis(" + result + ", true)");
                    }
                });
            } else {
                list = (LinkedList)this._json.get(Attrs.xAxis);
                final int xIndex = list.indexOf(target);
                final boolean hasJS = event.hasJSFunctionCall();
                event.addJSFunctionCall(new DeferredCall(){

                    public void execute(JSFunction func) {
                        if (!hasJS) {
                            func.callFunction("update", target);
                        }
                        func.callArray(Attrs.xAxis.toString(), xIndex);
                    }
                }).setJSUpdateCall(!hasJS);
            }
            if (OptionDataEvent.EventType.DESTROYED == event.getType() && event.getOriginTarget() instanceof XAxis) {
                list = (LinkedList)this._json.get(Attrs.xAxis);
                list.remove(target);
            }
        } else if (target instanceof Title) {
            event.addJSFunctionCall(new DeferredCall(){

                public void execute(JSFunction func) {
                    func.callFunction("setTitle", target);
                }
            });
        } else if (target instanceof Subtitle) {
            event.addJSFunctionCall(new DeferredCall(){

                public void execute(JSFunction func) {
                    func.callFunction("setTitle", null, target);
                }
            });
        } else if (target instanceof Chart) {
            if ("width".equals(event.getKey())) {
                final Integer width = (Integer)event.getValue(event.getKey());
                Integer height = (Integer)((Chart)target).getHeight();
                event.addJSFunctionCall(new DeferredCall(){

                    public void execute(JSFunction func) {
                        func.callFunction("setSize", width, null);
                    }
                });
            } else if ("height".equals(event.getKey())) {
                final Integer height = (Integer)event.getValue(event.getKey());
                Integer width = (Integer)((Chart)target).getWidth();
                event.addJSFunctionCall(new DeferredCall(){

                    public void execute(JSFunction func) {
                        func.callFunction("setSize", null, height);
                    }
                });
            }
        }
        switch (event.getType()) {
            case ECHO: {
                String attr = event.getKey();
                Object data = event.getValue(attr);
                if (!(data instanceof EventListener)) break;
                this.charts.setAttribute(event.hashCode() + "." + attr, data);
                Clients.response((AuResponse)new AuInvoke((Component)this.charts, "echo", new Object[]{event.hashCode() + "." + attr, event}));
                break;
            }
            default: {
                if (event.hasJSFunctionCall()) {
                    this.charts.smartUpdate("eval", this.addResponseData(event), false);
                    break;
                }
                this.charts.invalidate();
            }
        }
    }

    public Series getSeries() {
        return this.getSeries(0);
    }

    public int getSeriesSize() {
        LinkedList list = (LinkedList)this._json.get(Attrs.series);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public Series getSeries(int index) {
        int size;
        LinkedList<Series> list = (LinkedList<Series>)this._json.get(Attrs.series);
        if (list == null) {
            list = new LinkedList<Series>();
            this._json.put(Attrs.series, list);
        }
        if ((size = list.size()) <= index) {
            for (int i = index - size + 1; i > 0; --i) {
                Series series = (Series)new Series().addOptionDataListener(this);
                list.add(series);
                this.onChange(new OptionDataEvent(series, OptionDataEvent.EventType.INITIALIZED, Attrs.series.toString(), series));
            }
        }
        return (Series)list.get(index);
    }

    public void addSeries(Series series) {
        LinkedList<Series> list = (LinkedList<Series>)this._json.get(Attrs.series);
        if (list == null) {
            list = new LinkedList<Series>();
            this._json.put(Attrs.series, list);
        }
        series.addOptionDataListener(this);
        list.add(series);
        this.onChange(new OptionDataEvent(series, OptionDataEvent.EventType.INITIALIZED, Attrs.series.toString(), series));
    }

    public XAxis getXAxis() {
        return this.getXAxis(0);
    }

    public int getXAxisSize() {
        LinkedList list = (LinkedList)this._json.get(Attrs.xAxis);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public XAxis getXAxis(int index) {
        int size;
        LinkedList<XAxis> list = (LinkedList<XAxis>)this._json.get(Attrs.xAxis);
        if (list == null) {
            list = new LinkedList<XAxis>();
            this._json.put(Attrs.xAxis, list);
        }
        if ((size = list.size()) <= index) {
            for (int i = index - size + 1; i > 0; --i) {
                XAxis xAxis = (XAxis)new XAxis().addOptionDataListener(this);
                list.add(xAxis);
                if (this.firstXAxis) {
                    this.firstXAxis = false;
                    continue;
                }
                this.onChange(new OptionDataEvent(xAxis, OptionDataEvent.EventType.INITIALIZED, Attrs.series.toString(), xAxis));
            }
        }
        return (XAxis)list.get(index);
    }

    public void addXAxis(XAxis xAxis) {
        LinkedList<XAxis> list = (LinkedList<XAxis>)this._json.get(Attrs.xAxis);
        if (list == null) {
            list = new LinkedList<XAxis>();
            this._json.put(Attrs.xAxis, list);
        }
        xAxis.addOptionDataListener(this);
        list.add(xAxis);
        this.onChange(new OptionDataEvent(xAxis, OptionDataEvent.EventType.INITIALIZED, Attrs.xAxis.toString(), xAxis));
    }

    public YAxis getYAxis() {
        return this.getYAxis(0);
    }

    public int getYAxisSize() {
        LinkedList list = (LinkedList)this._json.get(Attrs.yAxis);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public YAxis getYAxis(int index) {
        int size;
        LinkedList<YAxis> list = (LinkedList<YAxis>)this._json.get(Attrs.yAxis);
        if (list == null) {
            list = new LinkedList<YAxis>();
            this._json.put(Attrs.yAxis, list);
        }
        if ((size = list.size()) <= index) {
            for (int i = index - size + 1; i > 0; --i) {
                YAxis yAxis = (YAxis)new YAxis().addOptionDataListener(this);
                list.add(yAxis);
                if (this.firstYAxis) {
                    this.firstYAxis = false;
                    continue;
                }
                this.onChange(new OptionDataEvent(yAxis, OptionDataEvent.EventType.INITIALIZED, Attrs.series.toString(), yAxis));
            }
        }
        return (YAxis)list.get(index);
    }

    public void addYAxis(YAxis yAxis) {
        LinkedList<YAxis> list = (LinkedList<YAxis>)this._json.get(Attrs.yAxis);
        if (list == null) {
            list = new LinkedList<YAxis>();
            this._json.put(Attrs.yAxis, list);
        }
        yAxis.addOptionDataListener(this);
        list.add(yAxis);
        this.onChange(new OptionDataEvent(yAxis, OptionDataEvent.EventType.INITIALIZED, Attrs.yAxis.toString(), yAxis));
    }

    public NoData getNoData() {
        NoData noData = (NoData)this._json.get(Attrs.noData);
        if (noData == null) {
            noData = new NoData();
            this.setNoData(noData);
        }
        return noData;
    }

    public void setNoData(NoData noData) {
        NoData old = (NoData)this._json.put(Attrs.noData, noData);
        if (old != noData) {
            this.addOptionDataListener(noData);
            this.removeOptionDataListener(old);
        }
    }

    public Chart getChart() {
        Chart chart = (Chart)this._json.get(Attrs.chart);
        if (chart == null) {
            chart = new Chart();
            this.setChart(chart);
        }
        return chart;
    }

    public void setChart(Chart chart) {
        Chart old = (Chart)this._json.put(Attrs.chart, chart);
        if (old != chart) {
            this.addOptionDataListener(chart);
            this.removeOptionDataListener(old);
        }
    }

    public Credits getCredits() {
        Credits credits = (Credits)this._json.get(Attrs.credits);
        if (credits == null) {
            credits = new Credits();
            this.setCredits(credits);
        }
        return credits;
    }

    public void setCredits(Credits credits) {
        Credits old = (Credits)this._json.put(Attrs.credits, credits);
        if (old != credits) {
            this.addOptionDataListener(credits);
            this.removeOptionDataListener(old);
        }
    }

    public Drilldown getDrilldown() {
        Drilldown drilldown = (Drilldown)this._json.get(Attrs.drilldown);
        if (drilldown == null) {
            drilldown = new Drilldown();
            this.setDrilldown(drilldown);
        }
        return drilldown;
    }

    public void setDrilldown(Drilldown drilldown) {
        Drilldown old = (Drilldown)this._json.put(Attrs.drilldown, drilldown);
        if (old != drilldown) {
            this.addOptionDataListener(drilldown);
            this.removeOptionDataListener(old);
        }
    }

    public Labels getLabels() {
        Labels labels = (Labels)this._json.get("labels");
        if (labels == null) {
            labels = new Labels();
            this.setLabels(labels);
        }
        return labels;
    }

    public void setLabels(Labels labels) {
        Labels old = (Labels)this._json.put(Attrs.labels, labels);
        if (old != labels) {
            this.addOptionDataListener(labels);
            this.removeOptionDataListener(old);
        }
    }

    public Legend getLegend() {
        Legend legend = (Legend)this._json.get(Attrs.legend);
        if (legend == null) {
            legend = new Legend();
            this.setLegend(legend);
        }
        return legend;
    }

    public void setLegend(Legend legend) {
        Legend old = (Legend)this._json.put(Attrs.legend, legend);
        if (old != legend) {
            this.addOptionDataListener(legend);
            this.removeOptionDataListener(old);
        }
    }

    public Loading getLoading() {
        Loading loading = (Loading)this._json.get(Attrs.loading);
        if (loading == null) {
            loading = new Loading();
            this.setLoading(loading);
        }
        return loading;
    }

    public void setLoading(Loading loading) {
        Loading old = (Loading)this._json.put(Attrs.loading, loading);
        if (old != loading) {
            this.addOptionDataListener(loading);
            this.removeOptionDataListener(old);
        }
    }

    public Navigation getNavigation() {
        Navigation navigation = (Navigation)this._json.get("navigation");
        if (navigation == null) {
            navigation = new Navigation();
            this.setNavigation(navigation);
        }
        return navigation;
    }

    public void setNavigation(Navigation navigation) {
        Navigation old = (Navigation)this._json.put(Attrs.navigation, navigation);
        if (old != navigation) {
            this.addOptionDataListener(navigation);
            this.removeOptionDataListener(old);
        }
    }

    private void addOptionDataListener(Optionable option) {
        if (option != null) {
            option.addOptionDataListener(this);
        }
    }

    private void removeOptionDataListener(Optionable option) {
        if (option != null) {
            option.removeOptionDataListener(this);
        }
    }

    public PlotOptions getPlotOptions() {
        PlotOptions plotOptions = (PlotOptions)this._json.get(Attrs.plotOptions);
        if (plotOptions == null) {
            plotOptions = new PlotOptions();
            this.setPlotOptions(plotOptions);
        }
        return plotOptions;
    }

    public void setPlotOptions(PlotOptions plotOptions) {
        PlotOptions old = (PlotOptions)this._json.put(Attrs.plotOptions, plotOptions);
        if (old != plotOptions) {
            this.addOptionDataListener(plotOptions);
            this.removeOptionDataListener(old);
        }
    }

    public Subtitle getSubtitle() {
        Subtitle subtitle = (Subtitle)this._json.get(Attrs.subtitle);
        if (subtitle == null) {
            subtitle = new Subtitle();
            this.setSubtitle(subtitle);
        }
        return subtitle;
    }

    public void setSubtitle(Subtitle subtitle) {
        Subtitle old = (Subtitle)this._json.put(Attrs.subtitle, subtitle);
        if (old != subtitle) {
            this.addOptionDataListener(subtitle);
            this.removeOptionDataListener(old);
        }
    }

    public Title getTitle() {
        Title title = (Title)this._json.get(Attrs.title);
        if (title == null) {
            title = new Title();
            this.setTitle(title);
        }
        return title;
    }

    public void setTitle(Title title) {
        Title old = (Title)this._json.put(Attrs.title, title);
        if (old != title) {
            this.addOptionDataListener(title);
            this.removeOptionDataListener(old);
        }
    }

    public Tooltip getTooltip() {
        Tooltip tooltip = (Tooltip)this._json.get(Attrs.tooltip);
        if (tooltip == null) {
            tooltip = new Tooltip();
            this.setTooltip(tooltip);
        }
        return tooltip;
    }

    public void setTooltip(Tooltip tooltip) {
        Tooltip old = (Tooltip)this._json.put(Attrs.tooltip, tooltip);
        if (old != tooltip) {
            this.addOptionDataListener(tooltip);
            this.removeOptionDataListener(old);
        }
    }

    public Pane getPane() {
        return this.getPane(0);
    }

    public int getPaneSize() {
        LinkedList list = (LinkedList)this._json.get(Attrs.pane);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public Pane getPane(int index) {
        int size;
        LinkedList<Pane> list = (LinkedList<Pane>)this._json.get(Attrs.pane);
        if (list == null) {
            list = new LinkedList<Pane>();
            this._json.put(Attrs.pane, list);
        }
        if ((size = list.size()) <= index) {
            for (int i = index - size + 1; i > 0; --i) {
                list.add(new Pane());
                this.charts.invalidate();
            }
        }
        return (Pane)list.get(index);
    }

    protected PlotData merge(PlotData other) {
        for (Map.Entry<PlotAttribute, Object> me : other._json.entrySet()) {
            Object o = this._json.get(me.getKey());
            if (o == null) {
                this._json.put(me.getKey(), me.getValue());
                continue;
            }
            if (o instanceof List) {
                List lo = (List)o;
                List lo2 = (List)me.getValue();
                int sizeOfLo = lo.size();
                for (int i = 0; i < lo2.size(); ++i) {
                    if (i >= sizeOfLo) {
                        lo.add(lo2.get(i));
                        continue;
                    }
                    ((Optionable)lo.get(i)).merge((Optionable)lo2.get(i));
                }
                continue;
            }
            if (o instanceof Optionable) {
                ((Optionable)o).merge((Optionable)me.getValue());
                continue;
            }
            throw new UiException("Unknown type: [" + o + "]");
        }
        return this;
    }

    public String toJSONString() {
        return JSONObject.toJSONString(this._json);
    }

    public int hashCode() {
        return this.toJSONString().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PlotData) {
            PlotData op = (PlotData)o;
            return this.toJSONString().equals(op.toJSONString());
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute
    {
        series,
        yAxis,
        xAxis,
        pane,
        navigation,
        chart,
        credits,
        labels,
        legend,
        plotOptions,
        subtitle,
        title,
        tooltip,
        loading,
        drilldown,
        colors,
        exporting,
        noData;

    }
}

