/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.util.DynamicalAttribute;

public class PaneBackground
extends Optionable {
    public Color getBackgroundColor() {
        if (!this.containsKey(Attrs.backgroundColor)) {
            LinearGradient linearGradient = new LinearGradient(0.0, 0.0, 0.0, 1.0);
            linearGradient.setStops("#FFF", "#DDD");
            this.setBackgroundColor(linearGradient);
        }
        return (Color)this.getAttr(Attrs.backgroundColor);
    }

    public void setBackgroundColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.backgroundColor, color, NOT_NULL_VALUE);
    }

    public void setBackgroundColor(String color) {
        this.setBackgroundColor(new Color(color));
    }

    public void setBackgroundColor(LinearGradient color) {
        this.setBackgroundColor(new Color(color));
    }

    public void setBackgroundColor(RadialGradient color) {
        this.setBackgroundColor(new Color(color));
    }

    public Number getBorderWidth() {
        return this.getAttr(Attrs.borderWidth, 0).asNumber();
    }

    public void setBorderWidth(Number borderWidth) {
        this.setAttr((PlotAttribute)Attrs.borderWidth, borderWidth, Integer.valueOf(0));
    }

    public Object getInnerRadius() {
        return this.getAttr(Attrs.innerRadius, 0).asValue();
    }

    public void setInnerRadius(Number innerRadius) {
        this.setAttr((PlotAttribute)Attrs.innerRadius, innerRadius, Integer.valueOf(0));
    }

    public void setInnerRadius(String innerRadius) {
        this.setAttr((PlotAttribute)Attrs.innerRadius, innerRadius, Integer.valueOf(0));
    }

    public Number getInnerWidth() {
        return this.getAttr(Attrs.innerWidth, 0).asNumber();
    }

    public void setInnerWidth(Number innerWidth) {
        this.setAttr((PlotAttribute)Attrs.innerWidth, innerWidth, Integer.valueOf(0));
    }

    public Object getOuterRadius() {
        return this.getAttr(Attrs.outerRadius, "105%").asString();
    }

    public void setOuterRadius(String outerRadius) {
        this.setAttr((PlotAttribute)Attrs.outerRadius, outerRadius, "105%");
    }

    public void setOuterRadius(Number outerRadius) {
        this.setAttr((PlotAttribute)Attrs.outerRadius, outerRadius, "105%");
    }

    public Number getOuterWidth() {
        return this.getAttr(Attrs.outerWidth, 0).asNumber();
    }

    public void setOuterWidth(Number outerWidth) {
        this.setAttr((PlotAttribute)Attrs.outerWidth, outerWidth, Integer.valueOf(0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        backgroundColor,
        borderColor,
        borderWidth,
        innerRadius,
        innerWidth,
        outerRadius,
        outerWidth;

    }
}

