/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.zkoss.chart.Color;
import org.zkoss.chart.OptionDataEvent;
import org.zkoss.chart.OptionDataListener;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.AnyVal;
import org.zkoss.chart.util.DeferredCall;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.JSFunction;
import org.zkoss.io.Serializables;
import org.zkoss.json.JSONAware;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JSONValue;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Optionable
implements JSONAware,
OptionDataListener {
    protected Map<String, AnyVal<Object>> options = new LinkedHashMap<String, AnyVal<Object>>(5);
    private Set<OptionDataListener> _listeners = new HashSet<OptionDataListener>();
    protected static String NOT_NULL_VALUE = "ZnotNullValueKChart";

    protected <T extends Optionable> T fireEvent(OptionDataEvent.EventType type, PlotAttribute key, Object value) {
        return this.fireEvent(type, ((Object)key).toString(), value, null);
    }

    protected <T extends Optionable> T fireEvent(OptionDataEvent.EventType type, PlotAttribute key, Object value, DeferredCall call) {
        return this.fireEvent(type, ((Object)key).toString(), value, call);
    }

    protected <T extends Optionable> T fireEvent(OptionDataEvent.EventType type, String key, Object value, DeferredCall call) {
        OptionDataEvent evt = new OptionDataEvent(this, type, key, value, call);
        return this.fireEvent(evt);
    }

    protected <T extends Optionable> T fireEvent(OptionDataEvent.EventType type, String key, Object value, String key2, Object value2, Object ... pairs) {
        OptionDataEvent evt = new OptionDataEvent(this, type, key, value, key2, value2, pairs);
        return this.fireEvent(evt);
    }

    protected <T extends Optionable> T fireEvent(OptionDataEvent event) {
        for (OptionDataListener l : this._listeners) {
            l.onChange(event);
        }
        return (T)this;
    }

    public <T extends Optionable> T addOptionDataListener(OptionDataListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this._listeners.add(l);
        return (T)this;
    }

    public <T extends Optionable> T removeOptionDataListener(OptionDataListener l) {
        this._listeners.remove(l);
        return (T)this;
    }

    public <T extends Optionable> T clearOptonDataListener() {
        this._listeners.clear();
        return (T)this;
    }

    public void getClientState(final String attr, EventListener<Event> listener) {
        this.fireEvent(OptionDataEvent.EventType.ECHO, attr, listener, new DeferredCall(){

            public void execute(JSFunction func) {
                func.evalAttribute(attr);
            }
        });
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, this._listeners);
        Serializables.smartWrite((ObjectOutputStream)s, this.options);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedHashSet<OptionDataListener>();
        this.options = new LinkedHashMap<String, AnyVal<Object>>();
        Serializables.smartRead((ObjectInputStream)s, this._listeners);
        Serializables.smartRead((ObjectInputStream)s, this.options);
    }

    public Object clone() {
        Optionable clone;
        try {
            clone = (Optionable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._listeners = new LinkedHashSet<OptionDataListener>();
        clone.options = new LinkedHashMap<String, AnyVal<Object>>(this.options);
        return clone;
    }

    protected boolean setAttr(PlotAttribute key, Object value) {
        return this.setAttr(key, value, null);
    }

    protected <T> boolean setAttr(PlotAttribute key, Object value, T defaultValue) {
        Object oldValue;
        String strKey = ((Object)key).toString();
        AnyVal<Object> old = this.options.get(strKey);
        Object object = oldValue = old != null ? old.asValue() : defaultValue;
        if (!Objects.equals(oldValue, (Object)value)) {
            this.options.put(strKey, new AnyVal<Object>(value));
            if (value instanceof Optionable) {
                ((Optionable)value).addOptionDataListener(this);
            }
            if (key instanceof DynamicalAttribute) {
                this.fireEvent(OptionDataEvent.EventType.CHANGED, key, value);
            }
            if (oldValue instanceof Optionable) {
                ((Optionable)oldValue).removeOptionDataListener(this);
            }
            return true;
        }
        return false;
    }

    protected <T> boolean setAttr(PlotAttribute key, Color value, T defaultValue) {
        String newColor;
        String strKey = ((Object)key).toString();
        AnyVal<Object> old = this.options.get(strKey);
        String oldColor = old != null ? old.asValue().toString() : JSONValue.toJSONString(defaultValue);
        if (!Objects.equals((Object)oldColor, (Object)(newColor = JSONValue.toJSONString((Object)value)))) {
            Object oldValue;
            this.options.put(strKey, new AnyVal<Color>(value));
            if (value instanceof Optionable) {
                value.addOptionDataListener(this);
            }
            if (key instanceof DynamicalAttribute) {
                this.fireEvent(OptionDataEvent.EventType.CHANGED, key, value);
            }
            if (old != null && (oldValue = old.asValue()) instanceof Optionable) {
                ((Optionable)oldValue).removeOptionDataListener(this);
            }
            return true;
        }
        return false;
    }

    protected <T> AnyVal<T> getAttr(PlotAttribute key, T defaultValue) {
        String strKey = ((Object)key).toString();
        if (this.options.containsKey(strKey)) {
            return this.options.get(strKey);
        }
        if (defaultValue != null && !(defaultValue instanceof String) && !(defaultValue instanceof Number)) {
            if (defaultValue instanceof Class) {
                try {
                    Object o = Classes.newInstance((Class)((Class)defaultValue), null);
                    this.setAttr(key, o);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.setAttr(key, defaultValue);
            }
            return this.options.get(strKey);
        }
        return new AnyVal<T>(defaultValue);
    }

    protected boolean containsKey(PlotAttribute key) {
        return this.options.containsKey(((Object)key).toString());
    }

    protected Object removeKey(PlotAttribute key, boolean triggerEvent) {
        AnyVal<Object> result = this.options.remove(((Object)key).toString());
        Object val = null;
        if (result != null) {
            val = result.asValue();
        }
        if (triggerEvent && key instanceof DynamicalAttribute) {
            this.fireEvent(OptionDataEvent.EventType.REMOVED, key, result);
        }
        return val;
    }

    protected Optionable merge(Optionable other) {
        this.options.putAll(other.options);
        return this;
    }

    protected Object getAttr(PlotAttribute key) {
        return this.getAttr(key, null).asValue();
    }

    public Object addExtraAttr(String key, JSONAware value) {
        AnyVal<JSONAware> old = this.options.put(key, new AnyVal<JSONAware>(value));
        if (old != null) {
            return old.asValue();
        }
        return null;
    }

    public Object removeExtraAttr(String key) {
        AnyVal<Object> remove = this.options.remove(key);
        if (remove != null) {
            return remove.asValue();
        }
        return null;
    }

    public String toJSONString() {
        return JSONObject.toJSONString(this.options);
    }

    public String toString() {
        return this.toJSONString();
    }

    @Override
    public void onChange(OptionDataEvent event) {
        event.setCurrentTarget(this);
        this.fireEvent(event);
    }
}

