/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.util.DeferredCall;
import org.zkoss.chart.util.JSFunction;
import org.zkoss.json.JSONAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionDataEvent
implements JSONAware {
    private Optionable _target;
    private Optionable _currentTarget;
    private EventType _type;
    private HashMap<String, Object> _attrMap;
    private LinkedList<DeferredCall> _funcs = new LinkedList();
    private boolean _updateCall;

    public OptionDataEvent(Optionable optionable, EventType type, Object ... pair) {
        this._target = optionable;
        this._type = type;
        this._attrMap = new HashMap(2);
        if (pair.length == 3) {
            this._attrMap.put((String)pair[0], pair[1]);
            if (pair[2] instanceof Object[]) {
                Object[] pairs = (Object[])pair[2];
                for (int i = 0; i < pairs.length; i += 2) {
                    this._attrMap.put((String)pairs[i], pairs[i + 1]);
                }
            } else if (pair[2] instanceof DeferredCall) {
                this._funcs.add((DeferredCall)pair[2]);
            }
        } else if (pair.length > 3) {
            for (int i = 0; i < pair.length; i += 2) {
                this._attrMap.put((String)pair[i], pair[i + 1]);
            }
        } else {
            this._attrMap.put((String)pair[0], pair[1]);
        }
    }

    public Optionable getOriginTarget() {
        return this._target;
    }

    public void setCurrentTarget(Optionable current) {
        this._currentTarget = current;
    }

    public Optionable getTarget() {
        return this._currentTarget != null ? this._currentTarget : this.getOriginTarget();
    }

    public EventType getType() {
        return this._type;
    }

    public Object getValue(String key) {
        return this._attrMap.get(key);
    }

    public String getKey() {
        return this._attrMap.keySet().iterator().next();
    }

    public Set<String> getKeys() {
        return this._attrMap.keySet();
    }

    public OptionDataEvent addJSFunctionCall(DeferredCall call) {
        this._funcs.add(call);
        return this;
    }

    public OptionDataEvent setJSUpdateCall(boolean updateCall) {
        this._updateCall = updateCall;
        return this;
    }

    public boolean isJSUpldateCall() {
        return this._updateCall;
    }

    public boolean hasJSFunctionCall() {
        return !this._funcs.isEmpty();
    }

    public String toJSONString() {
        JSFunction func = new JSFunction();
        for (DeferredCall f : this._funcs) {
            f.execute(func);
        }
        if (this._type == EventType.ECHO) {
            return func.reverse().toReturnFunction();
        }
        if (this._type == EventType.INITIALIZED) {
            return func.reverse().toExecFunction();
        }
        return func.reverse().toWrapFunction();
    }

    public String toString() {
        return this.toJSONString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        INITIALIZED,
        CHANGED,
        ADDED,
        REMOVED,
        SELECTED,
        DESTROYED,
        ECHO,
        INVOKE;

    }
}

