/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.States;
import org.zkoss.chart.util.DynamicalAttribute;

public class Marker
extends Optionable {
    public boolean isEnabled() {
        return this.getAttr(Attrs.enabled, true).asBoolean();
    }

    public void setEnabled(boolean enabled) {
        this.setAttr(Attrs.enabled, enabled);
    }

    public Color getFillColor() {
        return (Color)this.getAttr(Attrs.fillColor, null).asValue();
    }

    public void setFillColor(Color color) {
        this.setAttr(Attrs.fillColor, color);
    }

    public void setFillColor(String color) {
        this.setFillColor(new Color(color));
    }

    public void setFillColor(LinearGradient color) {
        this.setFillColor(new Color(color));
    }

    public void setFillColor(RadialGradient color) {
        this.setFillColor(new Color(color));
    }

    public Color getLineColor() {
        if (!this.containsKey(Attrs.lineColor)) {
            this.setLineColor("#FFFFFF");
        }
        return (Color)this.getAttr(Attrs.lineColor);
    }

    public void setLineColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.lineColor, color, NOT_NULL_VALUE);
    }

    public void setLineColor(String color) {
        this.setLineColor(new Color(color));
    }

    public void setLineColor(LinearGradient color) {
        this.setLineColor(new Color(color));
    }

    public void setLineColor(RadialGradient color) {
        this.setLineColor(new Color(color));
    }

    public Number getLineWidth() {
        return this.getAttr(Attrs.lineWidth, 0).asNumber();
    }

    public void setLineWidth(Number lineWidth) {
        this.setAttr((PlotAttribute)Attrs.lineWidth, lineWidth, Integer.valueOf(0));
    }

    public Number getRadius() {
        return this.getAttr(Attrs.radius, 4).asNumber();
    }

    public void setRadius(Number radius) {
        this.setAttr((PlotAttribute)Attrs.radius, radius, Integer.valueOf(4));
    }

    public States getStates() {
        States states = (States)this.getAttr(Attrs.states);
        if (states == null) {
            states = new States();
            this.setStates(states);
        }
        return states;
    }

    public void setStates(States states) {
        this.setAttr(Attrs.states, states);
    }

    public String getSymbol() {
        return this.getAttr(Attrs.symbol, null).asString();
    }

    public void setSymbol(String symbol) {
        if (!(symbol == null || "circle".equals(symbol) || "square".equals(symbol) || "diamond".equals(symbol) || "triangle".equals(symbol) || "triangle-down".equals(symbol) || symbol.matches("url(.*)"))) {
            throw new IllegalArgumentException("Unsupported symbol: [" + symbol + "]");
        }
        this.setAttr(Attrs.symbol, symbol);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        enabled,
        fillColor,
        lineColor,
        lineWidth,
        radius,
        states,
        symbol;

    }
}

