/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.chart.Animation;
import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegendNavigation
extends Optionable {
    public Color getActiveColor() {
        if (!this.containsKey(Attrs.activeColor)) {
            this.setActiveColor("#3E576F");
        }
        return (Color)this.getAttr(Attrs.activeColor);
    }

    public void setActiveColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.activeColor, color, NOT_NULL_VALUE);
    }

    public void setActiveColor(String color) {
        this.setActiveColor(new Color(color));
    }

    public void setActiveColor(LinearGradient color) {
        this.setActiveColor(new Color(color));
    }

    public void setActiveColor(RadialGradient color) {
        this.setActiveColor(new Color(color));
    }

    public boolean isAnimation() {
        return this.getAnimation() != Animation.NONE;
    }

    public Animation getAnimation() {
        return (Animation)this.getAttr(Attrs.animation, Animation.class).asValue();
    }

    public void setAnimation(boolean animation) {
        this.setAnimation(animation ? new Animation() : Animation.NONE);
    }

    public void setAnimation(Animation animation) {
        this.setAttr(Attrs.animation, animation == null ? Animation.NONE : animation);
    }

    public Number getArrowSize() {
        return this.getAttr(Attrs.arrowSize, 12).asNumber();
    }

    public void setArrowSize(Number arrowSize) {
        this.setAttr((PlotAttribute)Attrs.arrowSize, arrowSize, Integer.valueOf(12));
    }

    public Color getIninactiveColor() {
        if (!this.containsKey(Attrs.inactiveColor)) {
            this.setIninactiveColor("#CCC");
        }
        return (Color)this.getAttr(Attrs.inactiveColor);
    }

    public void setIninactiveColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.inactiveColor, color, NOT_NULL_VALUE);
    }

    public void setIninactiveColor(String color) {
        this.setIninactiveColor(new Color(color));
    }

    public void setIninactiveColor(LinearGradient color) {
        this.setIninactiveColor(new Color(color));
    }

    public void setIninactiveColor(RadialGradient color) {
        this.setIninactiveColor(new Color(color));
    }

    public <K, V> Map<K, V> getStyle() {
        return (Map)Generics.cast((Object)this.getAttr(Attrs.style, null).asValue());
    }

    public void setStyle(String style) {
        this.setStyle(MapsHelper.parse(new LinkedHashMap(), style, ':', ';', '\''));
    }

    public <K, V> void setStyle(Map<K, V> style) {
        this.setAttr(Attrs.style, style);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        activeColor,
        animation,
        arrowSize,
        inactiveColor,
        style;

    }
}

