/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.chart.Color;
import org.zkoss.chart.LegendNavigation;
import org.zkoss.chart.LegendTitle;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.Shadow;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Legend
extends Optionable {
    public String getAlign() {
        return this.getAttr(Attrs.align, "center").asString();
    }

    public void setAlign(String align) {
        if (!("left".equals(align) || "center".equals(align) || "right".equals(align))) {
            throw new IllegalArgumentException("Unsupported align: [" + align + "]");
        }
        this.setAttr((PlotAttribute)Attrs.align, align, "center");
    }

    public Color getBackgroundColor() {
        return (Color)this.getAttr(Attrs.backgroundColor, null).asValue();
    }

    public void setBackgroundColor(Color color) {
        this.setAttr(Attrs.backgroundColor, color);
    }

    public void setBackgroundColor(String color) {
        this.setBackgroundColor(new Color(color));
    }

    public void setBackgroundColor(LinearGradient color) {
        this.setBackgroundColor(new Color(color));
    }

    public void setBackgroundColor(RadialGradient color) {
        this.setBackgroundColor(new Color(color));
    }

    public Color getBorderColor() {
        if (!this.containsKey(Attrs.borderColor)) {
            this.setBorderColor("#909090");
        }
        return (Color)this.getAttr(Attrs.borderColor);
    }

    public void setBorderColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.borderColor, color, NOT_NULL_VALUE);
    }

    public void setBorderColor(String color) {
        this.setBorderColor(new Color(color));
    }

    public void setBorderColor(LinearGradient color) {
        this.setBorderColor(new Color(color));
    }

    public void setBorderColor(RadialGradient color) {
        this.setBorderColor(new Color(color));
    }

    public Number getBorderRadius() {
        return this.getAttr(Attrs.borderRadius, 5).asNumber();
    }

    public void setBorderRadius(Number borderRadius) {
        this.setAttr((PlotAttribute)Attrs.borderRadius, borderRadius, Integer.valueOf(5));
    }

    public Number getBorderWidth() {
        return this.getAttr(Attrs.borderWidth, 1).asNumber();
    }

    public void setBorderWidth(Number borderWidth) {
        this.setAttr((PlotAttribute)Attrs.borderWidth, borderWidth, Integer.valueOf(1));
    }

    public boolean isEnabled() {
        return this.getAttr(Attrs.enabled, true).asBoolean();
    }

    public void setEnabled(boolean enabled) {
        this.setAttr(Attrs.enabled, enabled);
    }

    public boolean isFloating() {
        return this.getAttr(Attrs.floating, false).asBoolean();
    }

    public void setFloating(boolean floating) {
        this.setAttr(Attrs.floating, floating);
    }

    public Number getItemDistance() {
        return this.getAttr(Attrs.itemDistance, 8).asNumber();
    }

    public void setItemDistance(Number itemDistance) {
        this.setAttr((PlotAttribute)Attrs.itemDistance, itemDistance, Integer.valueOf(8));
    }

    public <K, V> Map<K, V> getItemHiddenStyle() {
        if (!this.containsKey(Attrs.itemHiddenStyle)) {
            this.setItemHiddenStyle("color: #CCC;");
        }
        return (Map)Generics.cast((Object)this.getAttr(Attrs.itemHiddenStyle));
    }

    public void setItemHiddenStyle(String itemHiddenStyle) {
        this.setItemHiddenStyle(MapsHelper.parse(new LinkedHashMap(), itemHiddenStyle, ':', ';', '\''));
    }

    public <K, V> void setItemHiddenStyle(Map<K, V> itemHiddenStyle) {
        this.setAttr((PlotAttribute)Attrs.itemHiddenStyle, itemHiddenStyle, NOT_NULL_VALUE);
    }

    public <K, V> Map<K, V> getItemHoverStyle() {
        if (!this.containsKey(Attrs.itemHoverStyle)) {
            this.setItemHoverStyle("color: #CCC;");
        }
        return (Map)Generics.cast((Object)this.getAttr(Attrs.itemHoverStyle));
    }

    public void setItemHoverStyle(String itemHoverStyle) {
        this.setItemHoverStyle(MapsHelper.parse(new LinkedHashMap(), itemHoverStyle, ':', ';', '\''));
    }

    public <K, V> void setItemHoverStyle(Map<K, V> itemHoverStyle) {
        this.setAttr((PlotAttribute)Attrs.itemHoverStyle, itemHoverStyle, NOT_NULL_VALUE);
    }

    public Number getItemMarginBottom() {
        return this.getAttr(Attrs.itemMarginBottom, 0).asNumber();
    }

    public void setItemMarginBottom(Number itemMarginBottom) {
        this.setAttr((PlotAttribute)Attrs.itemMarginBottom, itemMarginBottom, Integer.valueOf(0));
    }

    public Number getItemMarginTop() {
        return this.getAttr(Attrs.itemMarginTop, 0).asNumber();
    }

    public void setItemMarginTop(Number itemMarginTop) {
        this.setAttr((PlotAttribute)Attrs.itemMarginTop, itemMarginTop, Integer.valueOf(0));
    }

    public <K, V> Map<K, V> getItemStyle() {
        if (!this.containsKey(Attrs.itemStyle)) {
            this.setItemStyle("cursor: pointer; color: #274b6d; fontSize: 12px;");
        }
        return (Map)Generics.cast((Object)this.getAttr(Attrs.itemStyle));
    }

    public void setItemStyle(String itemStyle) {
        this.setItemStyle(MapsHelper.parse(new LinkedHashMap(), itemStyle, ':', ';', '\''));
    }

    public <K, V> void setItemStyle(Map<K, V> itemStyle) {
        this.setAttr((PlotAttribute)Attrs.itemStyle, itemStyle, NOT_NULL_VALUE);
    }

    public Number getItemWidth() {
        return this.getAttr(Attrs.itemWidth, null).asNumber();
    }

    public void setItemWidth(Number itemWidth) {
        this.setAttr(Attrs.itemWidth, itemWidth);
    }

    public String getLabelFormat() {
        return this.getAttr(Attrs.labelFormat, "{name}").asString();
    }

    public void setLabelFormat(String labelFormat) {
        this.setAttr((PlotAttribute)Attrs.labelFormat, labelFormat, "{name}");
    }

    public String getLayout() {
        return this.getAttr(Attrs.layout, "horizontal").asString();
    }

    public void setLayout(String layout) {
        if (!"horizontal".equals(layout) && !"vertical".equals(layout)) {
            throw new IllegalArgumentException("Unsupported Layout: [" + layout + "]");
        }
        this.setAttr((PlotAttribute)Attrs.layout, layout, "horizontal");
    }

    public Number getMargin() {
        return this.getAttr(Attrs.margin, 15).asNumber();
    }

    public void setMargin(Number margin) {
        this.setAttr((PlotAttribute)Attrs.margin, margin, Integer.valueOf(15));
    }

    public Number getMaxHeight() {
        return this.getAttr(Attrs.maxHeight, 0).asNumber();
    }

    public void setMaxHeight(Number maxHeight) {
        this.setAttr((PlotAttribute)Attrs.maxHeight, maxHeight, Integer.valueOf(0));
    }

    public LegendNavigation getNavigation() {
        LegendNavigation navigation = (LegendNavigation)this.getAttr(Attrs.navigation);
        if (navigation == null) {
            navigation = new LegendNavigation();
            this.setNavigation(navigation);
        }
        return navigation;
    }

    public void setNavigation(LegendNavigation navigation) {
        this.setAttr(Attrs.navigation, navigation);
    }

    public Number getPadding() {
        return this.getAttr(Attrs.padding, 8).asNumber();
    }

    public void setPadding(Number padding) {
        this.setAttr((PlotAttribute)Attrs.padding, padding, Integer.valueOf(8));
    }

    public boolean isReversed() {
        return this.getAttr(Attrs.reversed, false).asBoolean();
    }

    public void setReversed(boolean reversed) {
        this.setAttr(Attrs.reversed, reversed);
    }

    public boolean isRtl() {
        return this.getAttr(Attrs.rtl, false).asBoolean();
    }

    public void setRtl(boolean rtl) {
        this.setAttr(Attrs.rtl, rtl);
    }

    public boolean isShadow() {
        return this.getShadow() != Shadow.NONE;
    }

    public Shadow getShadow() {
        return (Shadow)this.getAttr(Attrs.shadow, Shadow.NONE).asValue();
    }

    public void setShadow(boolean shadow) {
        this.setShadow(shadow ? new Shadow() : Shadow.NONE);
    }

    public void setShadow(Shadow shadow) {
        this.setAttr(Attrs.shadow, shadow);
    }

    public Number getSymbolHeight() {
        return this.getAttr(Attrs.symbolHeight, 12).asNumber();
    }

    public void setSymbolHeight(Number symbolHeight) {
        this.setAttr((PlotAttribute)Attrs.symbolHeight, symbolHeight, Integer.valueOf(12));
    }

    public Number getSymbolPadding() {
        return this.getAttr(Attrs.symbolPadding, 5).asNumber();
    }

    public void setSymbolPadding(Number symbolPadding) {
        this.setAttr((PlotAttribute)Attrs.symbolPadding, symbolPadding, Integer.valueOf(5));
    }

    public Number getSymbolRadius() {
        return this.getAttr(Attrs.symbolRadius, 2).asNumber();
    }

    public void setSymbolRadius(Number symbolRadius) {
        this.setAttr((PlotAttribute)Attrs.symbolRadius, symbolRadius, Integer.valueOf(2));
    }

    public Number getSymbolWidth() {
        return this.getAttr(Attrs.symbolWidth, 16).asNumber();
    }

    public void setSymbolWidth(Number symbolWidth) {
        this.setAttr((PlotAttribute)Attrs.symbolWidth, symbolWidth, Integer.valueOf(16));
    }

    public LegendTitle getTitle() {
        LegendTitle title = (LegendTitle)this.getAttr(Attrs.title);
        if (title == null) {
            title = new LegendTitle();
            this.setTitle(title);
        }
        return title;
    }

    public void setTitle(LegendTitle title) {
        this.setAttr(Attrs.title, title);
    }

    public boolean isUseHTML() {
        return this.getAttr(Attrs.useHTML, false).asBoolean();
    }

    public void setUseHTML(boolean useHTML) {
        this.setAttr(Attrs.useHTML, useHTML);
    }

    public String getVerticalAlign() {
        return this.getAttr(Attrs.verticalAlign, "bottom").asString();
    }

    public void setVerticalAlign(String verticalAlign) {
        if (!("top".equals(verticalAlign) || "middle".equals(verticalAlign) || "bottom".equals(verticalAlign))) {
            throw new IllegalArgumentException("Unsupported vertical align: [" + verticalAlign + "]");
        }
        this.setAttr((PlotAttribute)Attrs.verticalAlign, verticalAlign, "bottom");
    }

    public Number getWidth() {
        return this.getAttr(Attrs.width, null).asNumber();
    }

    public void setWidth(Number width) {
        this.setAttr(Attrs.width, width);
    }

    public Number getX() {
        return this.getAttr(Attrs.x, 0).asNumber();
    }

    public void setX(Number x) {
        this.setAttr((PlotAttribute)Attrs.x, x, Integer.valueOf(0));
    }

    public Number getY() {
        return this.getAttr(Attrs.y, 0).asNumber();
    }

    public void setY(Number y) {
        this.setAttr((PlotAttribute)Attrs.y, y, Integer.valueOf(0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        align,
        backgroundColor,
        borderColor,
        borderRadius,
        borderWidth,
        enabled,
        floating,
        itemDistance,
        itemHiddenStyle,
        itemHoverStyle,
        itemMarginBottom,
        itemMarginTop,
        itemStyle,
        itemWidth,
        labelFormat,
        layout,
        margin,
        maxHeight,
        navigation,
        padding,
        reversed,
        rtl,
        shadow,
        style,
        symbolHeight,
        symbolPadding,
        symbolRadius,
        symbolWidth,
        title,
        useHTML,
        verticalAlign,
        width,
        x,
        y;

    }
}

