/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.List;
import java.util.Map;
import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportingButton
extends Optionable {
    public String getAlign() {
        return this.getAttr(Attrs.align, "right").asString();
    }

    public void setAlign(String align) {
        this.setAttr((PlotAttribute)Attrs.align, align, "right");
    }

    public boolean isEnabled() {
        return this.getAttr(Attrs.enabled, true).asBoolean();
    }

    public void setEnabled(boolean enabled) {
        this.setAttr(Attrs.enabled, enabled);
    }

    public Number getHeight() {
        return this.getAttr(Attrs.height, 20).asNumber();
    }

    public void setHeight(Number height) {
        this.setAttr((PlotAttribute)Attrs.height, height, Integer.valueOf(20));
    }

    public <T> void setMenuItems(List<T> menuItems) {
        this.setAttr(Attrs.menuItems, menuItems);
    }

    public <T> List<T> getMenuItems() {
        return (List)Generics.cast((Object)this.getAttr(Attrs.menuItems, null).asValue());
    }

    public String getSymbol() {
        return this.getAttr(Attrs.symbol, "menu").asString();
    }

    public void setSymbol(String symbol) {
        this.setAttr((PlotAttribute)Attrs.symbol, symbol, "menu");
    }

    public Color getSymbolFill() {
        if (!this.containsKey(Attrs.symbolFill)) {
            this.setSymbolFill("#A8BF77");
        }
        return (Color)this.getAttr(Attrs.symbolFill);
    }

    public void setSymbolFill(Color color) {
        this.setAttr((PlotAttribute)Attrs.symbolFill, color, NOT_NULL_VALUE);
    }

    public void setSymbolFill(String color) {
        this.setSymbolFill(new Color(color));
    }

    public void setSymbolFill(LinearGradient color) {
        this.setSymbolFill(new Color(color));
    }

    public void setSymbolFill(RadialGradient color) {
        this.setSymbolFill(new Color(color));
    }

    public Number getSymbolSize() {
        return this.getAttr(Attrs.symbolSize, 14).asNumber();
    }

    public void setSymbolSize(Number symbolSize) {
        this.setAttr((PlotAttribute)Attrs.symbolSize, symbolSize, Integer.valueOf(14));
    }

    public Color getSymbolStroke() {
        if (!this.containsKey(Attrs.symbolStroke)) {
            this.setSymbolStroke("#666");
        }
        return (Color)this.getAttr(Attrs.symbolStroke);
    }

    public void setSymbolStroke(Color color) {
        this.setAttr((PlotAttribute)Attrs.symbolStroke, color, NOT_NULL_VALUE);
    }

    public void setSymbolStroke(String color) {
        this.setSymbolStroke(new Color(color));
    }

    public void setSymbolStroke(LinearGradient color) {
        this.setSymbolStroke(new Color(color));
    }

    public void setSymbolStroke(RadialGradient color) {
        this.setSymbolStroke(new Color(color));
    }

    public Number getSymbolStrokeWidth() {
        return this.getAttr(Attrs.symbolStrokeWidth, 1).asNumber();
    }

    public void setSymbolStrokeWidth(Number symbolStrokeWidth) {
        this.setAttr(Attrs.symbolStrokeWidth, symbolStrokeWidth);
    }

    public Number getSymbolX() {
        return this.getAttr(Attrs.symbolX, 12.5).asNumber();
    }

    public void setSymbolX(Number symbolX) {
        this.setAttr((PlotAttribute)Attrs.symbolX, symbolX, Double.valueOf(12.5));
    }

    public Number getSymbolY() {
        return this.getAttr(Attrs.symbolY, 10.5).asNumber();
    }

    public void setSymbolY(Number symbolY) {
        this.setAttr((PlotAttribute)Attrs.symbolY, symbolY, Double.valueOf(10.5));
    }

    public String getText() {
        return this.getAttr(Attrs.text, null).asString();
    }

    public void setText(String text) {
        this.setAttr(Attrs.text, text);
    }

    public <K, V> Map<K, V> getTheme() {
        return (Map)Generics.cast((Object)this.getAttr(Attrs.theme, null).asValue());
    }

    public <K, V> void setTheme(Map<K, V> theme) {
        this.setAttr(Attrs.theme, theme);
    }

    public String getVerticalAlign() {
        return this.getAttr(Attrs.verticalAlign, "top").asString();
    }

    public void setVerticalAlign(String verticalAlign) {
        if (!("top".equals(verticalAlign) || "middle".equals(verticalAlign) || "bottom".equals(verticalAlign))) {
            throw new IllegalArgumentException("Unsupported vertical align: [" + verticalAlign + "]");
        }
        this.setAttr((PlotAttribute)Attrs.verticalAlign, verticalAlign, "top");
    }

    public Number getWidth() {
        return this.getAttr(Attrs.width, 24).asNumber();
    }

    public void setWidth(Number width) {
        this.setAttr((PlotAttribute)Attrs.width, width, Integer.valueOf(24));
    }

    public Number getX() {
        return this.getAttr(Attrs.x, -10).asNumber();
    }

    public void setX(Number x) {
        this.setAttr((PlotAttribute)Attrs.x, x, Integer.valueOf(-10));
    }

    public Number getY() {
        return this.getAttr(Attrs.y, 0).asNumber();
    }

    public void setY(Number y) {
        this.setAttr((PlotAttribute)Attrs.y, y, Integer.valueOf(0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        align,
        enabled,
        height,
        menuItems,
        symbol,
        symbolFill,
        symbolSize,
        symbolStroke,
        symbolStrokeWidth,
        symbolX,
        symbolY,
        text,
        theme,
        verticalAlign,
        width,
        x,
        y;

    }
}

