/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.json.JSONValue;

public class Color
extends Optionable {
    public Color(String color) {
        this.setColor(color);
    }

    public Color(LinearGradient color) {
        this.setColor(color);
    }

    public Color(RadialGradient color) {
        this.setColor(color);
    }

    public void setColor(String color) {
        this.setAttr(Attrs.color, color);
    }

    public void setColor(LinearGradient linear) {
        this.setAttr(Attrs.linearGradient, linear);
    }

    public void setColor(RadialGradient radial) {
        this.setAttr(Attrs.radialGradient, radial);
    }

    public String stringValue() {
        return this.getAttr(Attrs.color, null).asString();
    }

    public LinearGradient linearValue() {
        return (LinearGradient)this.getAttr(Attrs.linearGradient, null).asValue();
    }

    public RadialGradient radialValue() {
        return (RadialGradient)this.getAttr(Attrs.radialGradient, null).asValue();
    }

    public String toJSONString() {
        String color = this.stringValue();
        if (color != null) {
            return JSONValue.toJSONString((Object)color);
        }
        LinearGradient linear = this.linearValue();
        if (linear != null) {
            return linear.toJSONString();
        }
        RadialGradient radial = this.radialValue();
        if (radial != null) {
            return radial.toJSONString();
        }
        return "null";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        color,
        linearGradient,
        radialGradient;

    }
}

