/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.Map;
import org.zkoss.chart.Charts;
import org.zkoss.chart.Point;
import org.zkoss.chart.Series;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartsEvent
extends Event {
    private static final long serialVersionUID = 20140121161322L;
    private int _sIndex = -1;
    private int _pIndex = -1;
    private boolean _checked = false;
    private Comparable<?> _category;

    public ChartsEvent(String name, Component target, int sIndex, int pIndex, Comparable<?> category, boolean checked) {
        super(name, target);
        this._sIndex = sIndex;
        this._pIndex = pIndex;
        this._checked = checked;
        this._category = category;
    }

    public static final ChartsEvent getChartsEvent(AuRequest request) {
        Map data = request.getData();
        return new ChartsEvent(request.getCommand(), request.getComponent(), AuRequests.getInt((Map)data, (String)"sIndex", (int)-1), AuRequests.getInt((Map)data, (String)"pIndex", (int)-1), (Comparable)data.get("category"), AuRequests.getBoolean((Map)data, (String)"checked"));
    }

    public Comparable<?> getCategory() {
        return this._category;
    }

    public int getPointIndex() {
        return this._pIndex;
    }

    public int getSeriesIndex() {
        return this._sIndex;
    }

    public boolean isChecked() {
        return this._checked;
    }

    public Point getPoint() {
        Series series = this.getSeries();
        if (series == null) {
            return null;
        }
        int pIndex = this.getPointIndex();
        if (pIndex < 0) {
            return null;
        }
        return series.getPoint(pIndex);
    }

    public Series getSeries() {
        int sIndex = this.getSeriesIndex();
        if (sIndex < 0) {
            return null;
        }
        return ((Charts)this.getTarget()).getSeries(sIndex);
    }
}

